--[[
   Copyright 2007-2018 The OpenRA Developers (see AUTHORS)
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

Levels =
{
	Multi0 = 0,
	Multi1 = 0,
	Multi2 = 0,
	Multi3 = 0,
	Multi4 = 0,
	Multi5 = 0,
}

Ranks = { "1", "2", "3", "4", "5", "6", "7" }
RankXPs = { 0, 800, 2400, 4800, 8000, 12000, 16800 }
--[[ RankXPs = { 0, 800, 1600, 2400, 3200, 4000, 4800 } ]]
PlayerCount = 6
Players = { }

WorldLoaded = function()
    for i=0, PlayerCount-1 do
        local player = Player.GetPlayer("Multi" .. i)
        if player then
            print("Added player Multi" .. i)
            table.insert(Players, player)
        else
            print("Player Multi" .. i .. " not valid. Skipping.")
        end
    end
end

Tick = function()
    TickScienceLevels()
end

TickScienceLevels = function()
	for _,player in pairs(Players) do
		if player.IsLocalPlayer then
			if Levels[player.InternalName] < 6 then
				UserInterface.SetMissionText("Current Tech Level: " .. Ranks[Levels[player.InternalName] + 1] .. "\nNext Tech Level: " .. player.Experience - RankXPs[Levels[player.InternalName] + 1] .. "/" .. RankXPs[Levels[player.InternalName] + 2] - RankXPs[Levels[player.InternalName] + 1] .. "", HSLColor.White)
			else
				UserInterface.SetMissionText("Current Tech Level: " .. Ranks[Levels[player.InternalName] + 1] .. "\nMaximum Tech Level ", HSLColor.White)
			end
		end

		if player.Experience >= RankXPs[2] and not (Levels[player.InternalName] > 0) then
			Levels[player.InternalName] = Levels[player.InternalName] + 1

			Actor.Create("techlevel.2", true, { Owner = player })
		end

		if player.Experience >= RankXPs[3] and not (Levels[player.InternalName] > 1) then
			Levels[player.InternalName] = Levels[player.InternalName] + 1

			Actor.Create("techlevel.3", true, { Owner = player })
		end

		if player.Experience >= RankXPs[4] and not (Levels[player.InternalName] > 2) then
			Levels[player.InternalName] = Levels[player.InternalName] + 1

			Actor.Create("techlevel.4", true, { Owner = player })
		end

		if player.Experience >= RankXPs[5] and not (Levels[player.InternalName] > 3) then
			Levels[player.InternalName] = Levels[player.InternalName] + 1

			Actor.Create("techlevel.5", true, { Owner = player })
		end

		if player.Experience >= RankXPs[6] and not (Levels[player.InternalName] > 4) then
			Levels[player.InternalName] = Levels[player.InternalName] + 1

			Actor.Create("techlevel.6", true, { Owner = player })
		end

		if player.Experience >= RankXPs[7] and not (Levels[player.InternalName] > 5) then
			Levels[player.InternalName] = Levels[player.InternalName] + 1

			Actor.Create("techlevel.7", true, { Owner = player })
		end
	end
end
