IsInit = false
Tips = {
	{TipName = "AboutMLRS", isRead = false, content = "These SSM Launchers have some deadly missle launching pods. Try not to get a direct hit.\nFind a way to approach them can make their targeting system failed to work.", override = false},
	{TipName = "About2TNK", isRead = false, content = "These medium tanks are now equipped close-range vulcans; be careful of not being too close to them.", override = false},
	{TipName = "About4TNK", isRead = false, content = "Mammoth tanks' missiles now can deal effective damage agianst vehicles...", override = false},
	{TipName = "About5TNK", isRead = false, content = "Prism Tank. Beware of their overwhelming firepower.", override = false},
	{TipName = "About6TNK", isRead = false, content = "These SP. Artilleries get excellent attack range and firepower but will become immobilized when reloading.", override = false},
	{TipName = "AboutVARP", isRead = false, content = "Deviators have the power to temporarily disalbe enemies' weapon system. You will not want to get too close to them.", override = false},
	{TipName = "AboutDIST", isRead = false, content = "Disruptors. They can deal massive area damage but cannot target close-range targets.", override = false},
	{TipName = "AboutExecutor", isRead = false, content = "Additional reinforcements will be called in when a denfensive structure is destroyed.", override = false},
	{TipName = "FirstWave", isRead = false, content = "The first wave will be sent in now.", override = false},
	{TipName = "Berserker", isRead = false, content = "You have unlocked Berserker mode. Press 'Deploy' button to activate or deactivate.\nWhen on, the Gladiator receives 300% bonus of the firepower\nand takes 250% of the damage", override = false},
	{TipName = "RunOutSupplies", isRead = false, content = "There will be no more paradrop supplies.", override = false},
	{TipName = "Impatience", isRead = false, content = "They cannot wait forever; here they comes.", override = true}
}
InitData = {
	{difficulty = "beginner", timer_sec = 1050, party_sendin_interval = 12, party_mutiplier = 10, required_score = 2500, required_waves = 10, paradrop_supply_limit = 20},
	{difficulty = "easy", timer_sec = 930, party_sendin_interval = 8, party_mutiplier = 8, required_score = 4750, required_waves = 16, paradrop_supply_limit = 12},
	{difficulty = "normal", timer_sec = 750, party_sendin_interval = 5, party_mutiplier = 1, required_score = 8000, required_waves = 22, paradrop_supply_limit = 6},
	{difficulty = "hard", timer_sec = 630, party_sendin_interval = 3, party_mutiplier = 0.5, required_score = 10000, required_waves = 36, paradrop_supply_limit = 3},
	{difficulty = "extreme", timer_sec = 540, party_sendin_interval = 1, party_mutiplier = 0.1, required_score = 15800, required_waves = 52, paradrop_supply_limit = 0}
}
Score = 0
DisplayedScore = 0
Score_Goal = 8000
-- Filled by functions; leave them empty.
Audience = { }
-- Filled by functions; leave them empty.
Crates = { }
-- Filled by functions; leave them empty.
Crate_Loc = { }
-- Filled by functions; leave them empty.
Defensive_Bldgs = { }
-- Filled by functions; leave them empty.
Flares = { }
-- Timer set by difficulties.
Ticked = 0
-- Total passed waves.
Wave_Count = 0
Wave_Goal = 30
Paradrop_Supply_Limit_Max = 6
Paradrop_Supply_Limit = 6
-- use this table to place addiontal cameras, like attaching to acotrs, etc.
CamerastoPlace = { }
ArenaEntryPt = { EntertheArenaCenter, EntertheArenaLeft, EntertheArenaRight }
ChallengerPartyList = {
	{ {"recn", 3}, {"apc", 2}, {"1tnk", 2} },
	{ {"3tnk", 2}, {"2tnk", 2}, {"v2rl", 2} },
	{ {"ftrk", 3}, {"nobg", 2}, {"huve", 2} },
	{ {"3tnk", 5}, {"2tnk", 1}, {"mlrs", 2} },
	{ {"mlrs", 3}, {"rklr", 4}, {"vapr", 3} },
	{ {"4tnk", 5}, {"6tnk", 1}, {"dist", 2} },
	{ {"6tnk", 5}, {"dvtr", 3}, {"4tnk", 3} },
	{ {"dvtr", 5}, {"ttnk", 3}, {"5tnk", 3} }
}
ChallengerPartySizeLevel = { 1, 2, 3, 4, 6, 8, 10, 12 }
ExecutorPartyList = {
	{ {"huve", 8}, {"nobg", 2} },
	{ {"v2rl2", 8}, {"nobg", 2} },
	{ {"mlrs2", 8}, {"huve", 2} },
	{ {"huve", 8}, {"huve2", 2} }
}
ExecutorPartySizeLevel = { 2, 4, 5, 2 }
ChallengerLevelStats = { {8, 12500}, {7, 9500}, {6, 5600}, {5, 3200}, {4, 900}, {3, 500}, {2, 300}, {1, 100} }
MissionBox = {
	{Player = Player.GetPlayer("Gladiator"), ObjectiveText = "Defeat the last Challenger when time runs out.", id = 0},
	{Player = Player.GetPlayer("Gladiator"), ObjectiveText = "Make the Score over N/A points before\ntime runs out.", id = 0},
	{Player = Player.GetPlayer("Gladiator"), ObjectiveText = "Defeat at least N/A waves of the Challengers\nbefore time runs out. (extra waves will be\ncounted as well)", id = 0},
	{Player = Player.GetPlayer("Challenger"), ObjectiveText = "Eliminate the Gladiator.", id = 0}
}
-- The speech audio files to be played.
SpeechSet = {
	{0, "AlliedReinforcementsArrived"}, {0.75, "AlliedForcesApproaching"},
	{1, "WarningOneMinuteRemaining"}, {2, "WarningTwoMinutesRemaining"},
	{3, "WarningThreeMinutesRemaining"}, {4,"WarningFourMinutesRemaining"},
	{5, "WarningFiveMinutesRemaining"},	{10, "TenMinutesRemaining"},
	{20, "TwentyMinutesRemaining"}
}

-- Increase or decrease total party members when sending in
TweakPartySize = function(party, div)
	if type(party) == "table" and type(div) == "number" then
		if #party >= 1 and div ~= 0 then
			for x = 1, #party, 1 do
				party[x] = math.ceil(party[x]/div)
			end
			return true
		else
			return false
		end
	else
		return false
	end
end

---Light up the flares using table collection.
---@param IsDirectLightUp? boolean
---@param player_color? player
---@return boolean
LightUpFlare = function (IsDirectLightUp, player_color)
	if #Flares > 0 then
		local actor_to_swap = "Flare"
		local player = gladiator
		local tag = "LightUp"
		if player_color ~= nil then player = player_color end
		if Score ~= nil or IsDirectLightUp then
			local ratio = Score_Goal/#Flares
			for i = 1, #Flares do
				if Flares[i].Type ~= actor_to_swap and not Flares[i].HasTag(tag) and Score > ratio*(#Flares - i) or IsDirectLightUp then
					Flares[i] = Actor.Create(actor_to_swap,true,{Location = Flares[i].Location, Owner = player})
					Flares[i].AddTag(tag)
				end
			end
			return true
		else
			return false
		end
	else
		return false
	end
end

---Create a table to hold all selected actors or other informations.
---@param assign_func function
---@param prefix string
---@param num_tbl table set the starting serial number and ending number
---@return table
CreateCollection = function(assign_func, prefix, num_tbl)
	if type(num_tbl) == "table" and #num_tbl == 2 then
		local tbl = { }
		for x = num_tbl[1], num_tbl[2], 1 do
			local a
			if assign_func ~= nil and prefix ~= nil then
				a = assign_func(tostring(prefix) .. x)
			elseif assign_func ~= nil then
				a = assign_func(x)
			elseif prefix ~= nil then
				a = tostring(prefix) .. x
			else
				a = x
			end
			if a ~= nil then tbl[#tbl + 1] = a end
		end
		if #tbl > 0 then
			return tbl
		else
			return { }
		end
	else
		return { }
	end
end

---Filter the table content and return all elements matching the given condition. Return the original table if filter_property is nil.
---@param tbl table
---@param filter_property function
---@param filter_target string
---@return table
FilterCollection = function(tbl, filter_property, filter_target)
	local filtered_tbl = { }
	local empty_filter = "Nothing filtered in this collection."
	if #tbl > 0 then
		if filter_property == nil then
			Debug2(empty_filter)
			return tbl
		else
			for xt = 1, #tbl do
				if tbl[xt].HasProperty(tostring(filter_property)) then
					if tbl[xt].filter_property == filter_target then
						filtered_tbl[#filtered_tbl+1] = tbl[xt]
					end
				end
			end
			if #filtered_tbl > 0 then
				return filtered_tbl
			else
				Debug2(empty_filter)
				return filtered_tbl
			end
		end
	else
		Debug2(empty_filter)
		return filtered_tbl
	end
end

ReportRemainingTime = function(player, minutes, speech)
	if minutes < 0 then
		return -1
	elseif minutes >= 0 and minutes < 1 then
		local seconds = math.floor(60*minutes)
		if DateTime.Seconds(seconds) == Ticked and speech ~= nil then
			Media.PlaySpeechNotification(player, speech)
		end
		return minutes
	elseif minutes >= 1 and DateTime.Minutes(minutes) == Ticked and speech ~= nil then
		Media.PlaySpeechNotification(player, speech)
		return minutes
	else
		return -1
	end
end

---Read the Tip table and send the message if it has not been sent. If sending is success, return true.
---@param tbl_key string
---@return boolean
SendOneTimeMessage = function(tbl_key)
	for x = 1, #Tips do
		if Tips[x].TipName == tbl_key then
			if not Tips[x].isRead then
				Tips[x].isRead = true
				Media.DisplayMessage(Tips[x].content)
				return true
			else
				return false
			end
		end
	end
	return false
end

---If a message has been displayed for once and needed to be displayed again, use this function to revoke the read status.
---Note that if override token of the given key is set to false, this function will not work.
---@param tbl_key any
---@return boolean
RevokeMessageReadStatus = function(tbl_key)
	for x = 1, #Tips do
		if Tips[x].TipName == tbl_key then
			if Tips[x].isRead and Tips[x].override then
				Tips[x].isRead = false
				return true
			else
				if not Tips[x].override then
					Debug2("Try to revoke a read status for the non-overridable message. Check Tips table setups.")
				end
				return false
			end
		end
	end
	return false
end

-- Issue an order for the selected actor.
Orders = {
	---@param u actor
	---@param t any
	---@param useLocation? boolean
	["Attackmove"] = function(u, t, useLocation)
		local closeEnough = 2
		if u ~= nil and t ~= nil then
			if not u.IsDead and u.IsMobile then
				if useLocation == nil or not useLocation then
					if not t.IsDead then u.AttackMove(t.Location, closeEnough) end
				elseif useLocation then
					u.AttackMove(t, closeEnough)
				end
			end
		end
	end,
	---@param u actor
	---@param timer? number
	---@param move? boolean
	["Retaliate"] = function(u, timer, move)
		local sec = 10
		if timer ~= nil and timer > 0 then sec = DateTime.Seconds(timer) end
		if u ~= nil then
			if not u.IsDead and u.IsMobile then
				Trigger.OnDamaged(u, function(s, a)
					if IsEnemy(s, a) and s.CanTarget(a) then
						if move ~= nil then
							s.Stop()
							s.Attack(a, move)
							Trigger.AfterDelay(sec, function() if not s.IsDead then s.Stop() IdleHunt(s) end end)
						else
							s.Stop()
							s.Attack(a)
							Trigger.AfterDelay(sec, function() if not s.IsDead then s.Stop() IdleHunt(s) end end)
						end
					end
				end)
			end
		end
	end,
	---@param u actor
    ---@param t actor
	["Guard"] = function(u, t)
		if u ~= nil and t ~= nil then
			if not u.IsDead and u.IsMobile and not t.IsDead then u.Guard(t) end
		end
	end,
	---@param u actor
    ---@param t actor
	["Move"] = function(u, t)
		if u ~= nil and t ~= nil then
			if not u.IsDead and u.IsMobile then u.Move(t.Location) end
		end
	end,
	---@param u actor
	["IdleHunt"] = function(u)
		if u ~= nil then
			if not u.IsDead and u.IsMobile then IdleHunt(u) end
		end
	end
}

--- Issue an actor to chase after a tagret actor; return to its place after a given time or keep hunting down the target by setting isPersistance to true
---@param chaser actor
---@param target actor
---@param timer number
---@param isPersistance? boolean
ChaseActor = function(chaser, target, timer, isPersistance)
	local t = 10
	if chaser ~= nil and target ~= nil then
		if not chaser.IsDead then
			local ori_pos = chaser.Location
			chaser.Stop()
			Orders["Attackmove"](chaser, target)
			if timer ~= nil and type(timer) == "number" then t = timer end
			if isPersistance == nil or not isPersistance then
				Trigger.AfterDelay(DateTime.Seconds(t), function()
					if not chaser.IsDead then chaser.Stop() Orders["Attackmove"](chaser, ori_pos, true) end
				end)
			elseif isPersistance then
				if target.IsInWorld then
					if not target.IsDead then
						Trigger.AfterDelay(t, function() ChaseActor(chaser, target, timer, isPersistance) end)
					end
				else
					Trigger.ClearAll(chaser)
					chaser.Stop()
					Orders["Attackmove"](chaser, ori_pos, true)
				end
			end
		end
	end
end

---Defend the target actor.
---@param unit actor
---@param gd actor
---@param timer? number
---@param isHunter? boolean
DefendActor = function(unit, gd, timer, isHunter)
	local t = timer or 0
	local hunt = isHunter or false
	Orders["Attackmove"](gd, unit)
	Orders["Guard"](gd, unit)
	Trigger.OnDamaged(unit, function(self, attacker)
		if IsEnemy(self, attacker) and not gd.IsDead then
			ChaseActor(gd, attacker, t, hunt)
		elseif gd.IsDead then
			Trigger.Clear(unit, "OnDamaged")
		end
	end)
	Trigger.OnKilled(unit, function(self, killer) if not gd.IsDead then Orders["IdleHunt"](gd) end end)
end

---Send in the paradrops. Return the table with the first passenger dropped by each aircraft.
---@param tbl table
---@return boolean
SendinParadrops = function(tbl)
	tbl.ref_para = tbl.ref_para or "empty"
	tbl.ref_owner = tbl.ref_owner or neutral
	tbl.sendin_loc = tbl.sendin_loc or WPos.New(0,0,0)
	tbl.ref_loc = tbl.ref_loc or 0
	if Paradrop_Supply_Limit ~= nil and Paradrop_Supply_Limit > 0 and tbl.ref_para ~= "empty" then
		local pxy_name
		if type(tbl.ref_para) ~= "string" then
			pxy_name = tbl.ref_para.Type
		else
			pxy_name = tbl.ref_para
		end
		local paraproxy = Actor.Create("powerproxy." .. pxy_name, false, { Owner = tbl.ref_owner })
		-- CenterPosition for WPos, Position for CPos
		local aircrafts = paraproxy.TargetParatroopers(tbl.sendin_loc)
		Utils.Do(aircrafts, function(a)
			---@param p actor
			Trigger.OnPassengerExited(a, function(t, p)
				---@param pp actor
				Trigger.OnRemovedFromWorld(p, function(pp)
					if Paradrop_Supply_Limit ~= nil and Paradrop_Supply_Limit > 0 then
						local rand_crate = { {"healcrate", 5}, {"moneycrate", 3},{"wcrate", 2} }
						local rand_crate_tgt = CreateParty(1,rand_crate,true)
						if rand_crate_tgt ~= nil then tbl.ref_para = rand_crate_tgt[1] end
						SendinParadrops(tbl)
						Paradrop_Supply_Limit = Paradrop_Supply_Limit - 1
					else
						SendOneTimeMessage("RunOutSupplies")
					end
				end)
			end)
		end)
		if tbl.assign_func ~= nil then
			-- assign_func only takes one parameter, use table to pass data
			Utils.Do(aircrafts, function(a) Trigger.OnPassengerExited(a, function(t, p) tbl.assign_func(p) end) end)
		end
		paraproxy.Destroy()
		return true
	else
		SendOneTimeMessage("RunOutSupplies")
		return false
	end
end

CreateDelayTimerVariant = function(baseTime)
	baseTime = baseTime or 0
	local randTime = Utils.RandomInteger(DateTime.Seconds(2), DateTime.Seconds(3))
	if DateTime.GameTime < IncrementTurningPoint then
		baseTime = baseTime + randTime
		return baseTime
	elseif not (baseTime <= DateTime.Seconds(4)) then
		baseTime = baseTime - randTime
		if baseTime < DateTime.Seconds(1) then baseTime = DateTime.Seconds(1) end
		return baseTime
	end
end

PlaceCamera = function(cameratype, owner, loc_actor)
	local cam
	if cameratype ~= nil and owner ~= nil and loc_actor ~= nil then
		cam = Actor.Create(cameratype, true, { Owner = owner, Location = loc_actor.Location })
		return cam
	else
		return
	end
end

SetupCameras = function()
	if #CamerastoPlace > 0 then
		for x = 1, #CamerastoPlace, 1 do
			local cx = PlaceCamera("camera.sam", gladiator, CamerastoPlace[x])
			if cx ~= nil then
				Trigger.OnKilled(CamerastoPlace[x], function()
					if cx.IsInWorld then cx.Destroy() end
				end)
			end
		end
		return true
	else
		return false
	end
end

--- Create a new party table using an actors collection with chance weight
---@param Partysize number
---@param UnitCollection table
---@param isShuffle boolean Has no effect when party only contains one actor.
---@return actor[]
CreateParty = function(Partysize, UnitCollection, isShuffle)
	local newparty = { }
	if UnitCollection ~= nil then
		for x = 1, #UnitCollection, 1 do
			for z = 1, UnitCollection[x][2], 1 do
				newparty[#newparty + 1] = UnitCollection[x][1]
			end
		end
		if Partysize > 1 then
			local u = { }
			local t
			for i = 1, Partysize, 1 do
				if isShuffle then
					t = Utils.Random(newparty)
				else
					t = newparty[i]
				end
				u[i] = t
			end
			return u
		elseif Partysize == 1 then
			local newparty_single = { }
			local sel_unit = Utils.RandomInteger(1, #newparty + 1)
			newparty_single[#newparty_single + 1] = newparty[sel_unit]
			return newparty_single
		else
			return { }
		end
	else
		return { }
	end
end

---Check if the party contains specific actor type and send a message to the player.
---@param party table
CheckPartyConsistence = function(party)
	for i = 1, #Tips do
		local sub_str = string.lower(string.sub(Tips[i].TipName, 6))
		if Has_value(party, sub_str) then
			SendOneTimeMessage(Tips[i].TipName)
		end
	end
end

---Send in the Party
---@param player player
---@param party table
---@param partysize number
---@param sendin_msg? string
SendinParty = function(player, party, partysize, sendin_msg)
	if player ~= nil and party ~= nil and partysize > 0 then
		local explv = RetrieveLevelStat()
		local units = { }
		units = CreateParty(partysize, party, true)
		if units == nil then
			Debug2("Party creating is failed.")
		else
			CheckPartyConsistence(units)
			local route = Utils.RandomInteger(1, #ArenaEntryPt + 1)
			local partymember = Reinforcements.Reinforce(
				player, units,
				{ EntertheArena.Location, ArenaEntryPt[route].Location }, 60,
				---@param a actor
				function(a)
					local d = Utils.RandomInteger(SendinInterval*6, SendinInterval*6+3)
					if a.CanGainLevel and explv > 0 then a.GiveLevels(explv, true) end
					Orders["Attackmove"](a, Center)
					Orders["Retaliate"](a)
					Trigger.OnKilled(a, function() UpdateScore(Actor.Cost(a.Type)/10) end) --Kill Cost
					Trigger.AfterDelay(d, function()
						if not a.IsDead then
							local mtag = "msgSent"
							if a.IsIdle and not a.HasTag(mtag) and a.Owner == challenger then
								SendOneTimeMessage("Impatience")
								Media.FloatingText("Danger", a.CenterPosition)
								a.AddTag(mtag)
							end
							Orders["IdleHunt"](a)
						end
					end)
				end
			)
			Trigger.OnAllKilled(partymember, function()
				Trigger.AfterDelay(SendinInterval, function()
					if not challenger.IsObjectiveCompleted(MissionBox[4].id) then
						UpdateWave(1)
						if Ticked > 0 then SendinParty(player, RetrieveNewParty(explv), RetrieveNewPartySize(explv), sendin_msg) end
						if sendin_msg ~= nil then Media.DisplayMessage(sendin_msg, "System") end
						RevokeMessageReadStatus("Impatience")
					end
				end)
			end)
		end
	end
end

FinishTimer = function()
	Ticked = -1
	UserInterface.SetMissionText(
		Utils.FormatTime(Ticked) .. "\nScore: " .. tostring(DisplayedScore) .. "\nBoss Wave", TimerColor
	)
	if not gladiator.IsObjectiveCompleted(MissionBox[2].id) and gladiator.IsObjectiveCompleted(MissionBox[3].id) then
		challenger.MarkCompletedObjective(MissionBox[4].id)
	else
		---@type number|integer
		local explv = RetrieveLevelStat()
		local boss = { "5tnk", "5tnk" }
		local partymember = Reinforcements.Reinforce(
			templar, boss,
			{ EntertheArena.Location, ArenaEntryPt[1].Location }, 25,
			---@param a actor
			function(a)
				local d = Utils.RandomInteger(SendinInterval*6, SendinInterval*6+3)
				if a.CanGainLevel and explv > 0 then a.GiveLevels(explv, true) end
				Orders["Attackmove"](a, Center)
				Orders["Retaliate"](a)
				Trigger.AfterDelay(d, function() Orders["IdleHunt"](a) end)
			end
		)
		Media.PlayMusic("music_quixotic")
		Trigger.OnAllKilled(partymember, function() gladiator.MarkCompletedObjective(MissionBox[1].id) end)
	end
end

UpdateWave = function(w)
	if w ~= nil and type(w) == "number" then
		Wave_Count = Wave_Count + w
		if Wave_Count < 0 then Wave_Count = 0 end
		if Wave_Count >= Wave_Goal then gladiator.MarkCompletedObjective(MissionBox[3].id) end
		return true
	else
		return false
	end
end

RetrieveNewPartySize = function(tbl_idx)
	if tbl_idx ~= nil and type(tbl_idx) == "number" then
		if tbl_idx > #ChallengerPartySizeLevel then
			return ChallengerPartySizeLevel[#ChallengerPartySizeLevel]
		elseif tbl_idx < 1 then
			return ChallengerPartySizeLevel[1]
		else
			return ChallengerPartySizeLevel[tbl_idx]
		end
	else
		return 0
	end
end

RetrieveNewParty = function(tbl_idx)
	if tbl_idx ~= nil and type(tbl_idx) == "number" then
		if tbl_idx > #ChallengerPartyList then
			return ChallengerPartyList[#ChallengerPartyList]
		elseif tbl_idx < 1 then
			return ChallengerPartyList[1]
		else
			return ChallengerPartyList[tbl_idx]
		end
	else
		return { }
	end
end

-- Base on Score to increase enemys' level
RetrieveLevelStat = function()
	if Score == 0 or Score == nil then
		return 0
	else
		for x = 1, #ChallengerLevelStats, 1 do
			local v = ChallengerLevelStats[x][2]
			if Score >= v then
				return ChallengerLevelStats[x][1]
			end
		end
		return 0
	end
end

UpdateDisplayedScore = function()
	local lerp = 0.1
	if DisplayedScore ~= Score then
		DisplayedScore = math.ceil(DisplayedScore + (Score - DisplayedScore) * lerp)
		if math.abs(Score - DisplayedScore) * lerp < 1 then
			DisplayedScore = Score
		else
			Trigger.AfterDelay(1, UpdateDisplayedScore)
		end
	end
end

---Update current scores.
---@param val number
UpdateScore = function(val)
	if val ~= nil and type(val) == "number" then
		Score = Score + val
		if Score >= Score_Goal then gladiator.MarkCompletedObjective(MissionBox[2].id) end
		LightUpFlare()
		UpdateDisplayedScore()
	end
end

-- Check if the tagret actor is harmful.
IsEnemy = function(self, target)
	if self ~= nil and target ~= nil then
		if self.Owner ~= target.Owner and not self.Owner.IsAlliedWith(target.Owner) then
			return true
		else
			return false
		end
	else
		return false
	end
end

InitBase = function()
	Crates = CreateCollection(Map.NamedActor, "Crate", {1, 12})
	Audience = CreateCollection(Map.NamedActor, "Executor0", {1, 6})
	Defensive_Bldgs = CreateCollection(Map.NamedActor, "GunTurret", {1, 16})
	Flares = CreateCollection(Map.NamedActor, "FlareSpot", {1, 24})
	if #Crates > 0 then
		for a = 1, #Crates do
			Crate_Loc[a] = Crates[a].CenterPosition
			Trigger.OnRemovedFromWorld(Crates[a], function()
				local p = SendinParadrops({
					ref_para = Crates[a],
					ref_owner = neutral,
					sendin_loc = Crate_Loc[a] or Crates[a].CenterPosition,
					ref_loc = a
				})
			end)
		end
		Trigger.OnAllRemovedFromWorld(Crates, function() end)
	end
	if #Audience > 0 then
		for a = 1, #Audience, 1 do
			Orders["Retaliate"](Audience[a])
			Trigger.OnKilled(Audience[a], function() UpdateScore(Actor.Cost(Audience[a].Type)/5) end)
		end
		Trigger.OnAllKilled(Audience, function() UpdateScore(2000) end)
	end
	if #Defensive_Bldgs > 0 then
		for a = 1, #Defensive_Bldgs, 1 do
			Trigger.OnKilled(Defensive_Bldgs[a], function()
				SendOneTimeMessage("AboutExecutor")
				SendinParty(executor, ExecutorPartyList[1], ExecutorPartySizeLevel[1])
				local t = string.sub(Defensive_Bldgs[a].Type,-1)
				if t ~= "2" then
					Defensive_Bldgs[a] = Actor.Create(Defensive_Bldgs[a].Type .. "2", true, {Location = Defensive_Bldgs[a].Location, Owner = executor})
				end
			end)
		end
		Trigger.OnAllKilled(Defensive_Bldgs, function() UpdateScore(2000) end)
	end
	-- Difficulty Setup, functions need to be declared after the first tick to utilize properly
	if InitData ~= nil and #InitData >= 1 then
		for i = 1, #InitData, 1 do
			if Difficulty == InitData[i].difficulty then
				TimerTicks = DateTime.Seconds(InitData[i].timer_sec)
				Ticked = TimerTicks
				Score_Goal = InitData[i].required_score
				Wave_Goal = InitData[i].required_waves
				MissionBox[2].ObjectiveText = "Make the Score over ".. InitData[i].required_score .." points before\ntime runs out."
				MissionBox[3].ObjectiveText = "Defeat at least " .. InitData[i].required_waves .. " waves of the Challengers\nbefore time runs out. (extra waves will be\ncounted as well)"
				Paradrop_Supply_Limit_Max = InitData[i].paradrop_supply_limit
				Paradrop_Supply_Limit = Paradrop_Supply_Limit_Max
				if InitData[i].party_sendin_interval >= 1 then
					SendinInterval = DateTime.Seconds(InitData[i].party_sendin_interval)
				elseif InitData[i].party_sendin_interval < 1 and InitData[i].party_sendin_interval > 0 then
					SendinInterval = math.ceil(60 * InitData[i].party_sendin_interval)
				else
					SendinInterval = 60
					Debug2("The SendinInterval has an invalid setting, check the InitData table.")
				end
				TweakPartySize(ChallengerPartySizeLevel, InitData[i].party_mutiplier)
				Trigger.AfterDelay(SendinInterval * 2, function()
					SendOneTimeMessage("FirstWave")
					SendinParty(challenger, ChallengerPartyList[1], ChallengerPartySizeLevel[1], "Send in Challengers...")
				end)
				return true
			end
		end
	end
	return false
end

-- Debuggers
Debug2 = function(msg)
	if msg ~= nil then
		local str
		if type(msg) ~= "string" then
			str = tostring(msg)
			Media.DisplayMessage(str, "Debug", HSLColor.New(54, 100, 100))
		else
			Media.DisplayMessage(msg, "Debug", HSLColor.New(54, 100, 100))
		end
	end
end

--- Check if there is a specific data in the table
---@param tab table
Has_value = function(tab, val)
    for index, value in ipairs(tab) do
        if value == val then
            return true
        end
    end
    return false
end

-- Call on every tick
Tick = function()
	if challenger.HasNoRequiredUnits() then
		gladiator.MarkCompletedObjective(MissionBox[1].id)
	end
	if gladiator.HasNoRequiredUnits() then
		challenger.MarkCompletedObjective(MissionBox[4].id)
	end
	if not Hero.IsDead then
		if Hero.CanGainLevel and Hero.Level > 1 and not Tips[10].isRead then
			SendOneTimeMessage("Berserker")
		end
	end
	if IsInit then
		if Ticked > 0 then
			if Ticked == TimerTicks then Media.PlaySpeechNotification(gladiator, "MissionTimerInitialised") end
			for t = 2, #SpeechSet, 1 do
				local v = ReportRemainingTime(gladiator, SpeechSet[t][1], SpeechSet[t][2])
			end
			UserInterface.SetMissionText(
				Utils.FormatTime(Ticked) .. "\nScore: " .. tostring(DisplayedScore .. "\nCurrent Wave: " .. tostring(Wave_Count)), TimerColor
			)
			if gladiator.IsObjectiveCompleted(MissionBox[2].id) and gladiator.IsObjectiveCompleted(MissionBox[3].id) then
				Ticked = 0
			else
				Ticked = Ticked - 1
			end
		end
		if Ticked == 0 then
			FinishTimer()
		end
	end
end

AddObjectives = function()
	InitObjectives(gladiator)
	if #MissionBox > 0 then
		for i = 1, #MissionBox do
			MissionBox[i].id = MissionBox[i].Player.AddObjective(MissionBox[i].ObjectiveText)
		end
	end
	Trigger.OnKilled(Hero, function() challenger.MarkCompletedObjective(MissionBox[4].id) end)
	Trigger.OnPlayerWon(gladiator, function() end)
end

WorldLoaded = function()
	gladiator = Player.GetPlayer("Gladiator")
	challenger = Player.GetPlayer("Challenger")
	templar = Player.GetPlayer("Templar")
	executor = Player.GetPlayer("Executor")
	neutral = Player.GetPlayer("Neutral")

	Camera.Position = Hero.CenterPosition
	TimerColor = gladiator.Color

	IsInit = InitBase()
	if IsInit then
		AddObjectives()
		SetupCameras()
	end
end
