Survivors = {'Gacius', 'Eugenator', 'DukeBones', 'anjew', 'Upps', 'Ekanim', 'Mo', 'Sigil', 'milkman', 'bete', 'JINX', 'spetsnaz84', 'Nilhall', 'Pvt_Leaf', 'BigHALK', 'chouchani'}
StrikePlayers = {'Dodder', 'jungle', 'despro', 'tux', 'dang_shot', 'Tailix'}
InternalToSurvivorMap = {}
Finishers = {}
Eliminated = {}
MapWidth = 50
MapHeight = 50
Ended = false
WaypointCPos = {}
Barracks = {}
TimeInterval = 5
GameStage = 0
-- Map that will contain true if location has had a mine.
MineLocations = {}

PickRandomMnly = function(callback)
    local mnlys = {}
    for i = 1, #Survivors do
        local mnlyName = "MNLY"..i
        local mnly = Map.NamedActor(mnlyName)
        if mnly ~= nil and not mnly.IsDead then
            mnlys[i] = mnly
        end
    end
    return Utils.Random(mnlys)
end

ForEachLivingMnly = function(callback)
    for i = 1, #Survivors do
        local mnlyName = "MNLY"..i
        local mnly = Map.NamedActor(mnlyName)
        if mnly ~= nil and not mnly.IsDead then
            callback(mnly)
        end
    end
end

DisplayOtherNames = function()
    local creeps = Player.GetPlayer("Creeps")
    if not PLANE1.IsDead then
        Media.FloatingText("Kav", PLANE1.CenterPosition, 30, creeps.Color)
    end
    if not PLANE2.IsDead then
        Media.FloatingText("maceman", PLANE2.CenterPosition, 30, creeps.Color)
    end
    if not PLANE3.IsDead then
        Media.FloatingText("Blackened", PLANE3.CenterPosition, 30, creeps.Color)
    end

    local creeps2 = Player.GetPlayer("Creeps2")
    if not TTTPPP.IsDead then
        Media.FloatingText("TTTPPP", TTTPPP.CenterPosition, 30, creeps2.Color)
    end

    for i = 1, #StrikePlayers do
        local neutralMinelayer = Map.NamedActor("NeutralML"..i)
        if neutralMinelayer ~= nil and not neutralMinelayer.IsDead then
            Media.FloatingText(StrikePlayers[i], neutralMinelayer.CenterPosition, 30, creeps2.Color)
        end
    end

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        DisplayOtherNames()
    end)
end

DisplayNames = function()
    for i = 1, #Survivors do
        local playerName = "Multi"..(i-1)
        local player = Player.GetPlayer(playerName)
        local mnlys = player.GetActorsByType("mnly")
        if #mnlys > 0 then
            local mnly = mnlys[1]
            local survivor = Survivors[i]
            InternalToSurvivorMap[playerName] = survivor
            mnly.GrantCondition(survivor)

            Trigger.OnKilled(mnly, function(mnly)
                if not Ended then
                    Media.DisplayMessage(survivor.." is dead")
                    Eliminated[#Eliminated + 1] = survivor
                    mnly.Owner.MarkFailedObjective(0)
                end
            end)
        end
    end
    DisplayOtherNames()
end

CheckForEnded = function()
    local remaining = {}
    for i = 1, #Survivors do
        local internalName = "Multi"..(i-1)
        local player = Player.GetPlayer(internalName)
        local mnlys = player.GetActorsByType("mnly")
        if #mnlys > 0 then
            remaining[#remaining + 1] = player
        end
    end
    if #remaining < 2 then
        Ended = true
        for i = 1, #remaining do
            local player = remaining[i]
            player.MarkCompletedObjective(0)
            local survivor = InternalToSurvivorMap[player.InternalName]
            Finishers[#Finishers + 1] = survivor
        end
        while #Finishers < 3 do
            Finishers[#Finishers + 1] = Eliminated[#Eliminated - #Finishers + #remaining]
        end
        Media.DisplayMessage("***")
        Media.DisplayMessage("*** The prize winners are: "..Finishers[1]..", "..Finishers[2]..", "..Finishers[3])
        Media.DisplayMessage("***")
    else
        Trigger.AfterDelay(DateTime.Seconds(1), function()
            CheckForEnded()
        end)
    end
end

DisplayTimerMessages = function()
    for i = 1, TimeInterval do
        Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval - i), function()
            Media.DisplayMessage(""..(i))
        end)
    end
    Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval), function()
        Media.DisplayMessage("GO!")
        TechnicianPanic()
    end)
end

CreepAttack = function(creep)
    local mnly = PickRandomMnly()
    creep.Attack(mnly)
end

PlaneAttack = function(i)
    return function(plane)
        CreepAttack(plane)
        local j = Utils.RandomInteger(1, 5 + 1)
        plane.Move(WaypointCPos[i][j], 1)
        Trigger.AfterDelay(DateTime.Seconds(TimeInterval), function()
            plane.Stop()
            PlaneAttack(i)(plane)
        end)
    end
end

StartHunt = function(zombie)
    if GameStage == 1 then
        zombie.GrantCondition("fast")
    elseif GameStage == 2 then
        zombie.GrantCondition("faster")
    elseif GameStage == 3 then
        zombie.GrantCondition("fastest")
    end
    zombie.Scatter()
    local flag = Map.NamedActor("FLAG")
    if Utils.RandomInteger(1, 5 + 1) == 1 then
        CreepAttack(zombie)
    else
        zombie.AttackMove(flag.Location, 5)
    end
    Trigger.OnIdle(zombie, CreepAttack)
end

ReleaseZombies = function(count)
    local creeps = Player.GetPlayer("Creeps")
    for i = 1, count do
        local j = Utils.RandomInteger(1, 4 + 1)
        local rax = Barracks[j]
        if not rax.IsDead then
            Reinforcements.Reinforce(creeps, {"zombie"}, {rax.RallyPoint}, 25, StartHunt)
        end
    end
    Trigger.AfterDelay(DateTime.Seconds(TimeInterval), function()
        ReleaseZombies(count + 1)
    end)
end

InitGameStages = function()
    Trigger.AfterDelay(DateTime.Seconds(3 * TimeInterval), function()
        ReleaseZombies(1)

        Trigger.AfterDelay(DateTime.Seconds(8 * TimeInterval), function()
            GameStage = 1
            Media.DisplayMessage("WARNING - Zombie evolution detected!")
        end)
        Trigger.AfterDelay(DateTime.Seconds(16 * TimeInterval), function()
            GameStage = 2
            Media.DisplayMessage("WARNING - Zombie evolution detected!")
        end)
        Trigger.AfterDelay(DateTime.Seconds(24 * TimeInterval), function()
            GameStage = 3
            Media.DisplayMessage("WARNING - Zombie evolution detected!")
        end)

        ForEachLivingMnly(function(mnly)
            Trigger.OnIdle(mnly, function(mnly)
                if Utils.RandomInteger(1, 2 + 1) == 1 then
                    -- Lay a mine.
                    mnly.Scatter()
                    if MineLocations[mnly.Location] == nil then
                        MineLocations[mnly.Location] = true
                        Reinforcements.Reinforce(mnly.Owner, {"minv"}, {mnly.Location})
                    end
                else
                    -- Randomly move some distance.
                    local x = mnly.Location.X + (2 * Utils.RandomInteger(1, 2 + 1) - 3) * Utils.RandomInteger(1, 5 + 1)
                    if x < 3 then
                        x = 3
                    elseif x > MapWidth - 2 then
                        x = MapWidth - 2
                    end
                    local y = mnly.Location.Y + (2 * Utils.RandomInteger(1, 2 + 1) - 3) * Utils.RandomInteger(1, 5 + 1)
                    if y < 3 then
                        y = 3
                    elseif y > MapHeight - 2 then
                        y = MapHeight - 2
                    end
                    local newLocation = CPos.New(x, y)
                    mnly.Move(newLocation)
                end
            end)
        end)
    end)
end

TechnicianPanic = function()
    if not TTTPPP.IsDead then
        TTTPPP.Stop()
        TTTPPP.Panic()
        Trigger.AfterDelay(DateTime.Seconds(TimeInterval), TechnicianPanic)
    end
end

WorldLoaded = function()
    Survivors = Utils.Shuffle(Survivors)

    DisplayNames()

    DisplayTimerMessages()

    InitGameStages()

    for i = 1, 3 do
        local plane = Map.NamedActor("PLANE"..i)
        plane.Wait(DateTime.Seconds(2 * TimeInterval))
    end
    local waypointWPos = {}
    for i = 1, 3 do
        WaypointCPos[i] = {}
        waypointWPos[i] = {}
        for j = 1, 5 do
            WaypointCPos[i][j] = Map.NamedActor("W"..i..j).Location
            waypointWPos[i][j] = Map.CenterOfCell(WaypointCPos[i][j])
        end
        local plane = Map.NamedActor("PLANE"..i)
        local j = Utils.RandomInteger(1, 5 + 1)
        plane.Move(WaypointCPos[i][j], 1)
        plane.Stance = "AttackAnything"
        Trigger.OnIdle(plane, PlaneAttack(i))
    end
    for i = 1, 3 do
        for j = 1, 5 do
            Trigger.OnEnteredProximityTrigger(waypointWPos[i][j], WDist.FromCells(1), function(plane)
                if plane == Map.NamedActor("PLANE"..i) then
                    PlaneAttack(i)(plane)
                end
            end)
        end
    end

    for i = 1, 4 do
        local rax = Map.NamedActor("RAX"..i)
        Barracks[i] = rax
    end

    CheckForEnded()
end
