blocks = {}
neutral = nil
cellSize = 1024
pathStarts = 24
oreMines = 8
allPaths = {}
timer = 480
endtimer = false
player0 = nil
player1 = nil
player0Mines = {}
player1Mines = {}

SetCamera = function(player)
	local sapper = player.GetActorsByType("sapper")[1]
	Camera.Position = sapper.CenterPosition
end

InitializeBlocks = function()
	blocks = neutral.GetActorsByType("block")
	for i = 1, #blocks do
		Trigger.OnKilled(blocks[i], function()
			SpawnTile(blocks[i].Location)
		end)
	end
end

SpawnTile = function(tilelocation)
	local actor = Actor.Create("block_u", true, { Owner = neutral, Location = tilelocation })
	CheckNeighbours(actor)
end

InitializePaths = function()
	local x = 1
	local y = 1
	x = Utils.RandomInteger(5, 46)
	y = Utils.RandomInteger(5, 46)
	local cell = CPos.New(x,y)
	local actora = Actor.Create("killer", true, { Owner = neutral, Location = cell })
	cell = CPos.New(51 - x, 51 - y)
	local actorb = Actor.Create("killer", true, { Owner = neutral, Location = cell })
	local continue = 20
	BoreMaster(actora.Location, actorb.Location, continue)
end

InitializePathGraphics = function()
	for i = 1, #allPaths do
		CheckNeighbours(allPaths[i])
	end
end

InitializeOreMines = function()
	local waiter = 1
	while oreMines > 0 do
		Trigger.AfterDelay(waiter, function()
			local randomNumber = Utils.RandomInteger(0, #allPaths)
			local looper = 1
			local usedPaths = {}
			local weap = Map.ActorsInCircle(allPaths[randomNumber].CenterPosition, WDist.New(6 * 1024), function(actor) return actor.Type == "weap"
			end)
			local oldMines = Map.ActorsInCircle(allPaths[randomNumber].CenterPosition, WDist.New(6 * 1024), function(actor) return actor.Type == "mine"
			end)
			while weap[1] ~= nil or oldMines[1] ~= nil do
				randomNumber = Utils.RandomInteger(0, #allPaths)
				weap = Map.ActorsInCircle(allPaths[randomNumber].CenterPosition, WDist.New(6 * 1024), function(actor) return actor.Type == "weap"
				end)
				oldMines = Map.ActorsInCircle(allPaths[randomNumber].CenterPosition, WDist.New(6 * 1024), function(actor) return actor.Type == "mine"
				end)
			end
			local actor1 = Actor.Create("mine", true, { Owner = neutral, Location = allPaths[randomNumber].Location })
			Trigger.OnCapture(actor1, function()
				CheckMines()
			end)
			local cpos = CPos.New(51 - allPaths[randomNumber].Location.X, 51 - allPaths[randomNumber].Location.Y)
			local actor2 = Actor.Create("mine", true, { Owner = neutral, Location = cpos })
			Trigger.OnCapture(actor2, function()
				CheckMines()
			end)
		end)
		waiter = waiter + 1
		oreMines = oreMines - 1
	end
end

CheckMines = function()
	player0Mines = player0.GetActorsByType("mine")
	player1Mines = player1.GetActorsByType("mine")
end

BoreMaster = function(cella, cellb, count, exclude)
	local direction = Utils.RandomInteger(0, 5)
	local cposa = CPos.New(0,0)
	local cposb = CPos.New(0,0)
	local wrongWay = 0
	while direction == exclude do
		direction = Utils.RandomInteger(0, 5)
	end
	if direction == 1 then
		cposa = CPos.New(cella.X + 1, cella.Y)
		local actor1 = Actor.Create("killer", true, { Owner = neutral, Location = cposa })
		cposb = CPos.New(cellb.X - 1, cellb.Y)
		local actor2 = Actor.Create("killer", true, { Owner = neutral, Location = cposb })
	elseif direction == 2 then
		cposa = CPos.New(cella.X - 1, cella.Y)
		local actor1 = Actor.Create("killer", true, { Owner = neutral, Location = cposa })
		cposb = CPos.New(cellb.X + 1, cellb.Y)
		local actor2 = Actor.Create("killer", true, { Owner = neutral, Location = cposb })
	elseif direction == 3 then
		cposa = CPos.New(cella.X, cella.Y + 1)
		local actor1 = Actor.Create("killer", true, { Owner = neutral, Location = cposa })
		cposb = CPos.New(cellb.X, cellb.Y - 1)
		local actor2 = Actor.Create("killer", true, { Owner = neutral, Location = cposb })
	else
		cposa = CPos.New(cella.X, cella.Y - 1)
		local actor1 = Actor.Create("killer", true, { Owner = neutral, Location = cposa })
		cposb = CPos.New(cellb.X, cellb.Y + 1)
		local actor2 = Actor.Create("killer", true, { Owner = neutral, Location = cposb })
	end
	if direction == 1 then
		wrongWay = 2
	elseif direction == 2 then
		wrongWay = 1
	elseif direction == 3 then
		wrongWay = 4
	elseif direction == 4 then
		wrongWay = 3
	end
	local number = 0
	number = count
	number = number - 1
	if number > 1 then
		if cposa.X > 4 and cposa.Y > 4 then
			if cposa.X < 48 and cposa.Y < 48 then
				BoreMaster(cposa, cposb, number, wrongWay)
			end
		end
	end
end

CheckNeighbours = function(thistile)
	local tileCenter = thistile.CenterPosition
	--Check north
	local topleft = WPos.New(tileCenter.X - 512, tileCenter.Y - 1536, 0)
	local bottomright = WPos.New(tileCenter.X + 512, tileCenter.Y - 512, 0)
	neighbour = Map.ActorsInBox(topleft, bottomright, function(target)
		return target.Type == "block_u"
	end)
	if neighbour[1] ~= nil then
		thistile.GrantCondition("north",0)
		neighbour[1].GrantCondition("south",0)
	end
	--Check south
	topleft = WPos.New(tileCenter.X - 512, tileCenter.Y + 512, 0)
	bottomright = WPos.New(tileCenter.X + 512, tileCenter.Y + 1536, 0)
	neighbour = Map.ActorsInBox(topleft, bottomright, function(target)
		return target.Type == "block_u"
	end)
	if neighbour[1] ~= nil then
		thistile.GrantCondition("south",0)
		neighbour[1].GrantCondition("north",0)
	end
	--Check west
	topleft = WPos.New(tileCenter.X - 1536, tileCenter.Y - 512, 0)
	bottomright = WPos.New(tileCenter.X - 512, tileCenter.Y + 512, 0)
	neighbour = Map.ActorsInBox(topleft, bottomright, function(target)
		return target.Type == "block_u"
	end)
	if neighbour[1] ~= nil then
		thistile.GrantCondition("west",0)
		neighbour[1].GrantCondition("east",0)
	end
	--Check east
	topleft = WPos.New(tileCenter.X + 512, tileCenter.Y - 512, 0)
	bottomright = WPos.New(tileCenter.X + 1536, tileCenter.Y + 512, 0)
	neighbour = Map.ActorsInBox(topleft, bottomright, function(target)
		return target.Type == "block_u"
	end)
	if neighbour[1] ~= nil then
		thistile.GrantCondition("east",0)
		neighbour[1].GrantCondition("west",0)
	end
end

TimerText = function()
	if endtimer == false then
		local minutes = math.floor(timer / 60)
		local seconds = timer - (minutes * 60)
		local timetext = ""
		if seconds < 10 then
			timetext = "" .. minutes .. ":0" .. seconds .. ""
		else
			timetext = "" .. minutes .. ":" .. seconds .. ""
		end
		timetext = "" .. timetext .. "\n" .. player0.Name .. " mines: " .. #player0Mines .. "\n" .. player1.Name .. " mines: " .. #player1Mines .. ""
		if timer > 0 then
			Trigger.AfterDelay(DateTime.Seconds(1), function()
				timer = timer - 1
				UserInterface.SetMissionText("Time left to claim the mines " .. timetext, HSLColor.White)
				TimerText()
			end)
		else
			endtimer = true
			Trigger.AfterDelay(DateTime.Seconds(1), function()
				TimerText()
			end)
		end
	elseif endtimer == true then
		if #player0Mines == #player1Mines then
			UserInterface.SetMissionText("There is a tie! The next player to gain a mine wins.", HSLColor.White)
			Trigger.AfterDelay(DateTime.Seconds(1), function()
				TimerText()
			end)
		elseif #player0Mines > #player1Mines then
			player1.MarkFailedObjective(0)
		elseif #player1Mines > #player0Mines then
			player0.MarkFailedObjective(0)
		end
	end
end

WorldLoaded = function()
	neutral = Player.GetPlayer("Neutral")
	player0 = Player.GetPlayer("Multi0")
	player1 = Player.GetPlayer("Multi1")
	player1.Cash = 500
	player0.Cash = 500
	InitializeBlocks()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Media.DisplayMessage("As you may have noticed the ore mines in the previous area had ran out of ore.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("You have been tasked to bore yourself to as many ore veins as you can.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(9), function()
		Media.DisplayMessage("Capture and hold as many ore mines you can, in order to ensure our war efforts.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(13), function()
		Media.DisplayMessage("But be aware, the enemy is bound to have similiar intentions!")
	end)
	Trigger.AfterDelay(DateTime.Seconds(17), function()
		Media.DisplayMessage("Good luck commander!")
		TimerText()
		a1.Owner = Player.GetPlayer("Multi0")
		a2.Owner = Player.GetPlayer("Multi0")
		a3.Owner = Player.GetPlayer("Multi0")
		b1.Owner = Player.GetPlayer("Multi1")
		b2.Owner = Player.GetPlayer("Multi1")
		b3.Owner = Player.GetPlayer("Multi1")
		a4.Destroy()
		b4.Destroy()
		Trigger.AfterDelay(2, function()
			if player0.IsLocalPlayer then
				SetCamera(player0)
			elseif player1.IsLocalPlayer then
				SetCamera(player1)
			end
		end)
	end)
	while pathStarts > 0 do
		InitializePaths()
		pathStarts = pathStarts - 1
	end
	Trigger.AfterDelay(DateTime.Seconds(4), function()
		allPaths = neutral.GetActorsByType("block_u")
	end)
	Trigger.AfterDelay(DateTime.Seconds(7), function()
		InitializeOreMines()
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		InitializePathGraphics()
	end)
end
