homes = {}
pointers = {}
message = 0
points = {}
players = {}
playerbase = {}
pointstoget = 11
lives = {}
winner = 0
elfs = {}
player0 = nil
player1 = nil

SendMessages = function()
	if message == 0 then
		Media.DisplayMessage("Santa Claus is unable to deliver presents to the children in this sector.")
	elseif message == 1 then
		Media.DisplayMessage("You must help Santa to save the Christmas of all the well behaved kids in the area.")
	elseif message == 2 then
		Media.DisplayMessage("Santa has left caches of presents in the northeastern and southwestern corners of the area.")
	elseif message == 3 then
		Media.DisplayMessage("But be aware! Power shifts quickly in Santa's yuletide brotherhood!")
	elseif message == 4 then
		Media.DisplayMessage("Some elves are not afraid to use force to gain the attention of Father Christmas!")
	elseif message == 5 then
		Media.DisplayMessage("Deliver more presents than your competition or destroy them!")
	elseif message == 6 then
		Media.DisplayMessage("Good luck!")
	end
	message = message + 1
	if message < 7 then
		Trigger.AfterDelay(DateTime.Seconds(4), function()
			SendMessages()
		end)
	end
end

SetUpProximityTriggers = function()
	for i = 1, #pointers do
		Trigger.OnEnteredFootprint({ pointers[i].Location }, function(a, id)
			if a.Type == "truk2" then
				if a.AmmoCount("gifts") > 0 then
					AddPoints(a.Owner)
					Trigger.RemoveFootprintTrigger(id)
					pointers[i].Kill()
					a.Reload("gifts", -1)
				end
			end
		end)
	end
end

AddPoints = function (player)
	if player == players[0] then
		points[0] = points[0] + 1
		Media.DisplayMessage("Player 1 points" .. points[0])
		EndGame()
	elseif player == players[1] then
		points[1] = points[1] + 1
		Media.DisplayMessage("Player 2 points" .. points[1])
		EndGame()
	end
end

EndGame = function()
	local loop = 0
	local allactors = Map.ActorsInWorld
	local spawnchecker = {}
	local actorchecker = {}
	for i = 1, #allactors do
		if allactors[i].Type == "giftpointer" then
			spawnchecker[loop] = allactors[i]
			loop = loop + 1
		end
	end
	Trigger.AfterDelay(1, function()
		SetScoreboard()
	end)
	SpawnElfs()
	if #spawnchecker == 0 then
		allactors = Map.ActorsInWorld
		if points[0] > points[1] then
			Media.DisplayMessage(players[0].Name .." wins!")
			winner = 1
			playerbase[1].Destroy()
		elseif points[1] > points[0] then
			Media.DisplayMessage(players[1].Name .." wins!")
			winner = 2
			playerbase[0].Destroy()
		elseif points[0] == points[1] then
			Media.DisplayMessage("Seems like you are equally matched in delivering gifts. Kill your competition!")
		end
	end
end

InitializePointsAndPlayers = function()
	points[0] = 0
	points[1] = 0
	lives[0] = 5
	lives[1] = 5
	players[0] = Player.GetPlayer("Multi0")
	players[1] = Player.GetPlayer("Multi1")
	player0 = Player.GetPlayer("Multi0")
	player1 = Player.GetPlayer("Multi1")
	elfs[1] = "e1"
	elfs[2] = "e3"
	elfs[3] = "e4"
	elfs[4] = "shok"
end

SpawnTrucks = function()
	local neutral = Player.GetPlayer("Neutral")
	local possiblespawns = neutral.GetActorsByType("truckspawn")
	local randnum = 0
	randnum = Utils.RandomInteger(1, #possiblespawns)
	if #player0.GetActorsByType("truk2") < 1 then
		local actor = Actor.Create("truk2", true, { Owner = players[0], Location = InitialSpawn1.Location })
		Trigger.OnKilled(actor, function()
			UpdateLives(players[0])
		end)
		if players[0].IsLocalPlayer then
			Camera.Position = InitialSpawn1.CenterPosition
		end
	end
	randnum = Utils.RandomInteger(1, #possiblespawns)
	if #player1.GetActorsByType("truk2") < 1 then
		local actor = Actor.Create("truk2", true, { Owner = players[1], Location = InitialSpawn2.Location })
		Trigger.OnKilled(actor, function()
			UpdateLives(players[1])
		end)
		if players[1].IsLocalPlayer then
			Camera.Position = InitialSpawn2.CenterPosition
		end
	end
end

UpdateLives = function (player)
	local player0 = Player.GetPlayer("Multi0")
	local player1 = Player.GetPlayer("Multi1")
	local neutral = Player.GetPlayer("Neutral")
	local possiblespawns = neutral.GetActorsByType("truckspawn")
	local randnum = 0
	randnum = Utils.RandomInteger(1, #possiblespawns)
	if player == player0 then
		if #player0.GetActorsByType("truk2") < 1 then
			lives[0] = lives[0] - 1
			if lives[0] > 0 then
				local actor = Actor.Create("truk2", true, { Owner = players[0], Location = possiblespawns[randnum].Location })
				Trigger.OnKilled(actor, function()
					UpdateLives(players[0])
				end)
				if players[0].IsLocalPlayer then
					Camera.Position = possiblespawns[randnum].CenterPosition
				end
			else
				if winner == 0 then
					playerbase[0].Destroy()
				end
			end
		end
	end
	randnum = Utils.RandomInteger(1, #possiblespawns)
	if player == player1 then
		if #player1.GetActorsByType("truk2") < 1 then
			lives[1] = lives[1] - 1
			if lives[1] > 0 then
				local actor = Actor.Create("truk2", true, { Owner = players[1], Location = possiblespawns[randnum].Location })
				Trigger.OnKilled(actor, function()
					UpdateLives(players[1])
				end)
				if players[1].IsLocalPlayer then
					Camera.Position = possiblespawns[randnum].CenterPosition
				end
			else
				if winner == 0 then
					playerbase[1].Destroy()
				end
			end
		end
	end
	Trigger.AfterDelay(1, function()
		SetScoreboard()
	end)
end

SetScoreboard = function()
	local emptyLines = 0
	local loop = 0
	local text1 = ""
	local plrNameLen = 0
	text1 = text1 .. "Players:               "
	for i = 0, #players do
		text1 = text1 .. players[i].Name .. "     "
	end
	text1 = text1 .. "\nLives | Points:      "
	local spaceLoop = 0
	for i = 0, #players do
		spaceLoop = (string.len(players[i].Name) / 2)
		while spaceLoop >= 0 do
			text1 = text1 .. " "
			spaceLoop = spaceLoop - 1
		end
		text1 = text1 .. lives[i] .. " | " .. points[i]
		spaceLoop = (string.len(players[i].Name) / 2)
		while spaceLoop >= 0 do
			text1 = text1 .. " "
			spaceLoop = spaceLoop - 1
		end
		text1 = text1 .. "  "
	end
	UserInterface.SetMissionText(text1, HSLColor.White)
end

InitializeHomes = function()
	local neutral = Player.GetPlayer("Neutral")
	local loop = 0
	local randnum = 0
	local checker = false
	local spawnzones = {}
	local allactors = Map.ActorsInWorld
	local cpos = CPos.New(0,0)
	for i = 1, #allactors do
		if allactors[i].Type == "powr" then
			if allactors[i].Owner == players[0] then
				playerbase[0] = allactors[i]
			elseif allactors[i].Owner == players[1] then
				playerbase[1] = allactors[i]
			end
		end
	end
	for i = 1, #allactors do
		if allactors[i].Type == "spawn" then
			spawnzones[loop] = allactors[i]
			loop = loop + 1
		end
	end
	loop = 1
	while loop < pointstoget do
		randnum = Utils.RandomInteger(1, 40)
		for i = 1, #homes do
			while homes[i] == randnum do
				randnum = Utils.RandomInteger(1, 40)
			end
		end
		homes[loop] = randnum
		loop = loop +1
	end
	loop = 1
	for i = 1, #spawnzones do
		for a = 1, #homes do
			if homes[a] == i then
				randnum = Utils.RandomInteger(0, 4)
				if randnum == 0 then
					local actor = Actor.Create("v08", true, { Owner = neutral, Location = spawnzones[i].Location })
				elseif randnum == 1 then
					local actor = Actor.Create("v09", true, { Owner = neutral, Location = spawnzones[i].Location })
				elseif randnum == 2 then
					local actor = Actor.Create("v10", true, { Owner = neutral, Location = spawnzones[i].Location })
				elseif randnum > 2 then
					local actor = Actor.Create("v11", true, { Owner = neutral, Location = spawnzones[i].Location })
				end
				local actor = Actor.Create("giftpointer", true, { Owner = neutral, Location = spawnzones[i].Location + CVec.New(0, 1)})
				pointers[loop] = actor
				loop = loop + 1
			end
		end
	end
end

SpawnElfs = function()
	local creeps = Player.GetPlayer("Creeps")
	local randnum = Utils.RandomInteger(1, 5)
	local randloc = Utils.RandomInteger(1, 3)
	if randloc == 1 then
		local actor = Actor.Create(elfs[randnum], true, { Owner = creeps, Location = EnemySpawn1.Location })
		actor.Scatter()
		actor.Hunt()
	elseif randloc == 2 then
		local actor = Actor.Create(elfs[randnum], true, { Owner = creeps, Location = EnemySpawn2.Location })
		actor.Scatter()
		actor.Hunt()
	end
end

SpawnElfsRepeating = function()
	SpawnElfs()
	Trigger.AfterDelay(DateTime.Seconds(25), function()
		SpawnElfsRepeating()
	end)
end

WorldLoaded = function()
	Player.GetPlayer("Multi0").Cash = 0
	Player.GetPlayer("Multi1").Cash = 0
	InitializePointsAndPlayers()
	InitializeHomes()
	SendMessages()
	SetUpProximityTriggers()
	SetScoreboard()
	Media.PlayMusic("jingle")
	Trigger.AfterDelay(DateTime.Seconds(24), function()
		SpawnTrucks()
	end)
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		SpawnElfsRepeating()
	end)
end
