-- List of all players.
Players = {}
-- List of all disco lights by player.
DiscoLights = {}

ChangeDiscoLights = function(self, captor, oldOwner, newOwner)
    local discoLights = DiscoLights[oldOwner.InternalName]
    for i = 1, #discoLights do
        local discoLight = discoLights[i]
        local oldCell = discoLight.Location
        local cell = CPos.New(oldCell.X + 200, oldCell.Y + 200)
        discoLight.Teleport(cell)
    end
    discoLights = DiscoLights[newOwner.InternalName]
    for i = 1, #discoLights do
        local discoLight = discoLights[i]
        local oldCell = discoLight.Location
        local cell = CPos.New(oldCell.X - 200, oldCell.Y - 200)
        discoLight.Teleport(cell)
    end
end

DestroyDiscoLights = function(self, killer)
    for i = 1, #Players do
        local player = Players[i]
        for j = 1, #DiscoLights[player.InternalName] do
            DiscoLights[player.InternalName][j].Destroy()
        end
    end
end

WorldLoaded = function()
    local comms = Map.NamedActor("Comms")

    Players[1] = Player.GetPlayer("Neutral")
    Players[2] = Player.GetPlayer("Multi0")
    Players[3] = Player.GetPlayer("Multi1")

    for i = 1, #Players do
        local player = Players[i]
        DiscoLights[player.InternalName] = player.GetActorsByType("discolight")
    end

    Trigger.OnCapture(comms, ChangeDiscoLights)
    Trigger.OnKilled(comms, DestroyDiscoLights)
end
