waypoints_a = {}
waypoints_b = {}
waypoints_c = {}
waypoints_d = {}
lefthorses = 0
righthorses = 0
eliminatetimer = 300
player0 = nil
player1 = nil
enemies = {}
enemies[1] = "antscout"
enemies[2] = "antwarrior"
enemies[3] = "antburrower"
enemies[4] = "antgigantus"
enemies[5] = "antpraetor"
enemies[6] = "antbomb"
enemies[7] = "antpoison"
enemies[8] = "antfire"
enemies[9] = "anttesla"
enemies[10] = "antqueen"
enemies[11] = "antharv"
allhorses = {}
lefthorsecounter = 1
righthorsecounter = 1

SetCamera = function(player)
	Camera.Position = cameraspawn.CenterPosition
end

InitializeWaypoints = function()
	waypoints_a[1] = la1
	waypoints_a[2] = la2
	waypoints_a[3] = la3
	waypoints_a[4] = la4
	waypoints_a[5] = la5
	waypoints_a[6] = la6
	waypoints_a[7] = la7
	waypoints_a[8] = la8
	waypoints_a[9] = la9
	waypoints_a[10] = la10
	waypoints_b[1] = lb1
	waypoints_b[2] = lb2
	waypoints_b[3] = lb3
	waypoints_b[4] = lb4
	waypoints_b[5] = lb5
	waypoints_b[6] = lb6
	waypoints_b[7] = lb7
	waypoints_b[8] = lb8
	waypoints_b[9] = lb9
	waypoints_b[10] = lb10
	waypoints_c[1] = lc1
	waypoints_c[2] = lc2
	waypoints_c[3] = lc3
	waypoints_c[4] = lc4
	waypoints_c[5] = lc5
	waypoints_c[6] = lc6
	waypoints_c[7] = lc7
	waypoints_c[8] = lc8
	waypoints_c[9] = lc9
	waypoints_c[10] = lc10
	waypoints_d[1] = ld1
	waypoints_d[2] = ld2
	waypoints_d[3] = ld3
	waypoints_d[4] = ld4
	waypoints_d[5] = ld5
	waypoints_d[6] = ld6
	waypoints_d[7] = ld7
	waypoints_d[8] = ld8
	waypoints_d[9] = ld9
	waypoints_d[10] = ld10
end

SpawnHorses = function()
	if lefthorses < 11 then
		SpawnHorseLeft()
	end
	if righthorses < 11 then
		SpawnHorseRight()
	end
	Trigger.AfterDelay(50, function()
		SpawnHorses()
	end)
end

SpawnHorseLeft = function()
    local creeps = Player.GetPlayer("Creeps")
	local actor = Actor.Create(enemies[allhorses[lefthorsecounter]], true, { Owner = creeps, Location = spawnleft.Location })
	lefthorsecounter = lefthorsecounter + 1
	Trigger.OnKilled(actor, function()
		DecreaseLeftHorse()
	end)
	StartLane(actor, 6)
	lefthorses = lefthorses + 1
end

SpawnHorseRight = function()
    local creeps = Player.GetPlayer("Creeps")
	local actor = Actor.Create(enemies[allhorses[righthorsecounter]], true, { Owner = creeps, Location = spawnright.Location })
	righthorsecounter = righthorsecounter + 1
	Trigger.OnKilled(actor, function()
		DecreaseRightHorse()
	end)
	StartLane(actor, 1)
	righthorses = righthorses + 1
end

DecreaseRightHorse = function()
	righthorses = righthorses - 1
end

DecreaseLeftHorse = function()
	lefthorses = lefthorses - 1
end

StartLane = function(mover, start)
	local lane = Utils.RandomInteger(1, 5)
	if lane == 1 then
		mover.AddTag("lane_a")
		mover.ScriptedMove(waypoints_a[start].Location)
	elseif lane == 2 then
		mover.AddTag("lane_b")
		mover.ScriptedMove(waypoints_b[start].Location)
	elseif lane == 3 then
		mover.AddTag("lane_c")
		mover.ScriptedMove(waypoints_c[start].Location)
	elseif lane == 4 then
		mover.AddTag("lane_d")
		mover.ScriptedMove(waypoints_d[start].Location)
	end
end

MoveInLanes = function(mover, nextpos, lane)
	if lane == 1 then
		mover.ScriptedMove(waypoints_a[nextpos].Location)
	elseif lane == 2 then
		mover.ScriptedMove(waypoints_b[nextpos].Location)
	elseif lane == 3 then
		mover.ScriptedMove(waypoints_c[nextpos].Location)
	elseif lane == 4 then
		mover.ScriptedMove(waypoints_d[nextpos].Location)
	end
end

MoveInWayPoints = function()
	for i = 1, #waypoints_a do
		Trigger.OnEnteredFootprint({ waypoints_a[i].Location }, function(a, id)
			if a.HasTag("lane_a") then
				local nextpos = i + 1
				if i == 10 then
					nextpos = 1
				end
				MoveInLanes(a, nextpos, 1)
			end
		end)
	end
	for i = 1, #waypoints_b do
		Trigger.OnEnteredFootprint({ waypoints_b[i].Location }, function(a, id)
			if a.HasTag("lane_b") then
				local nextpos = i + 1
				if i == 10 then
					nextpos = 1
				end
				MoveInLanes(a, nextpos, 2)
			end
		end)
	end
	for i = 1, #waypoints_c do
		Trigger.OnEnteredFootprint({ waypoints_c[i].Location }, function(a, id)
			if a.HasTag("lane_c") then
				local nextpos = i + 1
				if i == 10 then
					nextpos = 1
				end
				MoveInLanes(a, nextpos, 3)
			end
		end)
	end
	for i = 1, #waypoints_c do
		Trigger.OnEnteredFootprint({ waypoints_d[i].Location }, function(a, id)
			if a.HasTag("lane_d") then
				local nextpos = i + 1
				if i == 10 then
					nextpos = 1
				end
				MoveInLanes(a, nextpos, 4)
			end
		end)
	end
end

TimerText = function()
	if eliminatetimer >= 0 then
		local minutes = math.floor(eliminatetimer / 60)
		local seconds = eliminatetimer - (minutes * 60)
		local timetext = ""
		if seconds < 10 then
			timetext = "" .. minutes .. ":0" .. seconds .. ""
		else
			timetext = "" .. minutes .. ":" .. seconds .. ""
		end
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			eliminatetimer = eliminatetimer - 1
			UserInterface.SetMissionText("Time left: " .. timetext .. "\nPlayer scores:\n" .. player0.Name .. " " .. player0.Experience .. "\n" .. player1.Name .. " " .. player1.Experience .. "", HSLColor.White)
			TimerText()
		end)
	elseif eliminatetimer < 0 then
		UserInterface.SetMissionText("Competition has ended!", HSLColor.White)
		if player0.Experience > player1.Experience then
			player1.MarkFailedObjective(0)
		elseif player0.Experience < player1.Experience then
			player0.MarkFailedObjective(0)
		else
			UserInterface.SetMissionText("There is a tie! The next player to get a kill wins!", HSLColor.White)
			TieWinner()
		end
	end
end

TieWinner = function()
	if player0.Experience > player1.Experience then
		UserInterface.SetMissionText("Competition has ended!", HSLColor.White)
		player1.MarkFailedObjective(0)
	elseif player0.Experience < player1.Experience then
		UserInterface.SetMissionText("Competition has ended!", HSLColor.White)
		player0.MarkFailedObjective(0)
	else
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			TieWinner()
		end)
	end
end

InitializeGame = function ()
	Media.DisplayMessage("Ants spawn from both sides of the map and run around the circus.")
	Trigger.AfterDelay(DateTime.Seconds(4), function()
		Media.DisplayMessage("Your mission is to kill more ants than your opponent.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(8), function()
		Media.DisplayMessage("Good luck!")
	end)
	Trigger.AfterDelay(DateTime.Seconds(12), function()
		if player0.IsLocalPlayer then
			SetCamera(player0)
		elseif player1.IsLocalPlayer then
			SetCamera(player1)
		end
		InitializeWaypoints()
		Trigger.AfterDelay(4, function()
			SpawnHorses()
		end)
		MoveInWayPoints()
		TimerText()
		RandomizeStarts ()
	end)
end

RandomizeStarts = function ()
	local start = Utils.RandomInteger(1, 3)
	if start == 1 then
		a1.Owner = player0
		a2.Owner = player0
		b1.Owner = player1
		b2.Owner = player1
	else
		a1.Owner = player1
		a2.Owner = player1
		b1.Owner = player0
		b2.Owner = player0
	end
	local actor = Actor.Create("apwr", true, { Owner = player0, Location = pow0.Location })
	local actor = Actor.Create("apwr", true, { Owner = player1, Location = pow1.Location })
end

InitializeHorses = function()
	local randomAnt =  1
	for i = 1, 1000 do
		randomAnt = Utils.RandomInteger(1, 12)
		allhorses[i] = randomAnt
	end
end

WorldLoaded = function()
	player0 = Player.GetPlayer("Multi0")
	player1 = Player.GetPlayer("Multi1")
	InitializeHorses()
	InitializeGame()
end
