aspawns = {}
bspawns = {}
cspawns = {}
dspawns = {}
espawns = {}
enemies = {}
player0 = nil
player1 = nil
creep = nil
rounds = 0

SetCamera = function(player)
	local mcv = player.GetActorsByType("mcv")[1]
	Camera.Position = mcv.CenterPosition
end

InitializeAndSpawnsAndEnemies = function ()
	aspawns[1] = A1
	aspawns[2] = A2
	bspawns[1] = B1
	bspawns[2] = B2
	cspawns[1] = C1
	cspawns[2] = C2
	dspawns[1] = D1
	dspawns[2] = D2
	espawns[1] = E1
	espawns[2] = E2
	enemies[1] = "antscout"
	enemies[2] = "antwarrior"
	enemies[3] = "antburrower"
	enemies[4] = "antgigantus"
	enemies[5] = "antpraetor"
	enemies[6] = "antbomb"
	enemies[7] = "antpoison"
	enemies[8] = "antfire"
	enemies[9] = "anttesla"
	enemies[10] = "antdrone"
end

SpawnEnemies = function()
	local delay = Utils.RandomInteger(1, 20)
	Trigger.AfterDelay(DateTime.Seconds(delay), function()
		SpawnEnemiesAs()
	end)
	delay = Utils.RandomInteger(1, 20)
	Trigger.AfterDelay(DateTime.Seconds(delay), function()
		SpawnEnemiesBs()
	end)
	delay = Utils.RandomInteger(1, 20)
	Trigger.AfterDelay(DateTime.Seconds(delay), function()
		SpawnEnemiesCs()
	end)
	delay = Utils.RandomInteger(1, 20)
	Trigger.AfterDelay(DateTime.Seconds(delay), function()
		SpawnEnemiesDs()
	end)
	delay = Utils.RandomInteger(1, 20)
	Trigger.AfterDelay(DateTime.Seconds(delay), function()
		SpawnEnemiesEs()
	end)
	rounds = rounds + 1
	Trigger.AfterDelay(DateTime.Seconds(40), function()
		SpawnEnemies()
	end)
end

SpawnEnemiesAs = function()
	local scouts = rounds
	local warriors = math.floor(rounds / 5)
	local randoms = 0
	local randomNum = 0
	if rounds > 5 then
		scouts = 5 + math.floor(rounds / 10)
	end
	if warriors > 3 then
		warriors = 3
	end
	if rounds > 5 then
		randoms = Utils.RandomInteger(1, 3)
		randomNum = Utils.RandomInteger(3, 8)
	end
	if A1.IsDead == false then
		for i = 1, scouts do
			local actor = Actor.Create(enemies[1], true, { Owner = creep, Location = A1.Location })
			actor.Hunt()
		end
		for i = 1, warriors do
			local actor = Actor.Create(enemies[2], true, { Owner = creep, Location = A1.Location })
			actor.Hunt()
		end
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = A1.Location })
			actor.Hunt()
		end
	end
	if A2.IsDead == false then
		for i = 1, scouts do
			local actor = Actor.Create(enemies[1], true, { Owner = creep, Location = A2.Location })
			actor.Hunt()
		end
		for i = 1, warriors do
			local actor = Actor.Create(enemies[2], true, { Owner = creep, Location = A2.Location })
			actor.Hunt()
		end
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = A2.Location })
			actor.Hunt()
		end
	end
	local colonies = creep.GetActorsByType("antcolony.spawner")
	local destroyed = 10 - #colonies
	randomNum = Utils.RandomInteger(3, 9)
	if destroyed > 0 then
		if A1.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = A1.Location })
				actor.Hunt()
			end
		end
		if A2.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = A2.Location })
				actor.Hunt()
			end
		end
	end
end

SpawnEnemiesBs = function()
	local scouts = rounds
	local warriors = math.floor(rounds / 5)
	local randoms = 0
	local randomNum = 0
	if rounds > 5 then
		scouts = 5 + math.floor(rounds / 10)
	end
	if warriors > 3 then
		warriors = 3
	end
	if rounds > 10 then
		randoms = Utils.RandomInteger(1, 3)
		randoms = randoms + math.floor(rounds / 10)
		randomNum = Utils.RandomInteger(3, 9)
	end
	if B1.IsDead == false then
		for i = 1, scouts do
			local actor = Actor.Create(enemies[1], true, { Owner = creep, Location = B1.Location })
			actor.Hunt()
		end
		for i = 1, warriors do
			local actor = Actor.Create(enemies[2], true, { Owner = creep, Location = B1.Location })
			actor.Hunt()
		end
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = B1.Location })
			actor.Hunt()
		end
	end
	if B2.IsDead == false then
		for i = 1, scouts do
			local actor = Actor.Create(enemies[1], true, { Owner = creep, Location = B2.Location })
			actor.Hunt()
		end
		for i = 1, warriors do
			local actor = Actor.Create(enemies[2], true, { Owner = creep, Location = B2.Location })
			actor.Hunt()
		end
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = B2.Location })
			actor.Hunt()
		end
	end
	local colonies = creep.GetActorsByType("antcolony.spawner")
	local destroyed = 10 - #colonies
	randomNum = Utils.RandomInteger(3, 9)
	if destroyed > 0 then
		if B1.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = B1.Location })
				actor.Hunt()
			end
		end
		if B2.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = B2.Location })
				actor.Hunt()
			end
		end
	end
end

SpawnEnemiesCs = function()
	local randoms = 0
	local randomNum = 0
	if rounds > 5 then
		randoms = Utils.RandomInteger(1, 3)
		randoms = randoms + math.floor(rounds / 10)
		randomNum = Utils.RandomInteger(3, 9)
	end
	if C1.IsDead == false then
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = C1.Location })
			actor.Hunt()
		end
	end
	if C2.IsDead == false then
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = C2.Location })
			actor.Hunt()
		end
	end
	local colonies = creep.GetActorsByType("antcolony.spawner")
	local destroyed = 10 - #colonies
	randomNum = Utils.RandomInteger(3, 9)
	if destroyed > 0 then
		if C1.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = C1.Location })
				actor.Hunt()
			end
		end
		if C2.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = C2.Location })
				actor.Hunt()
			end
		end
	end
end

SpawnEnemiesDs = function()
	local randoms = 0
	local randomNum = 0
	if rounds > 5 then
		randoms = Utils.RandomInteger(1, 4)
		randoms = randoms + math.floor(rounds / 10)
		randomNum = Utils.RandomInteger(3, 9)
	end
	if D1.IsDead == false then
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = D1.Location })
			actor.Hunt()
		end
	end
	if D2.IsDead == false then
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = D2.Location })
			actor.Hunt()
		end
	end
	local colonies = creep.GetActorsByType("antcolony.spawner")
	local destroyed = 10 - #colonies
	randomNum = Utils.RandomInteger(3, 9)
	if destroyed > 0 then
		if D1.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = D1.Location })
				actor.Hunt()
			end
		end
		if D2.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = D2.Location })
				actor.Hunt()
			end
		end
	end
end

SpawnEnemiesEs = function()
	local drones = math.floor(rounds / 6)
	if E1.IsDead == false then
		for i = 1, drones do
			local actor = Actor.Create(enemies[10], true, { Owner = creep, Location = E1.Location })
			actor.Hunt()
		end
	end
	if E2.IsDead == false then
		for i = 1, drones do
			local actor = Actor.Create(enemies[10], true, { Owner = creep, Location = E2.Location })
			actor.Hunt()
		end
	end
	local colonies = creep.GetActorsByType("antcolony.spawner")
	local destroyed = 10 - #colonies
	local randomNum = Utils.RandomInteger(3, 9)
	if destroyed > 0 then
		if E1.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = E1.Location })
				actor.Hunt()
			end
		end
		if E2.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = E2.Location })
				actor.Hunt()
			end
		end
	end
end

SpawnGigantus = function()
	local player0Briks = {}
	local player1Briks = {}
	local spawns = {}
	local closestSpawn = nil
	player0Briks = player0.GetActorsByType("brik")
	player1Briks = player1.GetActorsByType("brik")
	if #player0Briks > 0 then
		local randomSpawn = Utils.RandomInteger(1, 6)
		spawns = creep.GetActorsByType("antcolony.spawner")
		prevDist = 100000000
		if #spawns > 0 then
			for i = 1, #spawns do
				local xd = spawns[i].Location.X - player0Briks[1].Location.X
				local yd = spawns[i].Location.Y - player0Briks[1].Location.Y
				local distance = math.sqrt((xd * xd) + (yd * yd))
				if distance < prevDist then
					closestSpawn = spawns[i]
					prevDist = distance
				end
			end
			local actor = Actor.Create(enemies[4], true, { Owner = creep, Location = closestSpawn.Location })
			actor.AttackMove(player0Briks[1].Location)
		end
	end
	prevDist = 100000000
	if #player1Briks > 0 then
		local randomSpawn = Utils.RandomInteger(1, 6)
		spawns = creep.GetActorsByType("antcolony.spawner")
		prevDist = 100000000
		if #spawns > 0 then
			for i = 1, #spawns do
				local xd = spawns[i].Location.X - player1Briks[1].Location.X
				local yd = spawns[i].Location.Y - player1Briks[1].Location.Y
				local distance = math.sqrt((xd * xd) + (yd * yd))
				if distance < prevDist then
					closestSpawn = spawns[i]
					prevDist = distance
				end
			end
			local actor = Actor.Create(enemies[4], true, { Owner = creep, Location = closestSpawn.Location })
			actor.AttackMove(player1Briks[1].Location)
		end
	end
	Trigger.AfterDelay(DateTime.Seconds(65), function()
		SpawnGigantus()
	end)
end

WakeyWakey = function()
	local allActors = creep.GetActors()
	local looper = 1
	for i = 1, #enemies do
		local baddies = creep.GetActorsByType(enemies[i])
		if #baddies > 0 then
			for a = 1, #baddies do
				baddies[a].Stop()
				baddies[a].Hunt()
			end
		end
	end
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		WakeyWakey()
	end)
end

WorldLoaded = function()
	player0 = Player.GetPlayer("Multi0")
	player1 = Player.GetPlayer("Multi1")
	creep = Player.GetPlayer("Creeps")
	if player0.IsLocalPlayer then
		SetCamera(player0)
	elseif player1.IsLocalPlayer then
		SetCamera(player1)
	end
	InitializeAndSpawnsAndEnemies()
	Trigger.AfterDelay(DateTime.Seconds(480), function()
		SpawnGigantus()
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		WakeyWakey()
	end)
	Trigger.AfterDelay(DateTime.Seconds(30), function()
		SpawnEnemies()
	end)
end
