players = {}
playeralivechecker = {}
spawnsset = 1
firstkilled = false
messageloop = 0
therewasatie = false
eliminatetimer = 0
prevalive = 0
endtimer = false

FindAliveCheckers = function(player)
	local allActors = Map.ActorsInWorld
	local looper = 1
	for i = 1, #allActors do
		if allActors[i].Type == "alivechecker" then
			playeralivechecker[looper] = allActors[i]
			Trigger.OnKilled(allActors[i], function()
				if firstkilled == false then
					Media.DisplayMessage("The first player has been eliminated. From now on a player is eliminated every two minutes.")
					eliminatetimer = 120
					Trigger.AfterDelay(DateTime.Seconds(120), function()
						EliminateWorstPlayer()
					end)
					prevalive = #players - 1
				end
				firstkilled = true
				DistributeMoney(allActors[i].Owner)
				playerkilledbyscript = false
			end)
			looper = looper + 1
		end
	end
	for i = 1, #playeralivechecker do
		players[i] = playeralivechecker[i].Owner
	end
	PlayerStarts()
end

PlayerStarts = function(player)
	local neutral = Player.GetPlayer("Neutral")
	local allActors = Map.ActorsInWorld
	local possiblemcvs = {}
	local randnum = 0
	local tosetspawn = false
	local spawnset = false
	local dontkill = false
	local listofnums = {}
	local looper = 1
	possiblemcvs = neutral.GetActorsByType("mcv")
	for i = 1, #players do
		while spawnset == false do
			randnum = Utils.RandomInteger(1, #possiblemcvs + 1)
			tosetspawn = true
			for i = 1, #listofnums do
				if randnum == listofnums[i] then
					tosetspawn = false
				end
			end
			listofnums[#listofnums + 1] = randnum
			if tosetspawn == true then
				possiblemcvs[randnum].Owner = players[i]
				spawnset = true
			end
		end
		spawnset = false
	end
	for i = 1, #possiblemcvs do
		for a = 1, #listofnums do
			if i == listofnums[a] then
				dontkill = true
			end
		end
		if dontkill == false then
			possiblemcvs[i].Destroy()
		end
		dontkill = false
	end
	for i = 1, #allActors do
		if allActors[i].Type == "alivekeeper" then
			allActors[i].Owner.Cash = 7500
			allActors[i].Destroy()
		end
	end
end

DistributeMoney = function(deadplayer)
	local money = deadplayer.Cash
	local allActors = Map.ActorsInWorld
	local whostillalive = {}
	local looper = 1
	Trigger.AfterDelay(4, function()
		for i = 1, #allActors do
			if allActors[i].Type == "alivechecker" then
				if allActors[i].Owner ~= deadplayer then
					whostillalive[looper] = allActors[i]
					looper = looper + 1
				end
			end
		end
		for i = 1, #whostillalive do
			whostillalive[i].Owner.Cash = whostillalive[i].Owner.Cash + math.floor(money / #whostillalive) + 1000
		end
		Media.DisplayMessage("Player " .. deadplayer.Name .. " had " .. money .. "$ in cash. Remaining " .. #whostillalive .. " players all get " .. math.floor(money / #whostillalive)	.. "$ and an extra 1000$ each.")
	end)
end

SixMinutesPassed = function()
	if firstkilled == false then
		firstkilled = true
		Media.DisplayMessage("Six minutes has passed.")
		EliminateWorstPlayer()
	end
end

EliminateWorstPlayer = function()
	local allActors = Map.ActorsInWorld
	local whostillalive = {}
	local whostheworst = nil
	local worstscore = 0
	local bestscore = -1
	local looper = 1
	local tiecounter = 0
	local previousworstscore = 0
	for i = 1, #allActors do
		if allActors[i].Type == "alivechecker" then
			whostillalive[looper] = allActors[i]
			looper = looper + 1
		end
	end
	if #whostillalive >= 5 then
		for i = 1, #whostillalive do
			if bestscore <= whostillalive[i].Owner.Experience then
				bestscore = whostillalive[i].Owner.Experience
			end
		end
		worstscore = bestscore
		previousworstscore = bestscore
		for i = 1, #whostillalive do
			if worstscore >= whostillalive[i].Owner.Experience then
				worstscore = whostillalive[i].Owner.Experience
				if worstscore == previousworstscore then
					tiecounter = tiecounter + 1
				else
					tiecounter = 0
				end
				previousworstscore = worstscore
				whostheworst = whostillalive[i].Owner
			end
		end
		if #whostillalive < prevalive then
			Media.DisplayMessage("A player was eliminated while the elimination counter was running. The next player is eliminated in two minutes.")
			eliminatetimer = 120
			Trigger.AfterDelay(DateTime.Seconds(120), function()
				EliminateWorstPlayer()
			end)
			therewasatie = false
			prevalive = #whostillalive
		else
			prevalive = #whostillalive
			if therewasatie == true then
				for i = 1, #whostillalive do
					if whostillalive[i].Owner.Experience == worstscore then
						Media.DisplayMessage("" .. whostillalive[i].Owner.Name .. " had the worst score and was eliminated. The next player is eliminated in two minutes.")
						whostillalive[i].Owner.MarkFailedObjective(0)
						prevalive = prevalive - 1
					end
				end
				therewasatie = false
				eliminatetimer = 120
				Trigger.AfterDelay(DateTime.Seconds(120), function()
					EliminateWorstPlayer()
				end)
			elseif therewasatie == false then
				if tiecounter < 1 then
					Media.DisplayMessage("" .. whostheworst.Name .. " had the worst score and was eliminated. The next player is eliminated in two minutes.")
					whostheworst.MarkFailedObjective(0)
					prevalive = prevalive - 1
					therewasatie = false
					eliminatetimer = 120
					Trigger.AfterDelay(DateTime.Seconds(120), function()
						EliminateWorstPlayer()
					end)
				elseif tiecounter >= 1 then
					Media.DisplayMessage("There is a tie between " .. (tiecounter + 1) .. " players! You have a minute to distinquish yourself until all the players with the worst score are eliminated!")
					therewasatie = true
					prevalive = #whostillalive
					eliminatetimer = 60
					Trigger.AfterDelay(DateTime.Seconds(60), function()
						EliminateWorstPlayer()
					end)
				end
			end
		end
	else
		Media.DisplayMessage("There are only " .. #whostillalive .. " players left! No more player will be automatically eliminated.")
		endtimer = true
	end
end

DisplayMessages = function()
	if messageloop == 0 then
		Media.DisplayMessage("After six minutes the player with the worst score is eliminated.")
	elseif messageloop == 1 then
		Media.DisplayMessage("After this or after the first player is defeated, the player with the worst score is eliminated every two minutes!")
	elseif messageloop == 2 then
		Media.DisplayMessage("If there is a tie, the players with the worst score have a minute to gain more points or all of them are eliminated!")
	elseif messageloop == 3 then
		Media.DisplayMessage("This continues after there is only four or less players remaining.")
	elseif messageloop == 4 then
		Media.DisplayMessage("If a player is eliminated while the elimination counter was running, the timer is reset after the timer has ran out.")
	elseif messageloop == 5 then
		Media.DisplayMessage("When a player is killed their cash reserves are distributed among the remaining players, and the remaining player receive an extra 1000$.")
	elseif messageloop == 6 then
		Media.DisplayMessage("Killed units reward a 25% bounty and leave behind valuable scrap metals and gore for Harvesters to collect.")
	elseif messageloop == 7 then
		Media.DisplayMessage("Players star with 7500$. Let nothing go to waste!")
	end
	if messageloop < 8 then
		Trigger.AfterDelay(DateTime.Seconds(4), function()
			DisplayMessages()
		end)
	end
	messageloop = messageloop + 1
end

EliminationText = function()
	if endtimer == false then
		local minutes = math.floor(eliminatetimer / 60)
		local seconds = eliminatetimer - (minutes * 60)
		local timetext = ""
		if seconds < 10 then
			timetext = "" .. minutes .. ":0" .. seconds .. ""
		else
			timetext = "" .. minutes .. ":" .. seconds .. ""
		end
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			eliminatetimer = eliminatetimer - 1
			UserInterface.SetMissionText("Time until next elimination " .. timetext, HSLColor.White)
			EliminationText()
		end)
	else
		UserInterface.SetMissionText("No more players will be automatically eliminated", HSLColor.White)
	end
end

WorldLoaded = function()
	DisplayMessages()
	Trigger.AfterDelay(DateTime.Seconds(32), function()
		FindAliveCheckers()
	end)
	Trigger.AfterDelay(DateTime.Seconds(360), function()
		SixMinutesPassed()
	end)
	eliminatetimer = 360
	EliminationText()
end
