function RepairNearbyUnits(mechanic)
	if (not mechanic.IsInWorld or mechanic.IsDead) then
		return false;
	end

	local nearbyRepairableActors = findNearbyActors(mechanic, function(self)
		if (not self.IsInWorld and not self.IsDead) then
			return false;
		end

		return Utils.Any(TankTypes, function(tankType)
			return self.Type == tankType;
		end)
	end);
	--Media.DisplayMessage("nearbyRepairableActors num! " .. #nearbyRepairableActors, "AI", HSLColor.Yellow);
	local heavilyDamagedActors = Utils.Where(nearbyRepairableActors, function(self)
		return self.Health < (self.MaxHealth / 2)
	end);

	if (#heavilyDamagedActors > 0) then
		--Media.DisplayMessage("Sendig mechanic to heavily damaged!", "AI", HSLColor.Yellow);
		mechanic.Guard(Utils.Random(heavilyDamagedActors));
	elseif (#nearbyRepairableActors > 0) then
		--Media.DisplayMessage("Sendig mechanic to random!", "AI", HSLColor.Yellow);
		mechanic.Guard(Utils.Random(nearbyRepairableActors));
	end
end

function DemoTruckBehaviour(truck)
	Once("OnIdle", truck, function(self)
		local targets = GetTargets(self.Owner);

		if #targets > 0 then
			self.AttackMove(
					Utils.Random(targets).Location
			)
		end
	end)
end

function MechanicBehaviour(mechanic)
	local FindRepairables = function()
		return RepairNearbyUnits(mechanic)
	end

	OnIdleThrottle(mechanic, FindRepairables);
end

function EngineerBehaviour(engineer)
	local nearByOils = Map.ActorsInCircle(
			engineer.CenterPosition,
			WDist.FromCells(50),
			function(actor)
				return actor.Type == "oilb"
			end
	);

	for _, oil in ipairs(nearByOils) do
		engineer.Capture(oil);

		--Trigger.OnIdle(engineer, function(self)
		--	if (self.IsInWorld) then
		--		local _actors = Map.ActorsInCircle(self.CenterPosition, WDist.FromCells(5), function()
		--			return true;
		--		end);
		--		--Media.DisplayMessage("Actor around: " .. Utils.Random(_actors).Type, "AI", HSLColor.Red);
		--
		--		local nearOils = Utils.Where(_actors, function(_actor)
		--			return _actor.Type == "oilb";
		--		end);
		--
		--		if #nearOils > 0 then
		--			--Media.DisplayMessage("Oils around: " .. Utils.Random(nearOils).Type, "AI", HSLColor.Cyan);
		--
		--			local randomNearOil = Utils.Random(nearOils);
		--
		--			if (randomNearOil.Owner ~= player) then
		--				self.Capture(randomNearOil);
		--			end
		--		end
		--	end
		--	--Map.ActorsInCircle(engineer.CenterPosition, WDist.New(2048));
		--end)
	end

end

function VehicleBehaviour(actor)
	if (actor.Type == "dtrk") then
		return ;
	end

	OnDamageThrottle(
			actor,
			function()
				local isCriticallyDamaged = actor.Health < (actor.MaxHealth / 3)

				if (not isCriticallyDamaged) then
					return ;
				end

				local ServiceDepot = GetNearestServiceDepot(actor);
				Media.DisplayMessage("Looking for a service depot " .. actor.Type, "AI", HSLColor.Yellow);
				if (ServiceDepot ~= false) then
					Media.DisplayMessage("Depot found", "AI", HSLColor.Yellow);
					actor.Move(ServiceDepot.Location);
				end
			end,
			Utils.RandomInteger(
					DateTime.Seconds(1),
					DateTime.Seconds(3)
			)
	)
end
