-- Copyright Azarus @ 2022

-- TODO
-- Avoid multiple initial radars
-- make sure war factory is done soon
-- assign mines to a player to know if should be targeted
-- mcv deploy closer to mines or something better than now
-- harvester ref ratio
-- harvester mine ratio
-- ic
-- suicide yaks



-- Descendant
--table.sort(t, function(a, b) return a > b end)

-- Ascendant
--table.sort(t)



-- https://github.com/OpenRA/OpenRA/blob/3be0e9e8a57f648d11150cfb9632bd8488037c64/mods/ra/rules/vehicles.yaml
TankTypes = {
    "v2rl",
    "1tnk",
    "2tnk",
    "3tnk",
    "4tnk",
    "arty",
    --"harv",
    "jeep",
    "apc",
    --"mnly",
    "2tnk",
    "mgg",
    "mrj",
    "ttnk",
    "ftrk",
    "dtrk",
    "ctnk",
    "dtrk",
    --"stnk"
}

Angles = {
    Angle.East,
    Angle.North,
    Angle.NorthEast,
    Angle.NorthWest,
    Angle.South,
    Angle.SouthEast,
    Angle.SouthWest,
    Angle.West
}

InfantryTypes = {
    "dog",
    "e1", -- rifler
    "e2", -- grenadier
    "e3", -- rocket
    "e3r1",
    "e4",
    "e1",
    "spy",
    "e7",
    "medi",
    "mech",
    "gnrl",
    "thf",
    "shok",
    "sniper"
}

InfrantryCostForAI = {
    e1 = 50,
    e2 = 75,
    e3 = 75,
}

InitialMCVIntervals = {
    5, 15
}
-- AI Fun Sequence. Scare the players.
function sendFunMessages()
    --UserInterface.SetMissionText('I will kill you.');

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        Media.PlaySoundNotification(USSR, "AlertBuzzer")
    end)

    Trigger.AfterDelay(DateTime.Seconds(3), function()
        Media.PlaySoundNotification(USSR, "AlertBuzzer")
    end)

    Trigger.AfterDelay(DateTime.Seconds(5), function()
        Media.PlaySoundNotification(USSR, "AlertBuzzer")
    end)

    Trigger.AfterDelay(DateTime.Seconds(4), function()
        for _, player in ipairs(AIPlayers) do
            Media.DisplayMessage(player.Name .. " just awakened!", "", HSLColor.Red)
        end

        -- Does not work
        --Lighting.Flash("LightningStrike", Utils.RandomInteger(1, 10));
    end)

    Trigger.AfterDelay(DateTime.Seconds(6), function()
        Media.PlaySpeechNotification(USSR, "TargetFreed")
    end)

    Trigger.AfterDelay(DateTime.Seconds(11), function()
        Media.PlaySpeechNotification(USSR, "EnemyDetected")
    end)

    Trigger.AfterDelay(DateTime.Seconds(15), function()
        for _, humanPlayer in ipairs(HumanPlayers) do
            for _, player in ipairs(AIPlayers) do
                Radar.Ping(humanPlayer, Map.CenterOfCell(player.HomeLocation), HSLColor.Red, 500)
                Beacon.New(humanPlayer, Map.CenterOfCell(player.HomeLocation), 500)
            end
        end

        Media.PlaySoundNotification(USSR, "Beacon");
    end)

    Trigger.AfterDelay(DateTime.Seconds(15), function()
        for _, player in ipairs(AIPlayers) do
            Media.DisplayMessage("I will destroy you all!", player.Name, HSLColor.Red)
        end
    end)

    Trigger.AfterDelay(DateTime.Seconds(20), function()
        Media.PlaySoundNotification(USSR, "BaseSetup")
    end)

    Trigger.AfterDelay(DateTime.Seconds(20), function()
        for _, player in ipairs(AIPlayers) do
            Media.DisplayMessage("You think you know how to play? MUAHAHA. Let's see then what you got!!!", player.Name, HSLColor.Red)
        end
    end)
end

-- Marc
function compileTable(table)
    local index = 1
    local holder = "{"
    while true do
        if type(table[index]) == "function" then
            index = index + 1
        elseif type(table[index]) == "table" then
            holder = holder .. compileTable(table[index])
        elseif type(table[index]) == "number" then
            holder = holder .. tostring(table[index])
        elseif type(table[index]) == "string" then
            holder = holder .. "\"" .. table[index] .. "\""
        elseif table[index] == nil then
            holder = holder .. "nil"
        elseif type(table[index]) == "boolean" then
            holder = holder .. (table[index] and "true" or "false")
        end
        if index + 1 > #table then
            break
        end
        holder = holder .. ","
        index = index + 1
    end
    return holder .. "}"
end

ChooseRandomTarget = function(unit, enemyPlayer)
    local target = nil
    local enemies = Utils.Where(enemyPlayer.GetActors(), function(self)
        return self.HasProperty("Health") and unit.CanTarget(self) and not Utils.Any({ "sbag", "fenc", "brik", "cycl", "barb" }, function(type)
            return self.Type == type
        end)
    end)
    if #enemies > 0 then
        target = Utils.Random(enemies)
    end
    return target
end

--OnAnyDamaged = function(actors, func)
--    Utils.Do(actors, function(actor)
--        Trigger.OnDamaged(actor, func)
--    end)
--end

function GetTargets(player)
    return Utils.Where(
            GetRandomEnemy(player).GetActors(),
            function(actor)
                if (IsSamePlayer(player, actor.Owner)) then
                    return false
                end

                return
                actor.HasProperty("Sell") and
                        actor.Type ~= "brik" and
                        actor.Type ~= "sbag"
            end
    )
end

function IsEmpty(table)
    return next(table) == nil
end

function GiveMCV(player)
    Actor.Create(
            "mcv",
            true,
            {
                Owner = player,
                Location = player.HomeLocation + CVec.New(0, 1)
            }
    );
end

function GiveHarvester(player)
    Actor.Create(
            "harv",
            true,
            {
                Owner = player,
                Location = player.HomeLocation + CVec.New(0, 1)
            }
    );
end

function GiveMassInfantry(player, amount, unitType)
    if unitType == nil then
        unitType = "e1"
    end

    GiveMassOfUnit(
            player,
            unitType,
            amount,
            function(unit)
                --unit.AttackMove(barrack.RallyPoint);
            end
    )
end

function GiveMassOfUnit(player, unitType, amount, callback)
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("Just enabled a cheat to mass produce " .. unitType .. " OMG!", "AI", HSLColor.Red)

    local unitCount = amount;
    while unitCount > 0 do
        local unit = Actor.Create(
                unitType,
                true,
                {
                    Owner = player,
                    Location = player.HomeLocation + CVec.New(0, 1)
                }
        );

        if (callback) then
            callback(unit);
        end

        unitCount = unitCount - 1;

        if (unitCount <= 0) then
            return ;
        end
    end
end

-- Return false within callback to cancel repetition
function RepeatEvery(dateTime, callback)
    local functionToRepeat

    functionToRepeat = function()
        Trigger.AfterDelay(
                dateTime,
                function()
                    local result = callback();

                    if (result == false) then
                        Media.DisplayMessage("Cancelled repeat", "AI", HSLColor.Red)
                    else
                        --Media.DisplayMessage("Repeating action", "AI", HSLColor.Black)
                        functionToRepeat();
                    end
                end
        );
    end

    functionToRepeat();
end

-- Randomizer.
function GetItemByIndex(array, index)
    for i, k in ipairs(array) do
        if i == index then
            return k;
        end
    end

    return "invalid_index";
end

function GetRandomTank()
    return Utils.Random(TankTypes);
end

function GetRandomInfantry()
    return Utils.Random(InfantryTypes);
end

function GetBots()
    return Player.GetPlayers(function(player)
        return player.IsBot == true;
    end);
end

function GetHumans()
    return Player.GetPlayers(function(player)
        return player.IsBot == false and player.IsNonCombatant == false;
    end);
end

function IsSamePlayer(playerA, playerB)
    return playerA.Spawn == playerB.Spawn;
end

function GetEnemies(currentPlayer)
    return Player.GetPlayers(function(player)
        if (player.IsNonCombatant == true) then
            return false;
        end

        if (IsSamePlayer(currentPlayer, player)) then
            return false;
        end

        if (currentPlayer.Team == 0) then
            return true;
        end

        return player.Team ~= currentPlayer.Team;
    end);
end

function GetRandomEnemy(player)
    local enemies = GetEnemies(player);

    if (IsEmpty(enemies)) then
        return;
    end

    return Utils.Random(enemies);
end

function GetAllPlayers()
    return Player.GetPlayers(function(player)
        return player.IsNonCombatant == false;
    end);
end

function findNearbyActors(actor, filter, distanceInCells)
    distanceInCells = distanceInCells or 5
    filter = filter or function(self)
        return self.IsInWorld;
    end

    return Map.ActorsInCircle(actor.CenterPosition, WDist.FromCells(distanceInCells), filter)
end

--function findNearbyActorsByType(WPos, type, distanceInCells)
--	distanceInCells = distanceInCells or 5
--
--	return Map.ActorsInCircle(WPos, WDist.FromCells(distanceInCells), function(actor)
--		return actor.Type == type;
--	end)
--end

--function SendMechanicsOnDamage(actor)
--	Trigger.OnDamaged(actor, function(self, attacker, damage)
--		if (not self.IsInWorld) then
--			return Trigger.Clear(self, "OnDamaged");
--		end
--
--		if (self.Health < (self.MaxHealth / 2)) then
--			local mechs = findNearbyActorsByType(self.CenterPosition, "mech");
--
--			if (#mechs > 0) then
--				Media.DisplayMessage(
--						"Sending mechanics: " .. self.Type .. " #".. #mechs,
--						"AI",
--						HSLColor.Salmon
--				);
--
--				for _, mechanic in ipairs(mechs) do
--					mechanic.Guard(self)
--				end
--			end
--		end
--	end)
--end

function RepairNearbyUnits(mechanic)
    if (not mechanic.IsInWorld or mechanic.IsDead) then
        return false;
    end

    local nearbyRepairableActors = findNearbyActors(mechanic, function(self)
        if (not self.IsInWorld and not self.IsDead) then
            return false;
        end

        return Utils.Any(TankTypes, function(tankType)
            return self.Type == tankType;
        end)
    end);
    --Media.DisplayMessage("nearbyRepairableActors num! " .. #nearbyRepairableActors, "AI", HSLColor.Yellow);
    local heavilyDamagedActors = Utils.Where(nearbyRepairableActors, function(self)
        return self.Health < (self.MaxHealth / 2)
    end);

    if (#heavilyDamagedActors > 0) then
        --Media.DisplayMessage("Sendig mechanic to heavily damaged!", "AI", HSLColor.Yellow);
        mechanic.Guard(Utils.Random(heavilyDamagedActors));
    elseif (#nearbyRepairableActors > 0) then
        --Media.DisplayMessage("Sendig mechanic to random!", "AI", HSLColor.Yellow);
        mechanic.Guard(Utils.Random(nearbyRepairableActors));
    end
end

-- Give a special unit every 15 seconds after 5 minutes.
function GiveSpecialInfantry()
    Trigger.AfterDelay(DateTime.Seconds(15), function()
        ---@param Player player
        for _, player in ipairs(AIPlayers) do
            -- barracks
            local barracks = player.GetActorsByTypes({ "barr", "tent" });

            for _, barrack in ipairs(barracks) do

                if player.Cash > 100 then
                    local unitType = GetRandomInfantry();

                    local e1 = Actor.Create(unitType, true,
                            {
                                Owner = player,
                                Location = barrack.Location + CVec.New(0, 1)
                            }
                    );

                    if unitType ~= "thf" then
                        e1.AttackMove(barrack.RallyPoint);
                    else
                        e1.Move(barrack.RallyPoint);
                    end
                    player.Cash = player.Cash - 100;
                end
            end
        end
        GiveSpecialInfantry();
    end)
end

GetSpawnCloseToHomeLocation = function(player)
    return player.HomeLocation + CVec.New(
            Utils.RandomInteger(2, 6),
            Utils.RandomInteger(2, 6)
    )
end

GetNonCapturedOils = function(oils, player)
    Utils.Where(oils, function(oil)
        if (oil.IsInWorld and oil.Owner ~= player) then
            return true
        end
    end)
end

function WhereActorType(actors, type)
    return Utils.Where(actors, function(actor)
        return actor.Type == type
    end)
end

function DebugWPos(position)
    Media.DisplayMessage(
            "WORLD POS: " .. position.X .. ", " .. position.Y .. ", " .. position.Z,
            "AI",
            HSLColor.Green
    );
end

function DebugCPos(position)
    Media.DisplayMessage(
            "CELL POS: " .. position.X .. ", " .. position.Y,
            "AI",
            HSLColor.Green
    );
end

function IdleThrottle(actor, callback, wait)
    wait = wait or Utils.RandomInteger(
            0,
            DateTime.Seconds(4)
    )

    local functionToRepeat
    functionToRepeat = function()
        if (actor.IsDead) then
            return;
        end

        Trigger.OnIdle(actor, function(self)
            callback();

            Trigger.Clear(self, "OnIdle");

            Trigger.AfterDelay(wait, functionToRepeat);
        end);
    end

    functionToRepeat();
end

-- Unit Behaviours
function DemoTruckBehaviour(truck)
    Trigger.OnIdle(truck, function(self)
        local targets = GetTargets(truck.Owner);

        if #targets > 0 then
            self.AttackMove(
                    Utils.Random(targets).Location
            )
        end
    end)
end

function MechanicBehaviour(mechanic)
    local FindRepairables = function()
        return RepairNearbyUnits(mechanic)
    end

    --RepeatEvery(DateTime.Seconds(5), FindRepairables);
    IdleThrottle(mechanic, FindRepairables);
end

function EngineerBehaviour(engineer)
    local nearByOils = Map.ActorsInCircle(
            engineer.CenterPosition,
            WDist.FromCells(50),
            function(actor)
                return actor.Type == "oilb"
            end
    );

    for _, oil in ipairs(nearByOils) do
        engineer.Capture(oil);

        --Trigger.OnIdle(engineer, function(self)
        --	if (self.IsInWorld) then
        --		local _actors = Map.ActorsInCircle(self.CenterPosition, WDist.FromCells(5), function()
        --			return true;
        --		end);
        --		--Media.DisplayMessage("Actor around: " .. Utils.Random(_actors).Type, "AI", HSLColor.Red);
        --
        --		local nearOils = Utils.Where(_actors, function(_actor)
        --			return _actor.Type == "oilb";
        --		end);
        --
        --		if #nearOils > 0 then
        --			--Media.DisplayMessage("Oils around: " .. Utils.Random(nearOils).Type, "AI", HSLColor.Cyan);
        --
        --			local randomNearOil = Utils.Random(nearOils);
        --
        --			if (randomNearOil.Owner ~= player) then
        --				self.Capture(randomNearOil);
        --			end
        --		end
        --	end
        --	--Map.ActorsInCircle(engineer.CenterPosition, WDist.New(2048));
        --end)
    end

end

-- Initiators
function InitializeParabombsAndParatroopers()
    RepeatForEveryAI(DateTime.Seconds(180), function(player)
        local targets = GetTargets(player);

        if #targets > 0 then
            local target = Utils.Random(targets);
            local targetPos = target.CenterPosition;

            --Media.DisplayMessage(target.Owner.Name .. ' attacking -> ' .. player.Name, "AI", HSLColor.Red)

            local proxy = Actor.Create("powerproxy.parabombs", false, { Owner = player })
            proxy.TargetAirstrike(
                    targetPos,
                    Utils.Random(Angles)
            );
            proxy.Destroy()

            local paratroopers = Actor.Create("powerproxy.paratroopers", false, { Owner = player })

            local nearPosition = WPos.New(
                    targetPos.X + Utils.RandomInteger(2000, 6000),
                    targetPos.Y + Utils.RandomInteger(2000, 6000),
                    targetPos.Z
            );

            paratroopers.TargetParatroopers(
                    nearPosition,
                    Utils.Random(Angles)
            );
            paratroopers.Destroy()
        else
            local proxy = Actor.Create("powerproxy.paratroopers", false, { Owner = player })
            proxy.TargetParatroopers(
                    Map.CenterOfCell(Map.RandomCell()),
                    Utils.Random(Angles)
            );
            proxy.Destroy()
        end
    end)
end

function RepeatForEveryAI(dateTime, callback)
    RepeatEvery(dateTime, function()
        Utils.Do(AIPlayers, function(player)
            callback(player)
        end)
    end)
end

function GetBarracks(player)
    return player.GetActorsByTypes({ "barr", "tent" });
end

function GetWarFactories(player)
    return player.GetActorsByTypes({ "weap" });
end

function GetDeployedContructionYard(player)
    local mcvs = player.GetActorsByType("fact")

    if (#mcvs == 0) then
        return false
    end

    return mcvs[1];
end

function AfterWorldLoaded()
    -- Initial Engineer
    Utils.Do(AIPlayers, function(player)
        local engineer = Actor.Create(
                "E6", -- Engineer
                true,
                {
                    Owner = player,
                    Location = GetSpawnCloseToHomeLocation(player)
                }
        );
        engineer.GiveLevels(1, true);
        EngineerBehaviour(engineer);
    end)

    -- Give Initial MVCs for each AI to build faster and expand..
    Utils.Do(InitialMCVIntervals, function(mcvInterval)
        Trigger.AfterDelay(DateTime.Seconds(mcvInterval), function()
            Utils.Do(AIPlayers, function(player)
                GiveMCV(player);
            end)
        end)
    end)

    -- Repeated Actions
    RepeatForEveryAI(
            DateTime.Seconds(5),
            function(player)
                if player.Cash < 5000 then
                    player.Cash = player.Cash + 2500;
                end
            end
    )

    -- Riflers
    RepeatForEveryAI(
            DateTime.Seconds(8),
            function(player)
                local spawns = GetBarracks(player);
                local hasNoProperSpawns = IsEmpty(spawns);

                if (hasNoProperSpawns) then
                    --Media.DisplayMessage("No spawns", "AI", HSLColor.Yellow);

                    spawns = {
                        {
                            Location = player.HomeLocation + CVec.New(
								Utils.RandomInteger(2, 6),
								Utils.RandomInteger(2, 6)
                            )
                        }
                    }
                end

                Utils.Do(spawns, function(spawn)
                    if player.Cash < 50 then
                        return;
                    end
                    --Media.DisplayMessage("Mines: " .. compileTable(Mines), "AI", HSLColor.Yellow);

                    local actor = Actor.Create(
                            "e1ai",
                            true,
                            {
                                Owner = player,
                                Location = spawn.Location
                            }
                    );

                    actor.GiveLevels(1, true);

                    actor.AttackMove(Utils.Random(Mines).Location);

                    player.Cash = player.Cash - 50;
                end)
            end
    )

    RepeatForEveryAI(
            DateTime.Seconds(10),
            function(player)
                Utils.Do(GetBarracks(player), function(barrack)
                    if player.Cash < 100 then
                        return
                    end

                    player.Cash = player.Cash - 100;

                    barrack.Produce("e3");
                end)
            end
    )

    -- mechs
    RepeatForEveryAI(
            DateTime.Seconds(15),
            function(player)
                Utils.Do(GetBarracks(player), function(barrack)
                    if player.Cash < 100 then
                        return
                    end

                    player.Cash = player.Cash - 100;

                    barrack.Produce("mech");
                end)
            end
    )

    RepeatForEveryAI(
            DateTime.Seconds(5),
            function(player)
                Utils.Do(GetWarFactories(player), function(warfactory)
                    if player.Cash < 400 then
                        return
                    end

                    warfactory.Produce(GetRandomTank())

                    player.Cash = player.Cash - 400;
                end)
            end
    )

    Trigger.OnAnyProduction(function(producer, actor)
        if actor.Type == "dtrk" then
            actor.Move(Map.RandomEdgeCell());
            DemoTruckBehaviour(actor);
        elseif actor.Type == "mech" then
            MechanicBehaviour(actor);
        elseif (actor.HasProperty("FindResources")) then
            actor.FindResources();
        elseif (actor.HasProperty("AttackMove")) then
            actor.AttackMove(producer.RallyPoint);
        else
            actor.Move(producer.RallyPoint);
        end
    end)

    RepeatForEveryAI(
            DateTime.Seconds(30),
            function(player)
                -- Give MCV to AIs
                if (#player.GetActorsByType("fact") < 15) then
                    GiveMCV(player)
                end

                -- Give Harvesters to AIs
                if player.Cash < 1000 and #player.GetActorsByType("harv") < 15 then
                    --Media.DisplayMessage("Give harvester!", "AI", HSLColor.Red)
                    GiveHarvester(player);
                end
            end
    )

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        Utils.Do(AIPlayers, function(player)
            --local mcv = GetDeployedContructionYard(player);
            --
            --if (not mcv) then
            --	Media.DisplayMessage("NO MCV!", "AI", HSLColor.Red)
            --	return;
            --end
            --
            --mcv.Build({ "powr", "Produce" })

        end)
    end)


    -- Parabombs and Paratroopers
    InitializeParabombsAndParatroopers();

    -- Waves
    --Trigger.AfterDelay(DateTime.Minutes(1), function()
    --    for _, player in ipairs(AIPlayers) do
    --        GiveMassInfantry(player, 60);
    --        -- TODO: grenadier
    --        GiveMassInfantry(player, 10);
    --    end
    --end)
    --
    --Trigger.AfterDelay(DateTime.Minutes(2), function()
    --    for _, player in ipairs(AIPlayers) do
    --        GiveMassInfantry(player, 60);
    --    end
    --end)
    --
    --Trigger.AfterDelay(DateTime.Minutes(3), function()
    --    for _, player in ipairs(AIPlayers) do
    --        GiveMassInfantry(player, 60);
    --        -- rockets
    --        GiveMassInfantry(player, 10);
    --    end
    --end)
    --
    --Trigger.AfterDelay(DateTime.Minutes(3), function()
    --    for _, player in ipairs(AIPlayers) do
    --        GiveMassInfantry(player, 60);
    --        GiveMassInfantry(player, 10);
    --
    --        Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    --        Media.DisplayMessage("Just enabled a cheat to mass produce infantry OMG!", "AI", HSLColor.Red)
    --        GiveSpecialInfantry();
    --    end
    --end)
    --
    --Trigger.AfterDelay(DateTime.Minutes(5), function()
    --    for _, player in ipairs(AIPlayers) do
    --        GiveMassInfantry(player, 120);
    --        GiveMassInfantry(player, 30, "e3");
    --
    --        -- TODO
    --        Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    --        Media.DisplayMessage("Just enabled a cheat to mass produce tanks OMG!", "AI", HSLColor.Red)
    --        GiveMassOfUnit(player, "2tnk", 20);
    --    end
    --end)
    --
    --Trigger.AfterDelay(DateTime.Minutes(7), function()
    --    for _, player in ipairs(AIPlayers) do
    --        GiveMassInfantry(player, 60);
    --
    --        -- TODO: rockets
    --        GiveMassInfantry(player, 60);
    --
    --
    --        GiveMassOfUnit(player, "2tnk", 20)
    --    end
    --end)

    sendFunMessages();

    --Media.DisplayMessage("DEV MODE 2", "AI", HSLColor.Red);
    --Media.DisplayMessage("DEV MODE:" .. Utils.Random(TankTypes), "AI", HSLColor.Red);
end

function WorldLoaded()
    Neutral = Player.GetPlayer("Neutral");
    Creeps = Player.GetPlayer("Creeps");

    -- Initialize AI & Human Players
    AllPlayers = GetAllPlayers();

    ---@param Player[] AIPlayers
    AIPlayers = GetBots();
    HumanPlayers = GetHumans();

    Mines = Utils.Where(Map.NamedActors, function(actor)
        return actor.Type == "mine" or actor.Type == "gmine";
    end);

    OreMines = Utils.Where(Mines, function(actor)
        return actor.Type == "mine";
    end);

    GemMines = Utils.Where(Mines, function(actor)
        return actor.Type == "gmine";
    end);

    Oils = Utils.Where(Map.NamedActors, function(actor)
        return actor.Type == "oilb"
    end);

    Trigger.AfterDelay(0, AfterWorldLoaded);
end
