-- Copyright Azarus @ 2022

-- TODO
-- Avoid multiple initial radars
-- make sure war factory is done soon
-- assign mines to a player to know if should be targeted
-- mcv deploy closer to mines or something better than now
-- harvester mine ratio
-- repair zone with mechs
-- ic
-- message with the color of the AI
-- parabombs
	-- preferred targets
		-- defenses
		-- tech buildings
		-- units close to edges
-- stop sending soldiers to mines at some point

function AfterWorldLoaded()

	--ExternalCondition@AIbuilder:
	--Condition: enable-hardcore-ai
	--Trigger.AfterDelay(DateTime.Seconds(10), function()
	--	Utils.Do(AIPlayers, function(player)
	--		player.GrantCondition('enable-hardcore-ai-builder-module')
	--		--ConditionRevokers["Build-" .. player.ID] =
	--		Media.DisplayMessage('Enabling Building')
	--	end)
	--end);
	--
	--Trigger.AfterDelay(DateTime.Seconds(3), function()
	--	Utils.Do(AIPlayers, function(player)
	--		Media.DisplayMessage('Buil... ' .. player.Faction)
	--
	--		--local conyard = GetMainMCV(player);
	--		Utils.Do(BuildOrders[1], function(building)
	--
	--			Media.DisplayMessage('Building... ' .. building)
	--
	--			player.Build({ building });
	--		end)
	--	end)
	--end);



	-- Repair Station
	--CreateRepairStation();
	--
	--Trigger.AfterDelay(0, function()
	--	Utils.Do(AIPlayers, function(player)
	--		GetNearestServiceDepot(player.GetActors()[2])
	--	end)
	--end)

	RepeatEvery(DateTime.Minutes(7), function()
		--Media.DisplayMessage("Kamikaze squad sent! ", "AI", HSLColor.Yellow);

		KamikazeAttack(AIPlayers[1], AIPlayers[2].GetActorsByType("fact")[1])
	end)

	RepeatEvery(DateTime.Seconds(30), function()
		setMineOwners(OwnedMines)
	end)

	-- Initial Engineer
	Utils.Do(AIPlayers, function(player)
		local engineer = Actor.Create(
			"E6", -- Engineer
			true,
			{
				Owner = player,
				Location = GetSpawnCloseToHomeLocation(player)
			}
		);
		engineer.GiveLevels(1, true);
		EngineerBehaviour(engineer);
	end)

	-- Give Initial MVCs for each AI to build faster and expand..
	Utils.Do(InitialMCVIntervals, function(mcvInterval)
		Trigger.AfterDelay(DateTime.Seconds(mcvInterval), function()
			Utils.Do(AIPlayers, function(player)
				GiveMCV(player);
			end)
		end)
	end)

	-- Repeated Actions
	RepeatForEveryAI(
		DateTime.Seconds(5),
		function(player)
			if player.Cash < 5000 then
				player.Cash = player.Cash + 2500;
			end
		end
	)

	-- Riflers
	RepeatForEveryAI(
		DateTime.Seconds(6),
		function(player)
			local spawns = GetBarracks(player);
			local hasNoProperSpawns = IsEmpty(spawns);

			if (hasNoProperSpawns) then
				--Media.DisplayMessage("No spawns", "AI", HSLColor.Yellow);

				spawns = {
					{
						Location = player.HomeLocation + CVec.New(
								Utils.RandomInteger(2, 6),
								Utils.RandomInteger(2, 6)
						)
					}
				}
			end

			Utils.Do(spawns, function(spawn)
				if player.Cash < 50 then
					return;
				end
				--Media.DisplayMessage("Mines: " .. compileTable(Mines), "AI", HSLColor.Yellow);

				local actor = Actor.Create(
					"e1ai",
					true,
					{
						Owner = player,
						Location = spawn.Location
					}
				);

				actor.GiveLevels(1, true);

				actor.AttackMove(Utils.Random(Mines).Location);

				player.Cash = player.Cash - 50;
			end)
		end
	)

	RepeatForEveryAI(
		DateTime.Seconds(8),
		function(player)
			Utils.Do(GetBarracks(player), function(barrack)
				if player.Cash < 100 then
					return
				end

				player.Cash = player.Cash - 100;

				barrack.Produce("e3");
			end)
		end
	)

	-- mechs
	RepeatForEveryAI(
		DateTime.Seconds(12),
		function(player)
			Utils.Do(GetBarracks(player), function(barrack)
				if player.Cash < 100 then
					return
				end

				player.Cash = player.Cash - 100;

				barrack.Produce("mech");
			end)
		end
	)

	RepeatForEveryAI(
		DateTime.Seconds(4),
		function(player)
			Utils.Do(GetWarFactories(player), function(warfactory)
				if player.Cash < 400 then
					return
				end

				warfactory.Produce(GetRandomTank())

				player.Cash = player.Cash - 400;
			end)
		end
	)

	Trigger.OnAnyProduction(function(producer, actor)
		if actor.Type == "dtrk" then
			actor.Move(Map.RandomEdgeCell());
			DemoTruckBehaviour(actor);
		elseif actor.Type == "mech" then
			MechanicBehaviour(actor);
		elseif (actor.HasProperty("FindResources")) then
			actor.FindResources();
		elseif (actor.HasProperty("AttackMove")) then
			actor.AttackMove(producer.RallyPoint);
		else
			actor.Move(producer.RallyPoint);
		end

		--local isTankType = Utils.Any(TankTypes, function(tankType)
		--	return actor.Type == tankType;
		--end)
		--
		--if (isTankType) then
		--	VehicleBehaviour(actor)
		--end
	end)

	RepeatForEveryAI(
		DateTime.Seconds(25),
		function(player)
			-- Give MCV to AIs
			if (#player.GetActorsByType("fact") < 15) then
				GiveMCV(player)
			end

			local refineries = #player.GetActorsByType("proc");
			local harvesters = #player.GetActorsByType("harv");

			local maxPermittedHarvesters = refineries * 3;

			-- Give Harvesters to AIs
			if player.Cash < 1000 and harvesters < maxPermittedHarvesters then
				--Media.DisplayMessage("Give harvester!", "AI", HSLColor.Red)
				GiveHarvester(player);
			end
		end
	)


	-- Parabombs and Paratroopers
	InitializeParabombsAndParatroopers();

	-- Waves
	--Trigger.AfterDelay(DateTime.Minutes(1), function()
	--    for _, player in ipairs(AIPlayers) do
	--        GiveMassInfantry(player, 60);
	--        -- TODO: grenadier
	--        GiveMassInfantry(player, 10);
	--    end
	--end)
	--
	--Trigger.AfterDelay(DateTime.Minutes(2), function()
	--    for _, player in ipairs(AIPlayers) do
	--        GiveMassInfantry(player, 60);
	--    end
	--end)
	--
	--Trigger.AfterDelay(DateTime.Minutes(3), function()
	--    for _, player in ipairs(AIPlayers) do
	--        GiveMassInfantry(player, 60);
	--        -- rockets
	--        GiveMassInfantry(player, 10);
	--    end
	--end)
	--
	--Trigger.AfterDelay(DateTime.Minutes(3), function()
	--    for _, player in ipairs(AIPlayers) do
	--        GiveMassInfantry(player, 60);
	--        GiveMassInfantry(player, 10);
	--
	--        Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
	--        Media.DisplayMessage("Just enabled a cheat to mass produce infantry OMG!", "AI", HSLColor.Red)
	--        GiveSpecialInfantry();
	--    end
	--end)
	--
	--Trigger.AfterDelay(DateTime.Minutes(5), function()
	--    for _, player in ipairs(AIPlayers) do
	--        GiveMassInfantry(player, 120);
	--        GiveMassInfantry(player, 30, "e3");
	--
	--        -- TODO
	--        Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
	--        Media.DisplayMessage("Just enabled a cheat to mass produce tanks OMG!", "AI", HSLColor.Red)
	--        GiveMassOfUnit(player, "2tnk", 20);
	--    end
	--end)
	--
	--Trigger.AfterDelay(DateTime.Minutes(7), function()
	--    for _, player in ipairs(AIPlayers) do
	--        GiveMassInfantry(player, 60);
	--
	--        -- TODO: rockets
	--        GiveMassInfantry(player, 60);
	--
	--
	--        GiveMassOfUnit(player, "2tnk", 20)
	--    end
	--end)

	sendFunMessages();

	--Media.DisplayMessage("DEV MODE 2", "AI", HSLColor.Red);
	--Media.DisplayMessage("DEV MODE:" .. Utils.Random(TankTypes), "AI", HSLColor.Red);
end

function WorldLoaded()
	Neutral = Player.GetPlayer("Neutral");
	Creeps = Player.GetPlayer("Creeps");

	-- Initialize AI & Human Players
	AllPlayers = GetAllPlayers();

	---@param Player[] AIPlayers
	AIPlayers = GetBots();
	HumanPlayers = GetHumans();

	Mines = Utils.Where(Map.NamedActors, function(actor)
		return actor.Type == "mine" or actor.Type == "gmine";
	end);

	OwnedMines = {};
	Utils.Do(Mines, function(mine)
		table.insert(OwnedMines, {
			Location = mine.Location,
			ControlledBy = nil,
		})
	end)

	OreMines = Utils.Where(Mines, function(actor)
		return actor.Type == "mine";
	end);

	GemMines = Utils.Where(Mines, function(actor)
		return actor.Type == "gmine";
	end);

	Oils = Utils.Where(Map.NamedActors, function(actor)
		return actor.Type == "oilb"
	end);

	Trigger.AfterDelay(0, AfterWorldLoaded);
end
