-- Descendant
--table.sort(t, function(a, b) return a > b end)

-- Ascendant
--table.sort(t)

-- AI Fun Sequence. Scare the players.
function sendFunMessages()
    --UserInterface.SetMissionText('I will kill you.');

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        Media.PlaySoundNotification(USSR, "AlertBuzzer")
    end)

    Trigger.AfterDelay(DateTime.Seconds(3), function()
        Media.PlaySoundNotification(USSR, "AlertBuzzer")
    end)

    Trigger.AfterDelay(DateTime.Seconds(5), function()
        Media.PlaySoundNotification(USSR, "AlertBuzzer")
    end)

    Trigger.AfterDelay(DateTime.Seconds(4), function()
        for _, player in ipairs(AIPlayers) do
            Media.DisplayMessage(player.Name .. " just awakened!", "", player.Color)
        end

        -- Does not work
        --Lighting.Flash("LightningStrike", Utils.RandomInteger(1, 10));
    end)

    Trigger.AfterDelay(DateTime.Seconds(6), function()
        Media.PlaySpeechNotification(USSR, "TargetFreed")
    end)

    Trigger.AfterDelay(DateTime.Seconds(11), function()
        Media.PlaySpeechNotification(USSR, "EnemyDetected")
    end)

    Trigger.AfterDelay(DateTime.Seconds(15), function()
        for _, humanPlayer in ipairs(HumanPlayers) do
            for _, player in ipairs(AIPlayers) do
                Radar.Ping(humanPlayer, Map.CenterOfCell(player.HomeLocation), HSLColor.Red, 500)
                Beacon.New(humanPlayer, Map.CenterOfCell(player.HomeLocation), 500)
            end
        end

        Media.PlaySoundNotification(USSR, "Beacon");
    end)

    Trigger.AfterDelay(DateTime.Seconds(20), function()
        Media.PlaySoundNotification(USSR, "BaseSetup")
    end)

    -- Taunts

    Trigger.AfterDelay(DateTime.Seconds(15), function()
        Utils.Do(AIPlayers, function(player)
            Media.DisplayMessage(
                Utils.Random(InitialTaunts),
                player.Name,
                player.Color
            )
        end)
    end)

    Utils.Do(AIPlayers, function(player)
        RepeatEvery(
            DateTime.Minutes(
                Utils.RandomInteger(3, 10)
            ),
            function()
                Media.DisplayMessage(
                    Utils.Random(Taunts),
                    player.Name,
                    player.Color
                );
            end
        )
    end)
end



--------------
-- Givers
--------------
function GiveMCV(player)
    Actor.Create(
            "mcv",
            true,
            {
                Owner = player,
                Location = player.HomeLocation + CVec.New(0, 1)
            }
    );
end

function GiveHarvester(player)
    Actor.Create(
            "harv",
            true,
            {
                Owner = player,
                Location = player.HomeLocation + CVec.New(0, 1)
            }
    );
end

function GiveMassInfantry(player, amount, unitType)
    if unitType == nil then
        unitType = "e1"
    end

    GiveMassOfUnit(
            player,
            unitType,
            amount,
            function(unit)
                --unit.AttackMove(barrack.RallyPoint);
            end
    )
end

function GiveMassOfUnit(player, unitType, amount, callback)
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("Just enabled a cheat to mass produce " .. unitType .. " OMG!", "AI", HSLColor.Red)

    local unitCount = amount;
    while unitCount > 0 do
        local unit = Actor.Create(
                unitType,
                true,
                {
                    Owner = player,
                    Location = player.HomeLocation + CVec.New(0, 1)
                }
        );

        if (callback) then
            callback(unit);
        end

        unitCount = unitCount - 1;

        if (unitCount <= 0) then
            return ;
        end
    end
end

function GiveSpecialInfantry()
    Trigger.AfterDelay(DateTime.Seconds(15), function()
        ---@param Player player
        for _, player in ipairs(AIPlayers) do
            -- barracks
            local barracks = player.GetActorsByTypes({ "barr", "tent" });

            for _, barrack in ipairs(barracks) do

                if player.Cash > 100 then
                    local unitType = GetRandomInfantry();

                    local e1 = Actor.Create(unitType, true,
                            {
                                Owner = player,
                                Location = barrack.Location + CVec.New(0, 1)
                            }
                    );

                    if unitType ~= "thf" then
                        e1.AttackMove(barrack.RallyPoint);
                    else
                        e1.Move(barrack.RallyPoint);
                    end
                    player.Cash = player.Cash - 100;
                end
            end
        end
        GiveSpecialInfantry();
    end)
end



--------------
-- Getters
--------------

function findNearbyActors(actor, filter, distanceInCells)
    distanceInCells = distanceInCells or 5
    filter = filter or function(self)
        return self.IsInWorld;
    end

    return Map.ActorsInCircle(actor.CenterPosition, WDist.FromCells(distanceInCells), filter)
end

-- After this, if you need, make sure that the desired unit can target the target :D -> unit.CanTarget(target)
function GetTargets(player, enemyPlayer)
    enemyPlayer = enemyPlayer or GetRandomEnemy(player);

    return Utils.Where(
        enemyPlayer.GetActors(),
        function(self)
            return self.HasProperty("Health")
                and not Utils.Any(
                { "sbag", "fenc", "brik", "cycl", "barb" },
                function(type)
                    return self.Type == type
                end)
        end
    )
end

function GetRandomTargetForPlayer(player)
    local targets = GetTargets(player)

    if #targets > 0 then
        target = Utils.Random(enemies)
    end

    return target
end

function GetNearestServiceDepot(actor)
    local filter = function(self)
        if (not self.IsInWorld and not self.IsDead) then
            return false;
        end

        return actor.Owner == self.Owner and self.Type == "fix"
    end

    local nearestServiceDepots = findNearbyActors(actor, filter, 20);

    if (#nearestServiceDepots > 0) then
        return nearestServiceDepots[1];
    end

    local serviceDepots = actor.Owner.GetActorsByType("fix");

    if (#serviceDepots > 0) then
        return Utils.Random(serviceDepots)
    end

    return false;
end

function GetMCVs(player)
    return player.GetActorsByTypes({ "fact" });
end

function GetMainMCV(player)
    local mcvs = GetMCVs(player);

    if (#mcvs == 0) then
        return false;
    end

    return mcvs[1];
end

function GetBarracks(player)
    return player.GetActorsByTypes({ "barr", "tent" });
end

function GetWarFactories(player)
    return player.GetActorsByTypes({ "weap" });
end

function GetSpawnCloseToHomeLocation(player)
    return player.HomeLocation + CVec.New(
            Utils.RandomInteger(2, 6),
            Utils.RandomInteger(2, 6)
    )
end

function GetNonCapturedOils(oils, player)
    Utils.Where(oils, function(oil)
        if (oil.IsInWorld and oil.Owner ~= player) then
            return true
        end
    end)
end

function GetItemByIndex(array, index)
    for i, k in ipairs(array) do
        if i == index then
            return k;
        end
    end

    return "invalid_index";
end

function GetRandomTank()
    return Utils.Random(TankTypes);
end

function GetRandomInfantry()
    return Utils.Random(InfantryTypes);
end

function GetBots()
    return Player.GetPlayers(function(player)
        return player.IsBot == true;
    end);
end

function GetHumans()
    return Player.GetPlayers(function(player)
        return player.IsBot == false and player.IsNonCombatant == false;
    end);
end

function GetEnemies(currentPlayer)
    return Player.GetPlayers(function(player)
        if (player.IsNonCombatant == true) then
            return false;
        end

        if (IsSamePlayer(currentPlayer, player)) then
            return false;
        end

        if (currentPlayer.Team == 0) then
            return true;
        end

        return player.Team ~= currentPlayer.Team;
    end);
end

function GetRandomEnemy(player)
    local enemies = GetEnemies(player);

    if (IsEmpty(enemies)) then
        return;
    end

    return Utils.Random(enemies);
end

function GetAllPlayers()
    return Player.GetPlayers(function(player)
        return player.IsNonCombatant == false;
    end);
end



--------------
-- Utils
--------------
function GetTechTypeForPlayer(player)
    return TechTypesByFaction[player.Faction]
end

function GetBarrackTypeForPlayer(player)
    local tech = GetTechTypeForPlayer(player)

    if (tech == "soviet") then
        return "barr";
    else
        return "tent";
    end
end

function DebugWPos(position)
    --Media.DisplayMessage(
    --        "WORLD POS: " .. position.X .. ", " .. position.Y .. ", " .. position.Z,
    --        "AI",
    --        HSLColor.Green
    --);
end

function DebugCPos(position)
    --Media.DisplayMessage(
    --        "CELL POS: " .. position.X .. ", " .. position.Y,
    --        "AI",
    --        HSLColor.Green
    --);
end

function OnDamageThrottle(actor, callback, wait)
    Throttle("OnDamaged", actor, callback, wait);
end

function OnIdleThrottle(actor, callback, wait)
    Throttle("OnIdle", actor, callback, wait);
end

function Throttle(triggerName, actor, callback, wait)
    wait = wait or Utils.RandomInteger(
            0,
            DateTime.Seconds(4)
    )

    local functionToRepeat
    functionToRepeat = function()
        if (actor.IsDead) then
            return;
        end

        Trigger[triggerName](actor, function(self)
            callback(self);

            Trigger.Clear(self, triggerName);

            Trigger.AfterDelay(wait, functionToRepeat);
        end);
    end

    functionToRepeat();
end

function Once(triggerName, actor, callback)
    Trigger[triggerName](actor, function(self)
        Trigger.Clear(self, triggerName);

        callback(self);
    end)
end

function CompileTable(table)
    local index = 1
    local holder = "{"
    while true do
        if type(table[index]) == "function" then
            index = index + 1
        elseif type(table[index]) == "table" then
            holder = holder .. compileTable(table[index])
        elseif type(table[index]) == "number" then
            holder = holder .. tostring(table[index])
        elseif type(table[index]) == "string" then
            holder = holder .. "\"" .. table[index] .. "\""
        elseif table[index] == nil then
            holder = holder .. "nil"
        elseif type(table[index]) == "boolean" then
            holder = holder .. (table[index] and "true" or "false")
        end
        if index + 1 > #table then
            break
        end
        holder = holder .. ","
        index = index + 1
    end
    return holder .. "}"
end

-- Return false within callback to cancel repetition
function RepeatEvery(dateTime, callback)
    local functionToRepeat

    functionToRepeat = function()
        Trigger.AfterDelay(
            dateTime,
            function()
                local result = callback();

                if (result == false) then
                    --Media.DisplayMessage("Cancelled repeat", "AI", HSLColor.Red)
                else
                    --Media.DisplayMessage("Repeating action", "AI", HSLColor.Black)
                    functionToRepeat();
                end
            end
        );
    end

    functionToRepeat();
end

function RepeatForEveryAI(dateTime, callback)
    RepeatEvery(dateTime, function()
        Utils.Do(AIPlayers, function(player)
            callback(player)
        end)
    end)
end

function IsEmpty(table)
    return next(table) == nil
end

function IsSamePlayer(playerA, playerB)
    return playerA.Spawn == playerB.Spawn;
end

function WhereActorType(actors, type)
    return Utils.Where(actors, function(actor)
        return actor.Type == type
    end)
end



--------------
-- Specials
--------------
function InitializeParabombsAndParatroopers()
    RepeatForEveryAI(DateTime.Minutes(4), function(player)
        local targets = GetTargets(player);

        if #targets > 0 then
            local target = Utils.Random(targets);
            local targetPos = target.CenterPosition;

            --Media.DisplayMessage(target.Owner.Name .. ' attacking -> ' .. player.Name, "AI", HSLColor.Red)

            local proxy = Actor.Create("powerproxy.parabombs", false, { Owner = player })
            proxy.TargetAirstrike(
                targetPos,
                Utils.Random(Angles)
            );
            proxy.Destroy()

            local paratroopers = Actor.Create("powerproxy.paratroopers", false, { Owner = player })

            local nearPosition = WPos.New(
                    targetPos.X + Utils.RandomInteger(2000, 6000),
                    targetPos.Y + Utils.RandomInteger(2000, 6000),
                    targetPos.Z
            );

            paratroopers.TargetParatroopers(
                    nearPosition,
                    Utils.Random(Angles)
            );
            paratroopers.Destroy()
        else
            local proxy = Actor.Create("powerproxy.paratroopers", false, { Owner = player })
            proxy.TargetParatroopers(
                    Map.CenterOfCell(Map.RandomCell()),
                    Utils.Random(Angles)
            );
            proxy.Destroy()
        end
    end)
end

-- mechanics leave the place at some point making the station useless
-- apart from that, the other units refuse to come to the station because of squadbotai
function CreateRepairStation()
    Utils.Do(AIPlayers, function(player)
        local wallGroups = {
            -- X, Y
            {
                { -6, -6, "boxes0" .. Utils.RandomInteger(1, 9) },
                { -6, -5, "MECHSTATICAI" },
                { -5, -6, "boxes0" .. Utils.RandomInteger(1, 9) }
            },
            {
                { -3, -6, "MECHSTATICAI" },
                { -2, -6, "boxes0" .. Utils.RandomInteger(1, 9) },
                { -2, -5, "boxes0" .. Utils.RandomInteger(1, 9) }
            },
            {
                { -6, -2, "boxes0" .. Utils.RandomInteger(1, 9) },
                { -6, -3, "boxes0" .. Utils.RandomInteger(1, 9) },
                { -5, -2, "MECHSTATICAI" }
            },
            {
                { -2, -2, "boxes0" .. Utils.RandomInteger(1, 9) },
                { -2, -3, "MECHSTATICAI" },
                { -3, -2, "boxes0" .. Utils.RandomInteger(1, 9) }
            }

        }

        Utils.Do(wallGroups, function(wallGroup)
            Utils.Do(wallGroup, function(wall)
                local actor = Actor.Create(wall[3], true, {
                    Owner = player,
                    Location = player.HomeLocation + CVec.New(
                            wall[1], wall[2]
                    )
                });

                if (actor.Type == "MECHSTATICAI") then
                    actor.GiveLevels(1, true);
                end
                --local mech = Actor.Create("MECHSTATICAI", true, {
                --	Owner = player,
                --	Location = player.HomeLocation + CVec.New(
                --		wall[1], wall[2]
                --	),
                --})
                --
                --mech.Stop();
            end)
        end)

        Actor.Create("CTFLAG", true, {
            Owner = player,
            Location = player.HomeLocation + CVec.New(
                    -6, -6
            ),
        })

        Actor.Create("fix", true, {
            Owner = player,
            Location = player.HomeLocation + CVec.New(
                    -5, -5
            ),
        })

    end);
end

function KamikazeAttack(fromPlayer, target)
    Utils.Do({ 1, 2, 3, 4 }, function()
        local yak = Actor.Create(
                "yak",
                true,
                {
                    Owner = fromPlayer,
                    Location = GetSpawnCloseToHomeLocation(fromPlayer)
                }
        );

        yak.Attack(target);

        Trigger.OnEnteredProximityTrigger(
                target.CenterPosition,
                WDist.FromCells(5),
                function(actor)
                    if (actor.Type == "yak" and actor.Owner == fromPlayer) then
                        actor.Kill();
                    end
                end)

    end)
end

-- Evaluates who is controlling an ore mine
function setMineOwners(mines)
    --Utils.Do(mines, function(mine)
    --    local filter = function(self)
    --        if (not self.IsInWorld or self.IsDead) then
    --            return false;
    --        end
    --
    --        return self.Type == "harv";
    --    end
    --
    --    local actors = Map.ActorsInCircle(
    --            Map.CenterOfCell(mine.Location),
    --            WDist.FromCells(10),
    --            filter
    --    )
    --
    --    if (#actors == 0) then
    --        mine["ControlledBy"] = nil
    --    else
    --        local owners = {}
    --        local ownersCount = {}
    --        local mostHarvestersOwner = nil
    --
    --        Utils.Do(actors, function(actor)
    --            owners[actor.Owner.Spawn] = actor.Owner;
    --            ownersCount[actor.Owner.Spawn] = (ownersCount[actor.Owner.Spawn] or 0) + 1;
    --        end);
    --
    --        for ownerSpawn, value in pairs(owners) do
    --            -- TODO: Fix "attempt to compare number with userdata"
    --            if (not mostHarvestersOwner or value > ownersCount[mostHarvestersOwner.Spawn]) then
    --                mostHarvestersOwner = owners[ownerSpawn]
    --            end
    --        end
    --
    --        mine["ControlledBy"] = mostHarvestersOwner;
    --    end
    --end)
end
