CorrinoEntryPath = { CorrinoStarportPoint1.Location, CorrinoStarportPoint2.Location, CorrinoStarportPoint3.Location }

CorrinoStarportReinforcements =
{
	easy = { "trooper", "trooper", "trooper", "trooper", "trooper", "quad", "quad", "trike", "trike", "missile_tank", "missile_tank" },
	normal = { "trooper", "trooper", "trooper", "trooper", "trooper", "quad", "quad", "trike", "trike", "missile_tank", "missile_tank" },
	hard = { "trooper", "trooper", "trooper", "trooper", "trooper", "quad", "quad", "quad", "trike", "trike", "trike", "missile_tank", "missile_tank" }
}

CorrinoStarportDelay =
{
	easy = DateTime.Minutes(4),
	normal = DateTime.Minutes(3) + DateTime.Seconds(30),
	hard = DateTime.Minutes(3)
}

SendStarportReinforcements = function()
	Trigger.AfterDelay(CorrinoStarportDelay[Difficulty], function()
		if CStarport.IsDead or CStarport.Owner ~= Multi4 then
			return
		end

		local units = Reinforcements.ReinforceWithTransport(Multi4, "frigate", CorrinoStarportReinforcements[Difficulty], { CorrinoStarportEntry.Location, CStarport.Location + CVec.New(1, 1) }, { CorrinoStarportExit.Location })[2]
		Reinforcements.Reinforce(Multi4, CorrinoStarportReinforcements[Difficulty], CorrinoEntryPath)
		
		SendStarportReinforcements()
		
		Media.DisplayMessage("Внимание! На горизонте обнаружены императорские корабли!", "Ментат")
	end)
end

Tick = function()
	if Multi0.HasNoRequiredUnits() or Multi1.HasNoRequiredUnits() then
		Multi2.MarkCompletedObjective(KillAlied)
		Multi3.MarkCompletedObjective(KillAlied2)
		Multi4.MarkCompletedObjective(KillAlied3)
		Multi0.MarkFailedObjective(KillAlied)
		Multi1.MarkFailedObjective(KillAlied)
	end
	if Multi2.HasNoRequiredUnits() and  Multi3.HasNoRequiredUnits() and not Multi0.IsObjectiveCompleted(KillOrdos) and not Multi1.IsObjectiveCompleted(KillOrdos2) then
		Media.DisplayMessage("Ордосы уничтожены!", "Ментат")
		Multi0.MarkCompletedObjective(KillOrdos)
		Multi1.MarkCompletedObjective(KillOrdos2)
	end
	if Multi4.HasNoRequiredUnits() and not Multi0.IsObjectiveCompleted(KillCorrino) and not Multi1.IsObjectiveCompleted(KillCorrino2) then
		Media.DisplayMessage("Император уничтожен!", "Ментат")
		Multi0.MarkCompletedObjective(KillCorrino)
		Multi1.MarkCompletedObjective(KillCorrino2)
	end
	if Multi0.IsObjectiveCompleted(KillOrdos) and Multi0.IsObjectiveCompleted(KillCorrino) and not Multi0.IsObjectiveCompleted(GuardOutpost) then
		Multi0.MarkCompletedObjective(GuardOutpost)
		Multi1.MarkCompletedObjective(GuardOutpost2)
	end
	if (HOutpost.IsDead or HOutpost.Owner ~= Multi0) then
		Multi0.MarkFailedObjective(GuardOutpost)
		Multi1.MarkFailedObjective(GuardOutpost2)
	end
end

WorldLoaded = function()
    Multi0 = Player.GetPlayer("Multi0")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")

	InitObjectives(Multi0)
	KillOrdos = Multi0.AddPrimaryObjective("Уничтожьте Ордосов.")
	KillOrdos2 = Multi1.AddPrimaryObjective("Уничтожьте Ордосов.")
	KillCorrino	= Multi0.AddPrimaryObjective("Уничтожьте Императора.")
	KillCorrino2 = Multi1.AddPrimaryObjective("Уничтожьте Императора.")
	GuardOutpost = Multi0.AddSecondaryObjective("Защитите Пост")
	GuardOutpost2 = Multi1.AddSecondaryObjective("Защитите Пост")
	KillAlied = Multi2.AddPrimaryObjective("Уничтожьте Дом1")
	KillAlied2 = Multi3.AddPrimaryObjective("Уничтожьте Дом1")
	KillAlied3 = Multi4.AddPrimaryObjective("Уничтожьте Дом1")
	
	InitObjectives(Multi1)
	
	HOutpost.GrantCondition("modified")

	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("Защищайте пост от аттак!", "Ментат")
	end)
	
	SendStarportReinforcements()

end
