-- Copyright Azarus @ 2022
TankTypes = { "v2rl", "1tnk", "2tnk", "3tnk", "4tnk", "arty", "harv", "jeep", "apc", "mnly", "2tnk", "mgg", "mrj", "ttnk",
    "ftrk", "dtrk", "ctnk", "dtrk", "stnk" }
TankSequence = { 15, 7, 1, 4, 18, 14, 17, 11, 11, 12, 8, 13, 6, 3, 16, 9, 5, 1, 2, 5, 7, 16, 14, 4, 6, 15, 9, 8, 2, 11, 3,
    13, 17, 11, 18, 1, 12, 1, 11, 1, 6, 9, 12, 18, 5, 8, 3, 14, 15, 1, 16, 11, 13, 4, 7, 2, 17, 13, 7, 17, 4, 3, 5, 18, 9,
    16, 8, 1, 2, 11, 15, 1, 12, 11, 14, 6 };
TankCounter = 1;

InfantryTypes = { "dog", "e1", "e2", "e3", "e3r1", "e4", "e1", "spy", "e7", "medi", "mech", "gnrl", "thf", "shok",
    "sniper" }
InfantrySequence = { 1, 1, 12, 7, 8, 2, 11, 11, 5, 14, 13, 3, 6, 4, 9, 9, 13, 4, 2, 7, 11, 11, 8, 1, 6, 5, 3, 14, 12, 1,
    11, 12, 8, 3, 5, 2, 9, 7, 11, 1, 6, 14, 1, 13, 1, 9, 14, 11, 12, 2, 11, 13, 4, 3, 8, 5, 6, 1, 1, 0 };
InfantryCounter = 1;

-- EngineerTargetBuildings = { "oilb", "fcom", "hosp", "bio", "fact", "afld", "powr", "apwr", "stek", "barr", "kenn", "proc", "tent", "fix", "dome", "mslo", "gap", "spen", "syrd", "iron", "pdox", "agun", "sam", "atek", "fact"}
EngineerTargetBuildings = { "oilb", "fcom", "hosp", "bio" }
AllPlayersIncludingCreeps = {};
AllPlayers = {};
AIPlayers = {};
HumanPlayers = {};

-- Randomizer.
function GetItemByIndex(array, index)
    for i, k in ipairs(array) do
        if i == index then
            return k;
        end
    end
    return "invalid_index";
end

function FindClosestEnemyActorForActor(searchingActor, actorTypes)
    local closestDistance = 200000;
    local closestActor = nil
    
    
    for _, enemyPlayer in ipairs(AllPlayersIncludingCreeps) do
        if enemyPlayer ~= searchingActor.EffectiveOwner then
            if enemyPlayer.Team ~= searchingActor.EffectiveOwner.Team or enemyPlayer.Team == 0 or searchingActor.EffectiveOwner.Team == 0 then

                -- Media.DisplayMessage(enemyPlayer.Team .. " team", "", HSLColor.Red)

                local actors = enemyPlayer.GetActorsByTypes(actorTypes);
                for _, actor in ipairs(actors) do
--                     Media.DisplayMessage("checking distance",  "", HSLColor.Red)
                    local distancePos = actor.Location - searchingActor.Location;
                    local distance = math.sqrt((distancePos.X * distancePos.X) + (distancePos.Y * distancePos.Y));

                    -- Media.DisplayMessage("distance" .. distance, "", HSLColor.Red)
                    if distance <= closestDistance then
                        closestDistance = distance;
                        closestActor = actor;
                    end
                end
            end
        end
    end
    return closestActor;
end


function GetRandomTank()
    if TankCounter >= #TankSequence then
        TankCounter = 1;
    end
    local index = GetItemByIndex(TankSequence, TankCounter);
    TankCounter = TankCounter + 1;
    return GetItemByIndex(TankTypes, index);
end

function GetRandomInfantry()
    if InfantryCounter >= #InfantrySequence then
        InfantryCounter = 1;
    end
    
    local index = GetItemByIndex(InfantrySequence, InfantryCounter);
    InfantryCounter = InfantryCounter + 1;
    return GetItemByIndex(InfantryTypes, index);
end

function GetBots()
    return Player.GetPlayers(function(player)
        return player.IsBot == true;
    end);
end

function GetHumans()
    return Player.GetPlayers(function(player)
        return player.IsBot == false and player.IsNonCombatant == false;
    end);
end

function GetAllPlayers()
    return Player.GetPlayers(function(player)
        return player.IsNonCombatant == false;
    end);
end

function GetAllPlayersIncludingCreeps()
    return Player.GetPlayers(function(player)
        return true
    end);
end

-- Players
function WorldLoaded()
    Neutral = Player.GetPlayer("Neutral");
    Creeps = Player.GetPlayer("Creeps");

    -- Initialize AI & Human Players
    AllPlayersIncludingCreeps = GetAllPlayersIncludingCreeps();
    AllPlayers = GetAllPlayers();
    AIPlayers = GetBots();
    HumanPlayers = GetHumans();
end

-- AI Engineer Logic
-- Every second force the engineer to capture stuff (Broken need https://github.com/OpenRA/OpenRA/pull/20276 to be merged)
function RunEngineerSequence()

    for _, player in ipairs(AIPlayers) do

        local engineers = player.GetActorsByType("e6");
        for _, engineer in ipairs(engineers) do

            
            local closestActor = FindClosestEnemyActorForActor(engineer, EngineerTargetBuildings)

            -- if closestActor ~= nil and closestActor.CanCapture(closestActor) then
            if closestActor ~= nil then
                 engineer.Capture(closestActor);
            end
            

        end
    end

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        RunEngineerSequence()
    end)
end

Trigger.AfterDelay(DateTime.Seconds(1), function()
    RunEngineerSequence()
end)

-- Every 60 seconds give the AI an engineer to capture stuff)
function GiveAIEngineer()
    Trigger.AfterDelay(DateTime.Seconds(5), function()
        for _, player in ipairs(AIPlayers) do
            Actor.Create("e6", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
        end
    end)

    Trigger.AfterDelay(DateTime.Seconds(10), function()
        for _, player in ipairs(AIPlayers) do
            Actor.Create("e6", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
        end
    end)

    Trigger.AfterDelay(DateTime.Seconds(15), function()
        for _, player in ipairs(AIPlayers) do
            Actor.Create("e6", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
        end
    end)

    Trigger.AfterDelay(DateTime.Seconds(20), function()
        for _, player in ipairs(AIPlayers) do
            Actor.Create("e6", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
        end
    end)

    Trigger.AfterDelay(DateTime.Seconds(60), function()
        GiveAIEngineer()
    end)
end
Trigger.AfterDelay(DateTime.Seconds(1), function()
    GiveAIEngineer()
end)



-- AI Fun Sequence

Trigger.AfterDelay(DateTime.Seconds(5), function()
    Media.PlaySoundNotification(USSR, "AlertBuzzer")
end)

Trigger.AfterDelay(DateTime.Seconds(7), function()
    Media.PlaySoundNotification(USSR, "AlertBuzzer")
end)

Trigger.AfterDelay(DateTime.Seconds(9), function()
    Media.PlaySoundNotification(USSR, "AlertBuzzer")
end)


Trigger.AfterDelay(DateTime.Seconds(10), function()

    for _, player in ipairs(AIPlayers) do
        Media.DisplayMessage(player.Name .. " just awakened!", "", HSLColor.Red)
    end
end)

Trigger.AfterDelay(DateTime.Seconds(12), function()
    Media.PlaySpeechNotification(USSR, "TargetFreed")
end)


Trigger.AfterDelay(DateTime.Seconds(20), function()
    Media.PlaySpeechNotification(USSR, "EnemyDetected")
end)

Trigger.AfterDelay(DateTime.Seconds(22), function()
    for _, humanPlayer in ipairs(HumanPlayers) do
        for _, player in ipairs(AIPlayers) do
            Radar.Ping(humanPlayer, Map.CenterOfCell(player.HomeLocation), HSLColor.Red, 500)
            Beacon.New(humanPlayer, Map.CenterOfCell(player.HomeLocation), 500)
        end
    end
    Media.PlaySoundNotification(USSR, "Beacon");
end)

Trigger.AfterDelay(DateTime.Seconds(25), function()
    Media.DisplayMessage("I will destroy you all!", "AI", HSLColor.Red)
end)

Trigger.AfterDelay(DateTime.Seconds(24), function()
    Media.PlaySoundNotification(USSR, "BaseSetup")
end)

Trigger.AfterDelay(DateTime.Seconds(30), function()
    Media.DisplayMessage("Good luck! You will need it hahaha!", "AI", HSLColor.Red)
end)


Trigger.AfterDelay(DateTime.Seconds(45), function()
    Media.DisplayMessage("You think you know how to play? Let's see then what you got!", "AI", HSLColor.Red)
end)

Trigger.AfterDelay(DateTime.Seconds(100), function()
    Media.DisplayMessage("Hahaha. You will fail... What a noob team!", "AI", HSLColor.Red)
end)

Trigger.AfterDelay(DateTime.Seconds(220), function()
    Media.DisplayMessage("Okay. So if that didn't work, let's try something else :)!", "AI", HSLColor.Red)
end)



-- Give 1st MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(5), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)


-- Give 2nd MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(15), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)

-- Give 3rd MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(30), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)


-- Give 3rd MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(45), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)


-- Give 3rd MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(60), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)


-- Give 3rd MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(90), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)


-- Give 3rd MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(120), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)

-- Give a harvester every 30 seconds so the AI keeps mining
function GiveAIHarvester()
    Trigger.AfterDelay(DateTime.Seconds(30), function()

        for _, player in ipairs(AIPlayers) do
            Actor.Create("harv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
        end
        GiveAIHarvester();
    end)
end

Trigger.AfterDelay(DateTime.Seconds(120), function()
    GiveAIHarvester();
end)


-- Give an MCV every 30 seconds so the AI keeps expanding at a steady rate
function GiveAIMCV()
    Trigger.AfterDelay(DateTime.Seconds(30), function()

        for _, player in ipairs(AIPlayers) do
            Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
        end
        GiveAIMCV();
    end)
end

Trigger.AfterDelay(DateTime.Seconds(120), function()
    GiveAIMCV();
end)


-- Give cash to the AI players every 5 seconds
function GiveAICash()
    Trigger.AfterDelay(DateTime.Seconds(5), function()

        for _, player in ipairs(AIPlayers) do
            if player.Cash < 5000 then
                player.Cash = player.Cash + 1000;
            end

        end
        GiveAICash();
    end)
end

GiveAICash();


-- Give a rifle infantry unit every 3 seconds after 60 seconds
function GiveRifleInfantry()
    Trigger.AfterDelay(DateTime.Seconds(7), function()

        for _, player in ipairs(AIPlayers) do
            -- barracks

            local barracks = player.GetActorsByTypes({ "barr", "tent" });


            for _, barrack in ipairs(barracks) do
                local e1 = Actor.Create("e1", true, { Owner = player, Location = barrack.Location + CVec.New(0, 1) });
                e1.AttackMove(barrack.RallyPoint);
            end
        end
        GiveRifleInfantry();
    end)
end
Trigger.AfterDelay(DateTime.Seconds(120), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    GiveRifleInfantry();
end)


-- Give a rifle infantry unit every 3 seconds after 60 seconds
function GiveRifleInfantryTwo()
    Trigger.AfterDelay(DateTime.Seconds(4), function()

        for _, player in ipairs(AIPlayers) do
            -- barracks

            local barracks = player.GetActorsByTypes({ "barr", "tent" });
            for _, barrack in ipairs(barracks) do
                local e1 = Actor.Create("e1", true, { Owner = player, Location = barrack.Location + CVec.New(0, 1) });
                e1.AttackMove(barrack.RallyPoint);
            end
        end
        GiveRifleInfantryTwo();
    end)
end
Trigger.AfterDelay(DateTime.Seconds(900), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    GiveRifleInfantryTwo();
end)

-- Give a rocket soldier every 10 seconds after 120 seconds
function GiveRocketSoldier()
    Trigger.AfterDelay(DateTime.Seconds(10), function()

        for _, player in ipairs(AIPlayers) do
            -- barracks

            local barracks = player.GetActorsByTypes({ "barr", "tent" });


            for _, barrack in ipairs(barracks) do
                local e1 = Actor.Create("e3", true, { Owner = player, Location = barrack.Location + CVec.New(0, 1) });
                e1.AttackMove(barrack.RallyPoint);
            end
        end
        GiveRocketSoldier();
    end)
end
Trigger.AfterDelay(DateTime.Seconds(180), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    GiveRocketSoldier();
end)


function GiveLightTanks()
    Trigger.AfterDelay(DateTime.Seconds(60), function()

        for _, player in ipairs(AIPlayers) do
            -- warfactories
            local warfactories = player.GetActorsByTypes({ "weap" });


            for _, warfactory in ipairs(warfactories) do

        
                local e1 = Actor.Create("1tnk", true,
                    { Owner = player, Location = warfactory.Location + CVec.New(0, 1) });

                    if tankType == "harv" then
                        e1.Move(warfactory.RallyPoint);
                        e1.FindResources();
                    else
                        if tankType == "qtnk" or tankType == "mgg"  or tankType == "mrj" then
                            e1.Move(warfactory.RallyPoint);
                        else
                            e1.AttackMove(warfactory.RallyPoint);
                        end
                    end
                

                 
            end
        end
        GiveLightTanks();
    end)
end
Trigger.AfterDelay(DateTime.Seconds(500), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    GiveLightTanks();
end)

function GiveMediumTanks()
    Trigger.AfterDelay(DateTime.Seconds(120), function()

        for _, player in ipairs(AIPlayers) do
            -- warfactories
            local warfactories = player.GetActorsByTypes({ "weap" });


            for _, warfactory in ipairs(warfactories) do

              
                local e1 = Actor.Create("2tnk", true,
                    { Owner = player, Location = warfactory.Location + CVec.New(0, 1) });

                    if tankType == "harv" then
                        e1.Move(warfactory.RallyPoint);
                        e1.FindResources();
                    else
                        if tankType == "qtnk" or tankType == "mgg"  or tankType == "mrj" then
                            e1.Move(warfactory.RallyPoint);
                        else
                            e1.AttackMove(warfactory.RallyPoint);
                        end
                    end
                    
            end
        end
        GiveMediumTanks();
    end)
end
Trigger.AfterDelay(DateTime.Seconds(660), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    GiveMediumTanks();
end)

function GiveHeavyTanks()
    Trigger.AfterDelay(DateTime.Seconds(180), function()

        for _, player in ipairs(AIPlayers) do
            -- warfactories
            local warfactories = player.GetActorsByTypes({ "weap" });


            for _, warfactory in ipairs(warfactories) do

                
                local e1 = Actor.Create("3tnk", true,
                    { Owner = player, Location = warfactory.Location + CVec.New(0, 1) });

                    if tankType == "harv" then
                        e1.Move(warfactory.RallyPoint);
                        e1.FindResources();
                    else
                        if tankType == "qtnk" or tankType == "mgg"  or tankType == "mrj" then
                            e1.Move(warfactory.RallyPoint);
                        else
                            e1.AttackMove(warfactory.RallyPoint);
                        end
                    end
                    

                
            end
        end
        GiveHeavyTanks();
    end)
end
Trigger.AfterDelay(DateTime.Seconds(900), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    GiveHeavyTanks();
end)

-- Give an extra tank every 15 seconds after 5 minutes
function GiveSimpleTanks()
    Trigger.AfterDelay(DateTime.Seconds(15), function()

        for _, player in ipairs(AIPlayers) do
            -- warfactories
            local warfactories = player.GetActorsByTypes({ "weap" });


            for _, warfactory in ipairs(warfactories) do

               
                local tankType = GetRandomTank();
                local e1 = Actor.Create(tankType, true,
                    { Owner = player, Location = warfactory.Location + CVec.New(0, 1) });

                    if tankType == "harv" then
                        e1.Move(warfactory.RallyPoint);
                        e1.FindResources();
                    else
                        if tankType == "qtnk" or tankType == "mgg"  or tankType == "mrj" then
                            e1.Move(warfactory.RallyPoint);
                        else
                            e1.AttackMove(warfactory.RallyPoint);
                        end
                    end
                    

                  
            end
        end
        GiveSimpleTanks();
    end)
end

Trigger.AfterDelay(DateTime.Seconds(300), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    GiveSimpleTanks();
end)

Trigger.AfterDelay(DateTime.Seconds(902), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    GiveSimpleTanks();
end)

Trigger.AfterDelay(DateTime.Seconds(1103), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    GiveSimpleTanks();
end)

-- Give a special unit every 15 seconds after 5 minutes.
function GiveSpecialInfantry()
    Trigger.AfterDelay(DateTime.Seconds(15), function()

        for _, player in ipairs(AIPlayers) do

            -- barracks
            local barracks = player.GetActorsByTypes({ "barr", "tent" });

            for _, barrack in ipairs(barracks) do

           
                    local unitType = GetRandomInfantry();
                    
                    local e1 = Actor.Create(unitType, true,
                        { Owner = player, Location = barrack.Location + CVec.New(0, 1) });

                    if unitType ~= "thf" then
                        e1.AttackMove(barrack.RallyPoint);
                    else
                        e1.Move(barrack.RallyPoint);
                    end
                
            end
        end
        GiveSpecialInfantry();
    end)
end

Trigger.AfterDelay(DateTime.Seconds(240), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    GiveSpecialInfantry();
end)

Trigger.AfterDelay(DateTime.Seconds(707), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    GiveSpecialInfantry();
end)

Trigger.AfterDelay(DateTime.Seconds(1203), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    GiveSpecialInfantry();
end)
-- Mass Army Attacks Waves

-- 10 Rifle Soldier
Trigger.AfterDelay(DateTime.Seconds(30), function()

    for _, player in ipairs(AIPlayers) do

        -- 60 riffle guys
        local unitCount = 10;
        while unitCount > 0 do

            local e1 = Actor.Create("e1", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
            
            
            unitCount = unitCount - 1;

            if (unitCount <= 0) then
                return;
            end
    
        end
    end

    for _, player in ipairs(AIPlayers) do

        -- 10 grenadiers
        local unitCount = 10;
        while unitCount > 0 do

            local e1 = Actor.Create("e2", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
            
            
            unitCount = unitCount - 1;

            if (unitCount <= 0) then
                return;
            end
    
        end
    end

    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("Rush incoming! Beware!", "AI", HSLColor.Red)

end)

-- 30 Infantry
Trigger.AfterDelay(DateTime.Seconds(60), function()

    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("Reinforcements are incoming! Beware!", "AI", HSLColor.Red)


    for _, player in ipairs(AIPlayers) do

        -- 60 riffle guys
        local unitCount = 30;
        while unitCount > 0 do

            local e1 = Actor.Create("e1", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
            
            
            unitCount = unitCount - 1;

            if (unitCount <= 0) then
                return;
            end
    
        end
    end

end)

-- 60 Infantry
Trigger.AfterDelay(DateTime.Seconds(120), function()

    for _, player in ipairs(AIPlayers) do

        -- 60 riffle guys
        local unitCount = 60;
        while unitCount > 0 do

            local e1 = Actor.Create("e1", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
            
            
            unitCount = unitCount - 1;

            if (unitCount <= 0) then
                return;
            end
    
        end
    end

    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("Reinforcements are incoming! Beware!", "AI", HSLColor.Red)

end)


-- 40 Infantry
Trigger.AfterDelay(DateTime.Seconds(200), function()

    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("A small wave of enemy units incoming! Watch out!", "AI", HSLColor.Red)

    for _, player in ipairs(AIPlayers) do

        -- 60 riffle guys
        local unitCount = 40;
        while unitCount > 0 do

            local e1 = Actor.Create("e1", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
            
            
            unitCount = unitCount - 1;

            if (unitCount <= 0) then
                return;
            end
    
        end
    end

    for _, player in ipairs(AIPlayers) do

           -- 120 riffle guys
           local unitCount = 10;
           while unitCount > 0 do
               local e1 = Actor.Create("e3", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
               
               unitCount = unitCount - 1;
   
               if (unitCount <= 0) then
                   return;
               end
           end
    end
end)

-- 120 Infantry
Trigger.AfterDelay(DateTime.Seconds(300), function()

    for _, player in ipairs(AIPlayers) do
        -- 120 riffle guys
        local unitCount = 120;
        while unitCount > 0 do
            local e1 = Actor.Create("e1", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
   
            
            unitCount = unitCount - 1;

            if (unitCount <= 0) then
                return;
            end
        end
    end


    for _, player in ipairs(AIPlayers) do

           -- 120 riffle guys
           local unitCount = 30;
           while unitCount > 0 do
               local e1 = Actor.Create("e3", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
 
               
               unitCount = unitCount - 1;
   
               if (unitCount <= 0) then
                   return;
               end
           end
    end

     
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("A huge wave of enemy units incoming! OMG. GG!", "AI", HSLColor.Red)
    
end)


-- 60 Rifle Soldier
Trigger.AfterDelay(DateTime.Seconds(420), function()

    for _, player in ipairs(AIPlayers) do

          -- 120 riffle guys
          local unitCount = 60;
          while unitCount > 0 do
              local e1 = Actor.Create("e1", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
  
              
              unitCount = unitCount - 1;
  
              if (unitCount <= 0) then
                  return;
              end
          end
    end

    for _, player in ipairs(AIPlayers) do

           -- 120 riffle guys
           local unitCount = 60;
           while unitCount > 0 do
               local e1 = Actor.Create("e3", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
        
               
               unitCount = unitCount - 1;
   
               if (unitCount <= 0) then
                   return;
               end
           end
    end

    for _, player in ipairs(AIPlayers) do
        -- 120 riffle guys
        local unitCount = 20;
        while unitCount > 0 do
            local e1 = Actor.Create("2tnk", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    
            unitCount = unitCount - 1;

            if (unitCount <= 0) then
                return;
            end
        end
    end

     
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("An even bigger wave of enemy units incoming! This is over...", "AI", HSLColor.Red)
end)


-- Standard and final wave (Every 5 mins) after 10 mins
function SpawnStandardWave()
    for _, player in ipairs(AIPlayers) do

            -- 60 riffle guys
            local unitCount = 60;
            while unitCount > 0 do
                local e1 = Actor.Create("e1", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
        
                
                unitCount = unitCount - 1;

                if (unitCount <= 0) then
                    return;
                end
            end
    end


    for _, player in ipairs(AIPlayers) do

        -- 30 rocket guys
        local unitCount = 30;
        while unitCount > 0 do
            local e1 = Actor.Create("e3", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    
            
            unitCount = unitCount - 1;

            if (unitCount <= 0) then
                return;
            end
        end
    end

    for _, player in ipairs(AIPlayers) do
        -- 20 medium tanks
        local unitCount = 20;
        while unitCount > 0 do
            local e1 = Actor.Create("2tnk", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    
            unitCount = unitCount - 1;

            if (unitCount <= 0) then
                return;
            end
        end
    end

    for _, player in ipairs(AIPlayers) do
        -- 10 heavy tanks
        local unitCount = 10;
        while unitCount > 0 do
            local e1 = Actor.Create("3tnk", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    
            unitCount = unitCount - 1;

            if (unitCount <= 0) then
                return;
            end
        end
    end

    for _, player in ipairs(AIPlayers) do
        -- 5 mamoth tanks
        local unitCount = 5;
        while unitCount > 0 do
            local e1 = Actor.Create("4tnk", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    
            unitCount = unitCount - 1;

            if (unitCount <= 0) then
                return;
            end
        end
    end
    

    Trigger.AfterDelay(DateTime.Seconds(300), function()
        Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
        Media.DisplayMessage("Reinforcements incoming!", "AI", HSLColor.Red)
        SpawnStandardWave()
    end)
end
Trigger.AfterDelay(DateTime.Seconds(600), function()

    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("Super wave incoming! You won't survive this for sure! GG WP", "AI", HSLColor.Red)


    SpawnStandardWave()
end)