-- Copyright Azarus @ 2022
TankTypes = { "v2rl", "1tnk", "2tnk", "3tnk", "4tnk", "arty", "harv", "jeep", "apc", "mnly", "2tnk", "mgg", "mrj", "ttnk",
    "ftrk", "dtrk", "ctnk", "qtnk", "stnk" }
TankSequence = { 15, 7, 1, 4, 18, 14, 17, 11, 11, 12, 8, 13, 6, 3, 16, 9, 5, 1, 2, 5, 7, 16, 14, 4, 6, 15, 9, 8, 2, 11, 3,
    13, 17, 11, 18, 1, 12, 1, 11, 1, 6, 9, 12, 18, 5, 8, 3, 14, 15, 1, 16, 11, 13, 4, 7, 2, 17, 13, 7, 17, 4, 3, 5, 18, 9,
    16, 8, 1, 2, 11, 15, 1, 12, 11, 14, 6 };
TankCounter = 1;

InfantryTypes = { "dog", "e1", "e2", "e3", "e3r1", "e4", "e1", "spy", "e7", "medi", "mech", "gnrl", "thf", "shok",
    "sniper" }
InfantrySequence = { 1, 1, 12, 7, 8, 2, 11, 11, 5, 14, 13, 3, 6, 4, 9, 9, 13, 4, 2, 7, 11, 11, 8, 1, 6, 5, 3, 14, 12, 1,
    11, 12, 8, 3, 5, 2, 9, 7, 11, 1, 6, 14, 1, 13, 1, 9, 14, 11, 12, 2, 11, 13, 4, 3, 8, 5, 6, 1, 1, 0 };
InfantryCounter = 1;

-- Randomizer.
function GetItemByIndex(array, index)
    for i, k in ipairs(array) do
        if i == index then
            return k;
        end
    end
    return "invalid_index";
end

function GetRandomTank()
    if TankCounter >= #TankSequence then
        TankCounter = 1;
    end
    local index = GetItemByIndex(TankSequence, TankCounter);
    TankCounter = TankCounter + 1;
    return GetItemByIndex(TankTypes, index);
end

function GetRandomInfantry()
    if InfantryCounter >= #InfantrySequence then
        InfantryCounter = 1;
    end
    
    local index = GetItemByIndex(InfantrySequence, InfantryCounter);
    InfantryCounter = InfantryCounter + 1;
    return GetItemByIndex(InfantryTypes, index);
end

function GetBots()
    return Player.GetPlayers(function(player)
        return player.IsBot == true;
    end);
end

function GetHumans()
    return Player.GetPlayers(function(player)
        return player.IsBot == false and player.IsNonCombatant == false;
    end);
end

function GetAllPlayers()
    return Player.GetPlayers(function(player)
        return player.IsNonCombatant == false;
    end);
end

-- Players
function WorldLoaded()
    Neutral = Player.GetPlayer("Neutral");
    Creeps = Player.GetPlayer("Creeps");

    -- Initialize AI & Human Players
    LocalPlayer = Player.GetPlayer("Multi0");
    AllPlayers = GetAllPlayers();
    AIPlayers = GetBots();
    HumanPlayers = GetHumans();
end

-- AI Fun Sequence

Trigger.AfterDelay(DateTime.Seconds(1), function()
    Media.PlaySoundNotification(USSR, "AlertBuzzer")
end)

Trigger.AfterDelay(DateTime.Seconds(3), function()
    Media.PlaySoundNotification(USSR, "AlertBuzzer")
end)

Trigger.AfterDelay(DateTime.Seconds(5), function()
    Media.PlaySoundNotification(USSR, "AlertBuzzer")
end)


Trigger.AfterDelay(DateTime.Seconds(4), function()

    for _, player in ipairs(AIPlayers) do
        Media.DisplayMessage(player.Name .. " just awakened!", "", HSLColor.Red)
    end
end)

Trigger.AfterDelay(DateTime.Seconds(6), function()
    Media.PlaySpeechNotification(USSR, "TargetFreed")
end)


Trigger.AfterDelay(DateTime.Seconds(11), function()

    Media.PlaySpeechNotification(USSR, "EnemyDetected")
end)
Trigger.AfterDelay(DateTime.Seconds(12), function()

    Media.PlaySpeechNotification(USSR, "EnemyDetected")
end)

Trigger.AfterDelay(DateTime.Seconds(14), function()
    for _, player in ipairs(AIPlayers) do
        Radar.Ping(LocalPlayer, Map.CenterOfCell(player.HomeLocation), HSLColor.Red, 500)
        Beacon.New(LocalPlayer, Map.CenterOfCell(player.HomeLocation), 500)
    end
    Media.PlaySoundNotification(USSR, "Beacon");
end)


Trigger.AfterDelay(DateTime.Seconds(15), function()

    for _, player in ipairs(AIPlayers) do
        Media.DisplayMessage("I will destroy you all!", player.Name, HSLColor.Red)
    end
end)

Trigger.AfterDelay(DateTime.Seconds(20), function()
    Media.PlaySoundNotification(USSR, "BaseSetup")
end)

Trigger.AfterDelay(DateTime.Seconds(20), function()
    for _, player in ipairs(AIPlayers) do
        Media.DisplayMessage("You think you know how to play? MUAHAHA. Let's see then what you got!!!", player.Name, HSLColor.Red)

    end
end)


-- Give 1st MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(5), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)


-- Give 2nd MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(15), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)

-- Give 3rd MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(30), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)


-- Give 3rd MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(45), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)


-- Give 3rd MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(60), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)


-- Give 3rd MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(90), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)


-- Give 3rd MVC for each AI to build faster and expand..
Trigger.AfterDelay(DateTime.Seconds(120), function()

    for _, player in ipairs(AIPlayers) do
        Actor.Create("mcv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
    end
end)

-- Give a harester every 60 seconds if the AI got money
function GiveAIMCV()
    Trigger.AfterDelay(DateTime.Seconds(60), function()

        for _, player in ipairs(AIPlayers) do
            if player.Cash < 1000 then
                Actor.Create("harv", true, { Owner = player, Location = player.HomeLocation + CVec.New(0, 1) });
            end
        end
        GiveAICash();
    end)
end

Trigger.AfterDelay(DateTime.Seconds(120), function()
    GiveAIMCV();
end)


-- Give cash to the AI players every 5 seconds
function GiveAICash()
    Trigger.AfterDelay(DateTime.Seconds(5), function()

        for _, player in ipairs(AIPlayers) do
            if player.Cash < 5000 then
                player.Cash = player.Cash + 1000;
            end

        end
        GiveAICash();
    end)
end

GiveAICash();


-- Give a rifle infantry unit every 5 seconds after 60 seconds
function GiveRifleInfantry()
    Trigger.AfterDelay(DateTime.Seconds(5), function()

        for _, player in ipairs(AIPlayers) do
            -- barracks

            local barracks = player.GetActorsByTypes({ "barr", "tent" });


            for _, barrack in ipairs(barracks) do

                if player.Cash > 50 then
                    local e1 = Actor.Create("e1", true, { Owner = player, Location = barrack.Location + CVec.New(0, 1) });
                    e1.AttackMove(barrack.RallyPoint);
                    player.Cash = player.Cash - 50;
                end
            end
        end
        GiveRifleInfantry();
    end)
end
Trigger.AfterDelay(DateTime.Seconds(120), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("Just enabled a cheat to mass produce rifle infantry OMG!", "AI", HSLColor.Red)
    GiveRifleInfantry();
end)


-- Give a rocket soldier every 15 seconds after 120 seconds
function GiveRocketSoldier()
    Trigger.AfterDelay(DateTime.Seconds(15), function()

        for _, player in ipairs(AIPlayers) do
            -- barracks

            local barracks = player.GetActorsByTypes({ "barr", "tent" });


            for _, barrack in ipairs(barracks) do

                if player.Cash > 100 then

                    local e1 = Actor.Create("e3", true, { Owner = player, Location = barrack.Location + CVec.New(0, 1) });
                    e1.AttackMove(barrack.RallyPoint);

                    player.Cash = player.Cash - 100;
                end
            end
        end
        GiveRocketSoldier();
    end)
end
Trigger.AfterDelay(DateTime.Seconds(180), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("Just enabled a cheat to mass produce rocket soldiers OMG!", "AI", HSLColor.Red)
    GiveRocketSoldier();
end)


-- Give an extra tank every 20 seconds after 5 minutes
function GiveSimpleTanks()
    Trigger.AfterDelay(DateTime.Seconds(20), function()

        for _, player in ipairs(AIPlayers) do
            -- warfactories
            local warfactories = player.GetActorsByTypes({ "weap" });


            for _, warfactory in ipairs(warfactories) do

                if player.Cash > 400 then
                    local tankType = GetRandomTank();
                    local e1 = Actor.Create(tankType, true,
                        { Owner = player, Location = warfactory.Location + CVec.New(0, 1) });

                        if tankType == "harv" then
                            e1.Move(warfactory.RallyPoint);
                            e1.FindResources();
                        else
                            if tankType == "qtnk" or tankType == "mgg"  or tankType == "mrj" then
                                e1.Move(warfactory.RallyPoint);
                            else
                                e1.AttackMove(warfactory.RallyPoint);
                            end
                        end
                    

                    player.Cash = player.Cash - 400;
                end
            end
        end
        GiveSimpleTanks();
    end)
end

Trigger.AfterDelay(DateTime.Seconds(300), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("Just enabled a cheat to mass produce tanks OMG!", "AI", HSLColor.Red)
    GiveSimpleTanks();
end)


-- Give a special unit every 15 seconds after 5 minutes.
function GiveSpecialInfantry()
    Trigger.AfterDelay(DateTime.Seconds(15), function()

        for _, player in ipairs(AIPlayers) do

            -- barracks
            local barracks = player.GetActorsByTypes({ "barr", "tent" });

            for _, barrack in ipairs(barracks) do

                if player.Cash > 100 then

                    local unitType = GetRandomInfantry();
                    
                    local e1 = Actor.Create(unitType, true,
                        { Owner = player, Location = barrack.Location + CVec.New(0, 1) });

                    if unitType ~= "thf" then
                        e1.AttackMove(barrack.RallyPoint);
                    else
                        e1.Move(barrack.RallyPoint);
                    end
                    player.Cash = player.Cash - 100;
                end
            end
        end
        GiveSpecialInfantry();
    end)
end

Trigger.AfterDelay(DateTime.Seconds(240), function()
    Media.PlaySpeechNotification(USSR, "EnemyUnitsApproaching")
    Media.DisplayMessage("Just enabled a cheat to mass produce infantry OMG!", "AI", HSLColor.Red)
    GiveSpecialInfantry();
end)
