MercenaryEntryPath = { MercenaryStarportPoint1.Location, MercenaryStarportPoint2.Location, MercenaryStarportPoint3.Location }
OrdosPath = { OrdosRally1.Location, OrdosRally2.Location }
OrdosEntryPath = { OrdosRally2.Location, OrdosRally3.Location }
SaboteurPaths =
{
	{ APoint1.Location, APoint2.Location, APoint3.Location, APoint4.Location },
	{ APoint9.Location, APoint10.Location, APoint11.Location, APoint12.Location, APoint13.Location }
}

SaboteurPaths2 =
{
	{ APoint5.Location, APoint6.Location, APoint7.Location, APoint8.Location },
	{ APoint14.Location, APoint15.Location, APoint16.Location, APoint17.Location }
}

MercenaryStarportReinforcements =
{
	{ "trooper", "trooper", "trooper", "trooper", "trooper", "trooper", "quad", "trike" },
	{ "combat_tank_o", "combat_tank_o", "siege_tank", "siege_tank" }
}

OrdosReinforcements = { "raider", "quad", "combat_tank_o", "light_inf", "light_inf", "trooper", "trooper" }

MercenaryStarportDelay =
{
	easy  = DateTime.Minutes(6) + DateTime.Seconds(20),
	normal = DateTime.Seconds(6)+ DateTime.Seconds(30),
	hard = DateTime.Minutes(7) + DateTime.Seconds(30)
}

SendStarportReinforcements = function()
	Trigger.AfterDelay(MercenaryStarportDelay[Difficulty], function()
		if MStarport.IsDead or MStarport.Owner ~= Mercenary then
			return
		end
		
		reinforcements = Utils.Random(MercenaryStarportReinforcements)

		local units = Reinforcements.ReinforceWithTransport(Mercenary, "frigate", reinforcements, { MercenaryStarportEntry.Location, MStarport.Location + CVec.New(1, 1) }, { MercenaryStarportExit.Location })[2]
		Reinforcements.Reinforce(Mercenary, reinforcements, MercenaryEntryPath)
		
		Media.DisplayMessage("Прибыл груз Наёмников", "Ментат")
		
		SendStarportReinforcements()
	end)
end

GetSaboteurTargets = function(Ordos)
	return Utils.Where(Ordos.GetActors(), function(actor)
		return
			actor.HasProperty("Sell") and
			actor.Type ~= "wall" and
			actor.Type ~= "medium_gun_turret" and
			actor.Type ~= "large_gun_turret" and
			actor.Type ~= "silo"
	end)
end

GetSaboteurTargets1 = function(Ordos2)
	return Utils.Where(Ordos2.GetActors(), function(actor)
		return
			actor.HasProperty("Sell") and
			actor.Type ~= "wall" and
			actor.Type ~= "medium_gun_turret" and
			actor.Type ~= "large_gun_turret" and
			actor.Type ~= "silo"
	end)
end

BuildSaboteur = function()
	if ABarrack.IsDead or ABarrack.Owner ~= Atreides2 then
		return
	end

	local targets = GetSaboteurTargets(Ordos)
	if #targets > 0 then
		local saboteur = Actor.Create("engineer", true, { Owner = Atreides2, Location = ABarrack.Location + CVec.New(0, 2) })
		saboteur.Move(saboteur.Location + CVec.New(0, 1))
		saboteur.Wait(DateTime.Seconds(5))

		local path = Utils.Random(SaboteurPaths)
		saboteur.Move(path[1])
		saboteur.Move(path[2])

		SendSaboteur(saboteur)
	end

	Trigger.AfterDelay(DateTime.Minutes(2) + DateTime.Seconds(30), BuildSaboteur)
end

BuildSaboteur1 = function()
	if ABarrack.IsDead or ABarrack.Owner ~= Atreides2 then
		return
	end

	local targets = GetSaboteurTargets1(Ordos2)
	if #targets > 0 then
		local saboteur = Actor.Create("engineer", true, { Owner = Atreides2, Location = ABarrack.Location + CVec.New(0, 2) })
		saboteur.Move(saboteur.Location + CVec.New(1, 1))
		saboteur.Wait(DateTime.Seconds(5))

		local path = Utils.Random(SaboteurPaths2)
		saboteur.Move(path[1])
		saboteur.Move(path[2])
		
		SendSaboteur1(saboteur)
	end

	Trigger.AfterDelay(DateTime.Minutes(3), BuildSaboteur1)
end

SendSaboteur = function(saboteur)
	local targets = GetSaboteurTargets(Ordos)
	if #targets < 1 then
		return
	end

	local target = Utils.Random(targets)
	saboteur.Capture(target)

	-- 'target' got removed from the world in the meantime
	saboteur.CallFunc(function()
		SendSaboteur(saboteur)
	end)
end

SendSaboteur1 = function(saboteur)
	local targets = GetSaboteurTargets1(Ordos2)
	if #targets < 1 then
		return
	end

	local target = Utils.Random(targets)
	saboteur.Capture(target)

	-- 'target' got removed from the world in the meantime
	saboteur.CallFunc(function()
		SendSaboteur1(saboteur)
	end)
end

Tick = function()
	if Ordos.HasNoRequiredUnits() or Ordos2.HasNoRequiredUnits() then
		Atreides.MarkCompletedObjective(KillOrdos)
		Atreides2.MarkCompletedObjective(KillOrdos2)
		Harkonnen.MarkCompletedObjective(KillOrdos3)
		Ordos.MarkFailedObjective(KillOrdos)
		Ordos2.MarkFailedObjective(KillOrdos)
	end
	if Atreides.HasNoRequiredUnits() and  Atreides2.HasNoRequiredUnits() and not Ordos.IsObjectiveCompleted(KillAtreides) and not Ordos2.IsObjectiveCompleted(KillAtreides2) and not Mercenary.IsObjectiveCompleted(KillAtreides3) then
		Media.DisplayMessage("Атрейдесы уничтожены!", "Ментат")
		Ordos.MarkCompletedObjective(KillAtreides)
		Ordos2.MarkCompletedObjective(KillAtreides2)
		Mercenary.MarkCompletedObjective(KillAtreides3)
	end
	if Harkonnen.HasNoRequiredUnits() and not Ordos.IsObjectiveCompleted(KillHarkonnen) and not Ordos2.IsObjectiveCompleted(KillHarkonnen2) and not Mercenary.IsObjectiveCompleted(KillHarkonnen3) then
		Media.DisplayMessage("Харконнены уничтожены!", "Ментат")
		Ordos.MarkCompletedObjective(KillHarkonnen)
		Ordos2.MarkCompletedObjective(KillHarkonnen2)
		Mercenary.MarkCompletedObjective(KillHarkonnen3)
	end
end

WorldLoaded = function()
	Ordos = Player.GetPlayer("Ordos")
	Ordos2 = Player.GetPlayer("Ordos2")
	Mercenary = Player.GetPlayer("Mercenary")
	Atreides = Player.GetPlayer("Atreides")
	Atreides2 = Player.GetPlayer("Atreides2")
	Harkonnen = Player.GetPlayer("Harkonnen")
	
	InitObjectives(Ordos)
	KillAtreides = Ordos.AddPrimaryObjective("Уничтожьте Атрейдесов")
	KillHarkonnen = Ordos.AddPrimaryObjective("Уничтожьте Харконненов")
	KillAtreides2 = Ordos2.AddPrimaryObjective("Уничтожьте Атрейдесов")
	KillHarkonnen2 = Ordos2.AddPrimaryObjective("Уничтожьте Харконненов")
	KillAtreides3 = Mercenary.AddPrimaryObjective("Уничтожьте Атрейдесов")
	KillHarkonnen3 = Mercenary.AddPrimaryObjective("Уничтожьте Харконненов")
	KillOrdos = Atreides.AddPrimaryObjective("Уничтожьте Ордосов")
	KillOrdos2 = Atreides2.AddPrimaryObjective("Уничтожьте Ордосов")
	KillOrdos2 = Harkonnen.AddPrimaryObjective("Уничтожьте Ордосов")
	
	InitObjectives(Ordos2)
	
	Trigger.AfterDelay(DateTime.Minutes(2) + DateTime.Seconds(30), BuildSaboteur)
	Trigger.AfterDelay(DateTime.Minutes(3), BuildSaboteur1)
	
	Trigger.OnObjectiveFailed(Ordos2, function()
		Ordos2.MarkFailedObjective(KillOrdos)
	end)
	
	Trigger.OnObjectiveFailed(Ordos, function()
		Ordos.MarkFailedObjective(KillOrdos)
	end)
	
	Trigger.AfterDelay(DateTime.Minutes(10), function()
		local units = Reinforcements.ReinforceWithTransport(Ordos, "carryall.reinforce", OrdosReinforcements, OrdosPath, { OrdosPath[1] })
		Media.PlaySpeechNotification(Ordos, "Reinforce")
		
		Media.DisplayMessage("Вам прибыло подкрепление.", "Ментат", Ordos.Color)
		
	end)	
	Trigger.AfterDelay(DateTime.Minutes(10) + DateTime.Seconds(5), function()	
		Reinforcements.Reinforce(Ordos, OrdosReinforcements, OrdosEntryPath)
	end)
	
	SendStarportReinforcements()
	
end	

