Survivors = {'Unano', 'Upps', 'Goremented', 'Eugenator', 'anjew', 'Sigil', 'DukeBones', 'Dodder', 'Mo', 'tux', 'Ekanim', 'MargotHonecker', 'milkman', 'Nilhall', 'Mees', 'bete', 'Pvt_Leaf', 'spetsnaz84', 'Liquid', 'TailixKM', 'chouchani'}
StrikePlayers = {'FiveAces', 'worldpeace'}
DogMapping = {}
InternalToSurvivorMap = {}
Finishers = {}
Eliminated = {}
CurrentPosition = {}
Neutrals = {SYRD1, SYRD2, POWR1, POWR2, HOSP1, HOSP2, OIL1, OIL2, RAX1, RAX2}
Captured = {}
Ended = false
TimeInterval = 5
WaypointCPos = {}
GameStage = 0

ForEachLivingEngi = function(callback)
    for i = 1, #Survivors do
        local engiName = "ENGI"..i
        local engi = Map.NamedActor(engiName)
        if engi ~= nil and not engi.IsDead then
            callback(engi)
        end
    end
end

DisplayOtherNames = function()
    local creeps = Player.GetPlayer("Creeps")
    if not SHIP1.IsDead then
        Media.FloatingText("despro", SHIP1.CenterPosition, 30, creeps.Color)
    end
    if not SHIP2.IsDead then
        Media.FloatingText("Blackened", SHIP2.CenterPosition, 30, creeps.Color)
    end
    if not SHIP3.IsDead then
        Media.FloatingText("Gacius", SHIP3.CenterPosition, 30, creeps.Color)
    end
    local dogs = creeps.GetActorsByType("dog")
    if #dogs == 2 and #DogMapping == 0 then
        for i = 1, #dogs do
            local dog = dogs[i]
            DogMapping[dog] = StrikePlayers[i]
        end
    end
    for i = 1, #dogs do
        if not dogs[i].IsDead then
            local dog = dogs[i]
            Media.FloatingText(DogMapping[dog], dog.CenterPosition, 30, creeps.Color)
            dog.Hunt()
        end
    end
    if #dogs == 0 then
        local transports = creeps.GetActorsByType("lst.reinforcement")
        for i = 1, #transports do
            if not transports[i].IsDead then
                local transport = transports[i]
                Media.FloatingText(StrikePlayers[i], transport.CenterPosition, 30, creeps.Color)
            end
        end
    end

    local creeps2 = Player.GetPlayer("Creeps2")
    if not TTTPPP.IsDead then
        Media.FloatingText("TTTPPP", TTTPPP.CenterPosition, 30, creeps2.Color)
    end

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        DisplayOtherNames()
    end)
end

Decapture = function(captured)
    if not captured.IsDead then
        local reference = ""..captured.Location.X..","..captured.Location.Y
        if Captured[reference] ~= nil then
            captured.RevokeCondition(math.floor(""..Captured[reference]))
        end
    end
end

DisplayNames = function()
    for i = 1, #Survivors do
        local playerName = "Multi"..(i-1)
        local player = Player.GetPlayer(playerName)
        local engis = player.GetActorsByType("e6")
        if #engis > 0 then
            local engi = engis[1]
            local survivor = Survivors[i]
            InternalToSurvivorMap[playerName] = survivor
            engi.GrantCondition(survivor)

            Trigger.OnKilled(engi, function(engi)
                if not Ended then
                    Media.DisplayMessage(survivor.." is dead")
                    Eliminated[#Eliminated + 1] = survivor
                    -- Neutral buildings need decapturing to remove the label.
                    for j = 1, #Neutrals do
                        local neutral = Neutrals[i]
                        if neutral ~= nil and neutral.Owner == engi.Owner then
                            Decapture(neutral)
                            neutral.Owner = Player.GetPlayer("Neutral")
                        end
                    end
                    -- Other actors should hopefully die without us doing anything, but just in case.
                    local actors = Map.ActorsInWorld
                    for j = 1, #actors do
                        local actor = actors[j]
                        if actor.Owner == engi.Owner then
                            actor.Owner = Player.GetPlayer("Neutral")
                        end
                    end
                    engi.Owner.MarkFailedObjective(0)
                end
            end)
        end
    end
    DisplayOtherNames()

    Trigger.OnAnyProduction(function(producer, produced, productionType)
        local survivor = InternalToSurvivorMap[produced.Owner.InternalName]
        produced.GrantCondition(survivor)
    end)
    for i = 1, #Neutrals do
        Trigger.OnCapture(Neutrals[i], function(captured, captor, oldOwner, newOwner)
            Decapture(captured)
            local survivor = InternalToSurvivorMap[captured.Owner.InternalName]
            local reference = ""..captured.Location.X..","..captured.Location.Y
            Captured[reference] = captured.GrantCondition(survivor)
        end)
    end
end

CheckForEnded = function()
    local remaining = {}
    for i = 1, #Survivors do
        local internalName = "Multi"..(i-1)
        local player = Player.GetPlayer(internalName)
        local engis = player.GetActorsByType("e6")
        if #engis > 0 then
            remaining[#remaining + 1] = player
        end
    end
    if #remaining < 2 then
        Ended = true
        for i = 1, #remaining do
            local player = remaining[i]
            player.MarkCompletedObjective(0)
        end
        -- If there are no finishers then the survivor is the winner (if there is one).
        if #Finishers == 0 then
            for i = 1, #remaining do
                Finishers[i] = InternalToSurvivorMap[remaining[i].InternalName]
            end
        end
        if #Finishers == 0 then
            Finishers[1] = Eliminated[#Eliminated]
        end
        Media.DisplayMessage("***")
        Media.DisplayMessage("*** The prize winner is: "..Finishers[1])
        Media.DisplayMessage("***")
    else
        Trigger.AfterDelay(DateTime.Seconds(1), function()
            CheckForEnded()
        end)
    end
end

DisplayTimerMessages = function()
    for i = 1, TimeInterval do
        Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval - i), function()
            Media.DisplayMessage(""..(i))
        end)
    end
    Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval), function()
        Media.DisplayMessage("GO!")
        TechnicianPanic()
    end)
end

InitGameStages = function()
    -- First 2 Intervals are for game starting up.
    Trigger.AfterDelay(DateTime.Seconds(8 * TimeInterval), function()
        Media.DisplayMessage("Speed Upgrade Received!")
        Media.PlaySound("unitspd1.aud")
        GameStage = 1
        ForEachLivingEngi(function(engi)
            engi.GrantCondition("SpeedBoost")
        end)
    end)
    Trigger.AfterDelay(DateTime.Seconds(14 * TimeInterval), function()
        Media.DisplayMessage("Engineer Weapons Received!")
        Media.PlaySound("firepo1.aud")
        ForEachLivingEngi(function(engi)
            engi.GrantCondition("Armed")
            if Utils.RandomInteger(1, 10 + 1) < 4 then
                engi.Stop()
                engi.Hunt()
            end
        end)
        GameStage = 2
    end)
    Trigger.AfterDelay(DateTime.Seconds(20 * TimeInterval), function()
        Media.DisplayMessage("Enemy Weapons Upgraded!")
        Media.PlaySound("navalunitfirepower.wav")
        for i = 1, 3 do
            local shipName = "SHIP"..i
            local ship = Map.NamedActor(shipName)
            if ship ~= nil and not ship.IsDead then
                ship.GrantCondition("UPGRADE")
            end
        end
        GameStage = 3
    end)
    Trigger.AfterDelay(DateTime.Seconds(26 * TimeInterval), function()
        Media.DisplayMessage("Reinforcements Landing - Avoid the coast!")
        Media.PlaySound("sovfapp1.aud")
        local creeps = Player.GetPlayer("Creeps")
        Reinforcements.ReinforceWithTransport(creeps, "lst.reinforcement", {"dog"}, {SPAWN1.Location, LANDING1.Location}, {SPAWN1.Location})
        Reinforcements.ReinforceWithTransport(creeps, "lst.reinforcement", {"dog"}, {SPAWN2.Location, LANDING2.Location}, {SPAWN2.Location})
        Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval), function()
            GameStage = 4
        end)
    end)
end

MoveEngi = function(engi)
    local target = Utils.Random(Neutrals)
    if not target.IsDead and target.Owner ~= engi.Owner then
        engi.Capture(target)
    end
end

PlayerAction = function(engi)
    if GameStage <= 1 then
        -- Initial stage with no weapons.
        if not engi.IsDead then
            MoveEngi(engi)
        end
    elseif GameStage == 4 then
        -- Final stage where everyone goes to the middle.
        if not engi.IsDead then
            local target = CPos.New(39 - 3 + Utils.RandomInteger(1, 5), 38 - 3 + Utils.RandomInteger(1, 5))
            engi.Stance = "HoldFire"
            engi.Stop()
            engi.Move(target)
            Trigger.AfterDelay(DateTime.Seconds(1), function()
                if not engi.IsDead then
                    engi.Stance = "ReturnFire"
                    engi.Hunt()
                end
            end)
        end
    else
        if not engi.IsDead then
            local value = Utils.RandomInteger(1, 10 + 1)
            if value < 4 then
                engi.Hunt()
            else
                MoveEngi(engi)
            end
        end
    end
end

MoveShip = function(i)
    local shipName = "SHIP"..i
    local ship = Map.NamedActor(shipName)
    if ship ~= nil and not ship.IsDead then
        local target = Utils.RandomInteger(1, 5 + 1)
        ship.Move(WaypointCPos[i][target], 1)
    end
end

AvoidStoppedUnits = function()
    ForEachLivingEngi(function(engi)
        local position = engi.CenterPosition
        if position == CurrentPosition[engi] then
            engi.Stance = "HoldFire"
            engi.Stop()
            MoveEngi(engi)
            Trigger.AfterDelay(DateTime.Seconds(2), function()
                if not engi.IsDead then
                    engi.Stance = "ReturnFire"
                end
            end)
        else
            CurrentPosition[engi] = position
        end
    end)
    for i = 1, 3 do
        local shipName = "SHIP"..i
        local ship = Map.NamedActor(shipName)
        if ship ~= nil and not ship.IsDead then
            local position = ship.CenterPosition
            if position == CurrentPosition[shipName] then
                MoveShip(i)
            else
                CurrentPosition[shipName] = position
            end
        end
    end
    Trigger.AfterDelay(DateTime.Seconds(10), AvoidStoppedUnits)
end

MedicOrders = function(rax)
    Trigger.OnProduction(rax, function(producer, produced)
        local player = produced.Owner
        local engis = player.GetActorsByType("e6")
        if #engis > 0 then
            local engi = engis[1]
            if not engi.IsDead then
                produced.Guard(engi)
            end
        end
    end)
end

TechnicianPanic = function()
    if not TTTPPP.IsDead then
        TTTPPP.Stop()
        TTTPPP.Panic()
        Trigger.AfterDelay(DateTime.Seconds(TimeInterval), TechnicianPanic)
    end
end

WorldLoaded = function()
    Survivors = Utils.Shuffle(Survivors)

    DisplayNames()

    DisplayTimerMessages()

    InitGameStages()

    for i = 1, 3 do
        local ship = Map.NamedActor("SHIP"..i)
        ship.Stop()
        ship.Wait(DateTime.Seconds(2 * TimeInterval))
    end
    local waypointWPos = {}
    for i = 1, 3 do
        WaypointCPos[i] = {}
        waypointWPos[i] = {}
        for j = 1, 5 do
            WaypointCPos[i][j] = Map.NamedActor("W"..i..j).Location
            waypointWPos[i][j] = Map.CenterOfCell(WaypointCPos[i][j])
        end
    end
    for i = 1, 3 do
        for j = 1, 5 do
            Trigger.OnEnteredProximityTrigger(waypointWPos[i][j], WDist.FromCells(1), function(ship)
                if ship == Map.NamedActor("SHIP"..i) then
                    -- Pick a new target.
                    local newJ = (j + Utils.RandomInteger(1, 4 + 1)) % 5 + 1
                    ship.Move(WaypointCPos[i][newJ], 1)
                end
            end)
        end
    end
    Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval), function()
        ForEachLivingEngi(function(engi)
            PlayerAction(engi)
            Trigger.OnIdle(engi, function(engi)
                PlayerAction(engi)
            end)
        end)
        local actors = Map.ActorsInWorld
        for i = 1, 3 do
            local ship = Map.NamedActor("SHIP"..i)
            ship.Stance = "AttackAnything"
            MoveShip(i)
        end
        local creeps2 = Player.GetPlayer("Creeps2")
        TTTPPP.Owner = creeps2
        AvoidStoppedUnits()
    end)

    MedicOrders(RAX1)
    MedicOrders(RAX2)

    CheckForEnded()
end
