Survivors = {'Upps', 'MrCloudy', 'SinJul', 'KSK_Nico', 'anjew', 'Goremented', 'Sigil', 'Gajcus', 'Eugenator', 'Mo', 'worldpeace', 'Nilhall', 'Dodder', 'MRC', 'maceman', 'manta151', 'TiTo', 'Ekanim', 'DukeBones', 'DVoid', 'Therapist', 'TailixKM', 'potato'}
InternalToSurvivorMap = {}
Laps = 3
Lap = {}
LapCondition = {}
LastWaypoint = {}
Finishers = {}
Eliminated = {}
Crates = {"SINGLEHEALCRATE", "NUKECRATE", "FLAMECRATE", "SUPERSPDCRATE", "SPDCRATE", "SLWCRATE", "SPDCRATE", "SLWCRATE", "INVULNCRATE"}
Ended = false

DisplayOtherNames = function()
    local creeps = Player.GetPlayer("Creeps")
    if not SD1.IsDead then
        Media.FloatingText("goat", SD1.CenterPosition, 30, creeps.Color)
    end
    if not SD2.IsDead then
        Media.FloatingText("Kav", SD2.CenterPosition, 30, creeps.Color)
    end
    if not SD3.IsDead then
        Media.FloatingText("Pinkthoth", SD3.CenterPosition, 30, creeps.Color)
    end
    if not SD4.IsDead then
        Media.FloatingText("Kaution", SD4.CenterPosition, 30, creeps.Color)
    end

    local creeps2 = Player.GetPlayer("Creeps2")
    if not TTTPPP.IsDead then
        Media.FloatingText("TTTPPP", TTTPPP.CenterPosition, 30, creeps2.Color)
    end
    if not FiveAces.IsDead then
        Media.FloatingText("FiveAces", FiveAces.CenterPosition, 30, creeps2.Color)
    end

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        DisplayOtherNames()
    end)
end

DisplayNames = function()
    for i = 1, #Survivors do
        local playerName = "Multi"..(i-1)
        local player = Player.GetPlayer(playerName)
        local trucks = player.GetActorsByType("truk")
        if #trucks > 0 then
            local truck = trucks[1]
            local survivor = Survivors[i]
            InternalToSurvivorMap[playerName] = survivor
            truck.GrantCondition(survivor)

            Lap[playerName] = 0
            LastWaypoint[playerName] = 0
            LapCondition[playerName] = truck.GrantCondition("lap0")

            Trigger.OnPlayerLost(player, function(p)
                if not Ended then
                    Media.DisplayMessage(survivor.." is dead")
                    Eliminated[#Eliminated + 1] = survivor
                end
            end)
        end
    end
    DisplayOtherNames()
end

CheckForEnded = function()
    local remaining = {}
    for i = 1, #Survivors do
        local internalName = "Multi"..(i-1)
        local player = Player.GetPlayer(internalName)
        local trucks = player.GetActorsByType("truk")
        if #trucks > 0 then
            remaining[#remaining + 1] = player
        end
    end
    if #remaining <= #Finishers or #remaining == 1 then
        Ended = true
        for i = 1, #remaining do
            local player = remaining[i]
            player.MarkCompletedObjective(0)
        end
        -- If there are no finishers then the survivor is the winner (if there is one).
        if #Finishers == 0 then
            for i = 1, #remaining do
                Finishers[i] = InternalToSurvivorMap[remaining[i].InternalName]
            end
        end
        -- It's possible that some of the prize winners were actually killed.
        for i = 1, 3 - #Finishers do
            Finishers[#Finishers + 1] = Eliminated[#Eliminated - i + 1]
        end
        Media.DisplayMessage("***")
        Media.DisplayMessage("*** The prize winners are:")
        for i = 1, 3 do
            Media.DisplayMessage("*** "..i..": "..Finishers[i])
        end
        Media.DisplayMessage("***")
    else
        Trigger.AfterDelay(DateTime.Seconds(1), function()
            CheckForEnded()
        end)
    end
end

DisplayTimerMessages = function()
    for i = 1, 5 do
        Trigger.AfterDelay(DateTime.Seconds(10-i), function()
            Media.DisplayMessage(""..(i))
        end)
    end
    Trigger.AfterDelay(DateTime.Seconds(10), function()
        Media.DisplayMessage("GO!")
    end)
end

SpawnCrates = function(creeps2)
    local options = creeps2.GetActorsByTypes({"waypoint"})
    local spawnPoint = Utils.Random(options)
    Trigger.AfterDelay(DateTime.Seconds(2), function()
        local crate = Utils.Random(Crates)
        local actor = Actor.Create(crate, true, { Owner = Player.GetPlayer("Neutral"), Location = spawnPoint.Location })
        SpawnCrates(creeps2)
    end)
end

WorldLoaded = function()
    Survivors = Utils.Shuffle(Survivors)

    DisplayNames()

    DisplayTimerMessages()

    local neutral = Player.GetPlayer("Neutral")
    local waypointCPos = {}
    local waypointWPos = {}
    for j = 1, 4 do
        waypointCPos[j] = Map.NamedActor("Waypoint"..j).Location
        waypointWPos[j] = Map.CenterOfCell(waypointCPos[j])
    end
    for j = 1, 4 do
        Trigger.OnEnteredProximityTrigger(waypointWPos[j], WDist.FromCells(3), function(actor)
            if actor.Type == "truk" then
                actor.Move(waypointCPos[j%4+1], 1)
                local playerName = actor.Owner.InternalName
                if LastWaypoint[playerName]%4+1 == j then
                    LastWaypoint[playerName] = j
                    if j == 1 then
                        actor.RevokeCondition(LapCondition[playerName])
                        Lap[playerName] = Lap[playerName] + 1
                        if Lap[playerName] == Laps + 1 then
                            actor.Stop()
                            actor.Move(Map.NamedActor("Podeum").Location, 1)
                            local survivor = InternalToSurvivorMap[playerName]
                            Finishers[#Finishers+1] = survivor
                            Media.DisplayMessage(survivor.." has finished in position "..(#Finishers).."!")
                        else
                            LapCondition[playerName] = actor.GrantCondition("lap"..Lap[playerName])
                        end
                    end
                end
            end
        end)
    end
    Trigger.AfterDelay(DateTime.Seconds(10), function()
        local actors = Map.ActorsInWorld
        for i = 1, #actors do
            local actor = actors[i]
            if actor.Type == "truk" then
                actor.Move(waypointCPos[1], 1)
            end
        end
        local creeps = Player.GetPlayer("Creeps")
        SD1.Owner = creeps
        SD2.Owner = creeps
        SD3.Owner = creeps
        SD4.Owner = creeps
        local creeps2 = Player.GetPlayer("Creeps2")
        TTTPPP.Owner = creeps2
        SpawnCrates(creeps2)
    end)

    CheckForEnded()
end