CorrinoPath = { CorrinoRally2.Location, CorrinoRally4.Location }
CorrinoReinforcements =
{
	easy =
	{
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "quad", "quad", "trike" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "combat_tank_h", "trike" }
	},

	normal =
	{
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "combat_tank_h", "quad", "trike" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "combat_tank_h", "siege_tank" }
	},

	hard =
	{
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "combat_tank_h", "quad", "quad", "trike" },
		{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "combat_tank_h", "siege_tank" }
	}
}

CorrinoInitialAttackDelay =
{
	easy = DateTime.Minutes(1) + DateTime.Seconds(30),
	normal = DateTime.Minutes(1),
	hard = DateTime.Minutes(1)
}

CorrinoAttackDelay =
{
	easy = DateTime.Minutes(1) + DateTime.Seconds(30),
	normal = DateTime.Minutes(1),
	hard = DateTime.Minutes(1)
}

CorrinoPaths =
{
	{ CorrinoRally1.Location, CorrinoRally2.Location },
	{ CorrinoRally1.Location, CorrinoRally3.Location }
}

SendCorrinoReinforcements = function(Multi0, delay, unitTypes, entrypath, customCondition)
	Trigger.AfterDelay(delay, function()
		if customCondition and customCondition() then
			return
		end

		local units = Reinforcements.Reinforce(Multi0, unitTypes, entrypath)
		
		SendCorrinoReinforcements(Multi0, delay, unitTypes, entrypath, customCondition)
	end)
end

SendCorrinoWithReinforcements = function(Multi0, delay, path, unitTypes, customCondition)
	Trigger.AfterDelay(delay, function()
		if customCondition and customCondition() then
			return
		end

		local units = Reinforcements.ReinforceWithTransport(Multi0, "carryall.reinforce", unitTypes, path, { path[1] })[2]

		SendCorrinoWithReinforcements(Multi0, delay, path, unitTypes, customCondition)
	end)
end

Tick = function()
	if Multi0.HasNoRequiredUnits() or Multi1.HasNoRequiredUnits() then
		Multi2.MarkCompletedObjective(KillHarkonnen1)
		Multi3.MarkCompletedObjective(KillHarkonnen2)
		Multi4.MarkCompletedObjective(KillHarkonnen3)
		Multi0.MarkFailedObjective(KillHarkonnen1)
		Multi1.MarkFailedObjective(KillHarkonnen1)
	end
	if Multi2.HasNoRequiredUnits() and  Multi4.HasNoRequiredUnits() and not Multi0.IsObjectiveCompleted(KillAtreides) and not Multi1.IsObjectiveCompleted(KillAtreides2) then
		Media.DisplayMessage("Атрейдесы уничтожены!", "Ментат")
		Multi0.MarkCompletedObjective(KillAtreides)
		Multi1.MarkCompletedObjective(KillAtreides2)
	end
	if Multi3.HasNoRequiredUnits() and not Multi0.IsObjectiveCompleted(KillCorrino) and not Multi1.IsObjectiveCompleted(KillCorrino2) then
		Media.DisplayMessage("Император уничтожен!", "Ментат")
		Multi0.MarkCompletedObjective(KillCorrino)
		Multi1.MarkCompletedObjective(KillCorrino2)
	end
	
	if (AHiTechFactory.IsDead or AHiTechFactory.Owner ~= Multi2) and not HiTechIsDead then
		Media.DisplayMessage("Завод высоких технологий нейтрализован! Атрейдесы отрезаны от имперских подкреплений!", "Mentat")
		HiTechIsDead = true
	end
end

WorldLoaded = function()
	Multi0 = Player.GetPlayer("Multi0")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")

	InitObjectives(Multi0)
	KillAtreides = Multi0.AddPrimaryObjective("Уничтожтье Атрейдесов.")
	KillCorrino = Multi0.AddPrimaryObjective("Уничтожтье Императора.")
	KillAtreides2 = Multi1.AddPrimaryObjective("Уничтожтье Атрейдесов.")
	KillCorrino2 = Multi1.AddPrimaryObjective("Уничтожтье Императора.")
	KillHarkonnen1 = Multi2.AddPrimaryObjective("Уничтожтье Харконненов.")
	KillHarkonnen2 = Multi3.AddPrimaryObjective("Уничтожтье Харконненов.")
	KillHarkonnen3 = Multi2.AddPrimaryObjective("Уничтожтье Харконненов.")

	Media.DisplayMessage("Уничтожьте фабрику высоких технологий Атридесов, чтобы отрезать Атридесов от имперских подкреплений.", "Mentat")

	local corrinoWaveCondition = function() return Multi0.IsObjectiveCompleted(KillCorrino) or HiTechIsDead end
	
	SendCorrinoWithReinforcements(Multi3, CorrinoInitialAttackDelay[Difficulty], CorrinoPaths[1], CorrinoReinforcements[Difficulty][1], corrinoWaveCondition)
	SendCorrinoReinforcements(Multi3, CorrinoAttackDelay[Difficulty], CorrinoReinforcements[Difficulty][1], CorrinoPath, corrinoWaveCondition)
end
