Players = {}
ObjectiveIDs = {}

PlayerEliminated = function(player)
    Media.DisplayMessage("Game over: "..player.Name.." was eliminated")
    for i = 1, #Players do
        local otherPlayer = Players[i]
        Media.Debug("Checking player "..otherPlayer.Name.." "..otherPlayer.Spawn)
        if otherPlayer.Spawn ~= player.Spawn and not otherPlayer.HasNoRequiredUnits() then
            Media.Debug("Player "..otherPlayer.Name.." Marking objective "..ObjectiveIDs[i].." complete")
            otherPlayer.MarkCompletedObjective(ObjectiveIDs[i])
            -- Not sure why this is needed
            otherPlayer.MarkCompletedObjective(1)
        end
    end
end

-- Neutral and creep players have the spawn set to 0.
HasSpawn = function(player)
    return player.Spawn ~= 0
end

WorldLoaded = function()
    Players = Player.GetPlayers(HasSpawn)
    for i = 1, #Players do
        local player = Players[i]
        local objectiveID = player.AddObjective("Survive longer than one other player")
        ObjectiveIDs[i] = objectiveID
        Trigger.OnPlayerLost(player, PlayerEliminated)
    end
end
