players = {}

messages = function()
    Trigger.AfterDelay(DateTime.Seconds(3), function()
    Media.DisplayMessage ("According to the filters you set before mission start, some crates may not do anything.", "Mission", HSLColor.Red)
    Trigger.AfterDelay(DateTime.Seconds(12), function()
    Media.DisplayMessage ("This is because the units they were supposed to spawn can't spawn according to filters.", "Mission", HSLColor.Red)
    Trigger.AfterDelay(DateTime.Seconds(16), function()
    Media.DisplayMessage ("Don't forget to try out the defense structures! :)", "Mission", HSLColor.Red)
    Trigger.AfterDelay(DateTime.Seconds(20), function()
    Media.DisplayMessage ("Good luck and have fun!", "Mission", HSLColor.Red)
    end)
    end)
    end)
    end)
    end

WorldLoaded = function()
    InitializeGame()
    InitializeOptions()
    messages()
end

InitializeGame = function()
    local allActors = Map.ActorsInWorld
    local mcvs = {}
    local mcvLoop = 1
    for i = 1, #allActors do
        if allActors[i].Type == "mcv" then
            mcvs[mcvLoop] = allActors[i]
            mcvLoop = mcvLoop + 1
        end
    end
    for i = 1, #mcvs do
        players[i] = mcvs[i].EffectiveOwner
    end
end

InitializeOptions = function()
    if Map.LobbyOption("unitNumber") == "low" then
        for i = 1, #players do
            players[i].GrantCondition("low-tanks", 0)
        end
        --Media.DisplayMessage("Granted 'low-tanks' condition", Options, HSLColor.Red)
    elseif Map.LobbyOption("unitNumber") == "med" then
        for i = 1, #players do
            players[i].GrantCondition("low-tanks", 0)
            players[i].GrantCondition("med-tanks", 0)         
        end
        --Media.DisplayMessage("Granted 'med-tanks' condition", Options, HSLColor.Red)
    elseif Map.LobbyOption("unitNumber") == "hig" then
        for i = 1, #players do
            players[i].GrantCondition("low-tanks", 0)
            players[i].GrantCondition("med-tanks", 0)
            players[i].GrantCondition("hig-tanks", 0)
        end
        --Media.DisplayMessage("Granted 'hig-tanks' condition", Options, HSLColor.Red)
    end

    if Map.LobbyOption("unitLevel") == "low" then
        for i = 1, #players do
            players[i].GrantCondition("low-unit", 0)
        end
        --Media.DisplayMessage("Granted 'low-unit' condition", Options, HSLColor.Red)
    elseif Map.LobbyOption("unitLevel") == "med" then
        for i = 1, #players do
            players[i].GrantCondition("low-unit", 0)
            players[i].GrantCondition("med-unit", 0)         
        end
       --Media.DisplayMessage("Granted 'med-unit' condition", Options, HSLColor.Red)
    elseif Map.LobbyOption("unitLevel") == "hig" then
        for i = 1, #players do
            players[i].GrantCondition("low-unit", 0)
            players[i].GrantCondition("med-unit", 0)
            players[i].GrantCondition("hig-unit", 0)
        end
       --Media.DisplayMessage("Granted 'hig-unit' condition", Options, HSLColor.Red)
    end
end