players = {}
wfSpawns = {}
plrSpawns = {}
livesConditions = {}
playersLives = {}
numLives = 0
isStoreOn = false

Tick = function()
	for i = 1, #players  do
		local units = players[i].GetActors()
		local x = 4
		while x <= #units do
			if units[x].Type ~= "jeep2" and units[x].Type ~= "minv" and units[x].Type ~= "weap" and units[x].Type ~= "fjeep2" then
				units[x].Teleport(gotohere.Location)
			end
			x = x + 1
		end
	end
end

InitializeGame = function()
	local allActors = Map.ActorsInWorld
	local mcvs = {}
	local mcvLoop = 1
	for i = 1, #allActors do
		if allActors[i].Type == "mcv" then
			mcvs[mcvLoop] = allActors[i]
			mcvLoop = mcvLoop + 1
		end
	end
	for i = 1, #mcvs do
		players[i] = mcvs[i].EffectiveOwner
	end
	wfSpawns[1] = pl1wf
	wfSpawns[2] = pl2wf
	wfSpawns[3] = pl3wf
	wfSpawns[4] = pl4wf
	wfSpawns[5] = pl5wf
	wfSpawns[6] = pl6wf
	plrSpawns[1] = spwn1
	plrSpawns[2] = spwn2
	plrSpawns[3] = spwn3
	plrSpawns[4] = spwn4
	plrSpawns[5] = spwn5
	plrSpawns[6] = spwn6
	for i = 1, 20 do
		livesConditions[i] = "livescntr" .. i
	end
end

InitializePlayers = function()
	for i = 1, #players do
		playersLives[i] = numLives
		local actor = Actor.Create("weap", true, { Owner = players[i], Location = wfSpawns[i].Location })
		local plrMcv = players[i].GetActorsByType("mcv")[1]
		actor = Actor.Create("jeep2", true, { Owner = players[i], Location = plrMcv.Location})
		actor.GrantCondition(livesConditions[numLives], 0)
		if isStoreOn == false then
			actor.GrantCondition("nobounty", 0)
		end
		plrMcv.Destroy()
		Trigger.OnKilled(actor, function ()
			SpawnNewJeep(i)
		end)
	end
end

InitializeStore = function()
	if Map.LobbyOption("shopAndBounties") == "on" then
		isStoreOn = true
		for i = 1, #players do
			players[i].GrantCondition("storeOn", 0)
		end
	else
		return
	end
end

SetScoreboard = function()
	local emptyLines = 0
	local loop = 0
	local text1 = ""
	local plrNameLen = 0
	for i = 1, #players do
		loop = loop + 1
		if loop >= 2 then
			loop = 0
			emptyLines = emptyLines + 1
		end
	end
	while emptyLines > 0 do
		text1 = text1 .. "\n"
		emptyLines = emptyLines - 1
	end
	text1 = text1 .. "Player:                               Lives | Kills\n"
	for i = 1, #players do
		plrNameLen = string.len(players[i].Name)
		text1 = text1 .. players[i].Name .. ":"
		while plrNameLen <= 40 do
			text1 = text1 .. " "
			plrNameLen = plrNameLen + 1
		end
		text1 = text1 .. " "
		text1 = text1 .. playersLives[i] .. " | " .. players[i].UnitsKilled .. "\n"
	end
	UserInterface.SetMissionText(text1, HSLColor.White)
end

SpawnNewJeep = function(playerNum)
	DestroyAllPowersAndMines(players[playerNum])
	local doISpawn = false
	doIspawn = UpdateLives(playerNum)
	if doIspawn == true then
		local spawnPoint = FindSafeSpawn()
		local newJeep = Actor.Create("jeep2", true, { Owner = players[playerNum], Location = spawnPoint.Location})
		if isStoreOn == false then
			newJeep.GrantCondition("nobounty", 0)
		end
		newJeep.GrantCondition(livesConditions[playersLives[playerNum]], 0)
		if players[playerNum].IsLocalPlayer then
			Camera.Position = newJeep.CenterPosition
		end
		Trigger.OnKilled(newJeep, function ()
			SpawnNewJeep(playerNum)
		end)
	end
end

FindSafeSpawn = function()
	local jeepsInVicinity = {}
	local safeSpawns = {}
	local minJeeps = 1000
	local safeSpawnNum = 1
	local safeSpawnTracker = 1
	local safeSpawn = gotohere
	for i = 1, #plrSpawns do
		jeepsInVicinity = Map.ActorsInCircle(plrSpawns[i].CenterPosition, WDist.New(6144), IsJeep)
		if #jeepsInVicinity <= minJeeps then
			safeSpawnNum = i
			if #jeepsInVicinity == minJeeps then
				safeSpawns[safeSpawnTracker] = plrSpawns[i]
				safeSpawnTracker = safeSpawnTracker + 1
			end
			minJeeps = #jeepsInVicinity
		end
	end
	safeSpawn = plrSpawns[safeSpawnNum]
	if #safeSpawns > 1 then
		local randomSpawn = Utils.RandomInteger(1, #safeSpawns)
		safeSpawn = safeSpawns[randomSpawn]
	end
	return safeSpawn
end

IsJeep = function(actor)
	return actor.Type == "jeep2"
end

UpdateLives = function(playerNum)
	playersLives[playerNum] = playersLives[playerNum] - 1
	Media.DisplayMessage(players[playerNum].Name .. " has " .. playersLives[playerNum] .. " lives.")
	Trigger.AfterDelay(1, function()
		SetScoreboard()
	end)
	if playersLives[playerNum] > 0 then
		return true
	else
		players[playerNum].GetActorsByType("weap")[1].Destroy()
		return false
	end
end

DestroyAllPowersAndMines = function(player)
	local plractors = player.GetActors()
	local looper = #plractors
	while looper > 2 do
		if plractors[looper].Type ~= "weap" then
			plractors[looper].Destroy()
		end
		looper = looper - 1
	end
end

WorldLoaded = function()
	if Map.LobbyOption("livesID") == "a" then
		numLives = 1
	elseif Map.LobbyOption("livesID") == "g" then
		numLives = 3
	elseif Map.LobbyOption("livesID") == "b" then
		numLives = 5
	elseif Map.LobbyOption("livesID") == "c" then
		numLives = 10
	elseif Map.LobbyOption("livesID") == "d" then
		numLives = 15
	elseif Map.LobbyOption("livesID") == "e" then
		numLives = 20
	end
	-- Needed for doppelgänger, gives the life count to it
	Trigger.OnAnyProduction(function(producer, produced, productionType) 
		if producer.Type == "jeep2" then
			for i = 1, #players do
				if producer.EffectiveOwner == players[i] then
					produced.GrantCondition(livesConditions[playersLives[i]], 0)
					produced.Health = producer.Health
					producer.Flash(10)
					produced.Flash(10)
				end
			end
		end
	end)
	InitializeGame()
	InitializePlayers()
	InitializeStore()
	SetScoreboard()
end