players = {}
wfSpawns = {}
plrSpawns = {}
livesConditions = {}
playersLives = {}
numLives = 0

Tick = function()
	for i = 1, #players  do
		local units = players[i].GetActors()
		local x = 4
		while x <= #units do
			if units[x].Type ~= "jeep2" then
				if units[x].Type ~= "minv" then
					units[x].Teleport(gotohere.Location)
				end
			end
			x = x + 1
		end
	end
end

InitializeGame = function()
	players[1] = Player.GetPlayer("Multi0")
	players[2] = Player.GetPlayer("Multi1")
	players[3] = Player.GetPlayer("Multi2")
	players[4] = Player.GetPlayer("Multi3")
	players[5] = Player.GetPlayer("Multi4")
	players[6] = Player.GetPlayer("Multi5")
	wfSpawns[1] = pl1wf
	wfSpawns[2] = pl2wf
	wfSpawns[3] = pl3wf
	wfSpawns[4] = pl4wf
	wfSpawns[5] = pl5wf
	wfSpawns[6] = pl6wf
	plrSpawns[1] = spwn1
	plrSpawns[2] = spwn2
	plrSpawns[3] = spwn3
	plrSpawns[4] = spwn4
	plrSpawns[5] = spwn5
	plrSpawns[6] = spwn6
	livesConditions[1] = "livescntr1"
	livesConditions[2] = "livescntr2"
	livesConditions[3] = "livescntr3"
	livesConditions[4] = "livescntr4"
	livesConditions[5] = "livescntr5"
	livesConditions[6] = "livescntr6"
	livesConditions[7] = "livescntr7"
	livesConditions[8] = "livescntr8"
	livesConditions[9] = "livescntr9"
	livesConditions[10] = "livescntr10"
	livesConditions[11] = "livescntr11"
	livesConditions[12] = "livescntr12"
	livesConditions[13] = "livescntr13"
	livesConditions[14] = "livescntr14"
	livesConditions[15] = "livescntr15"
	livesConditions[16] = "livescntr16"
	livesConditions[17] = "livescntr17"
	livesConditions[18] = "livescntr18"
	livesConditions[19] = "livescntr19"
	livesConditions[20] = "livescntr20"
end

InitializePlayers = function()
	for i = 1, #players do
		playersLives[i] = numLives
		local actor = Actor.Create("weap", true, { Owner = players[i], Location = wfSpawns[i].Location })
		local plrMcv = players[i].GetActorsByType("mcv")[1]
		actor = Actor.Create("jeep2", true, { Owner = players[i], Location = plrMcv.Location})
		actor.GrantCondition(livesConditions[numLives], 0)
		plrMcv.Destroy()
		Trigger.OnKilled(actor, function ()
			SpawnNewJeep(i)
		end)
	end
end

SpawnNewJeep = function(playerNum)
	DestroyAllPowersAndMines(players[playerNum])
	local doISpawn = false
	doIspawn = UpdateLives(playerNum)
	if doIspawn == true then
		local spawnPoint = FindSafeSpawn()
		local newJeep = Actor.Create("jeep2", true, { Owner = players[playerNum], Location = spawnPoint.Location})
		newJeep.GrantCondition(livesConditions[playersLives[playerNum]], 0)
		Trigger.OnKilled(newJeep, function ()
			SpawnNewJeep(playerNum)
		end)
	end
end

FindSafeSpawn = function()
	local jeepsInVicinity = {}
	local safeSpawns = {}
	local minJeeps = 1000
	local safeSpawnNum = 1
	local safeSpawnTracker = 1
	local safeSpawn = gotohere
	for i = 1, #plrSpawns do
		jeepsInVicinity = Map.ActorsInCircle(plrSpawns[i].CenterPosition, WDist.New(6144), IsJeep)
		if #jeepsInVicinity <= minJeeps then
			safeSpawnNum = i
			if #jeepsInVicinity == minJeeps then
				safeSpawns[safeSpawnTracker] = plrSpawns[i]
				safeSpawnTracker = safeSpawnTracker + 1
			end
			minJeeps = #jeepsInVicinity
		end
	end
	safeSpawn = plrSpawns[safeSpawnNum]
	if #safeSpawns > 1 then
		local randomSpawn = Utils.RandomInteger(1, #safeSpawns)
		safeSpawn = safeSpawns[randomSpawn]
	end
	return safeSpawn
end

IsJeep = function(actor)
	return actor.Type == "jeep2"
end

UpdateLives = function(playerNum)
	playersLives[playerNum] = playersLives[playerNum] - 1
	if playersLives[playerNum] > 0 then
		return true
	else
		players[playerNum].GetActorsByType("weap")[1].Destroy()
		return false
	end
end

DestroyAllPowersAndMines = function(player)
	local plractors = player.GetActors()
	local looper = #plractors
	while looper > 2 do
		plractors[looper].Destroy()
		looper = looper - 1
	end
end

WorldLoaded = function()
	if Map.LobbyOption("livesID") == "a" then
		numLives = 1
	elseif Map.LobbyOption("livesID") == "g" then
		numLives = 3
	elseif Map.LobbyOption("livesID") == "b" then
		numLives = 5
	elseif Map.LobbyOption("livesID") == "c" then
		numLives = 10
	elseif Map.LobbyOption("livesID") == "d" then
		numLives = 15
	elseif Map.LobbyOption("livesID") == "e" then
		numLives = 20
	end
	InitializeGame()
	InitializePlayers()
end