SetCamera = function(player)
	local mcv = player.GetActorsByType("mcv")[1]
	Camera.Position = mcv.CenterPosition
end

ResetRadar = function(house, waypoint)
    local actor = Actor.Create("tenspy", true, { Owner = Player.GetPlayer("Creeps"), Location = waypoint.Location })
    Trigger.OnIdle(actor, function(actor)
        actor.Infiltrate(house)
    end)
end

DestroySomeBuildings = function()
    TenA.Kill()
    TenB.Kill()
    TenC.Kill()
    TenD.Kill()
end

WorldLoaded = function()
    Trigger.OnKilledOrCaptured(TenebrisDevice, function()
        ResetRadar(HouseA, WaypointA)
		DestroySomeBuildings()
    end)
    
    Trigger.OnKilledOrCaptured(TenebrisDevice, function()
        ResetRadar(HouseB, WaypointB)
    end)
	
	local player0 = Player.GetPlayer("Multi0")
	local player1 = Player.GetPlayer("Multi1")

	if player0.IsLocalPlayer then
		SetCamera(player0)
	elseif player1.IsLocalPlayer then
		SetCamera(player1)
	end
end