
local distance_to_flag = 2048
local check_interval_ticks = 25
local points_per_interval = 1
local target_points = 2500

local flags
local neutral
local teams = {}
local players = {}
local in_play = false
local unset_team = -1

function WorldLoaded()
	neutral = Player.GetPlayer('Neutral')
	flags = neutral.GetActorsByType('ctflag')
	
	for j,player in pairs(Player.GetPlayers(nil)) do
		if not player.IsNonCombatant then
			local team = player.Team
			if team == 0 then
				team = unset_team
				unset_team = unset_team -1
			end
			if not teams[team] then
				teams[team] = {
					player.InternalName
				}
			else
				teams[team][#teams[team] + 1] = player.InternalName
			end
			players[player.InternalName] = {
				points = 0,
				object = player,
				objective = player.AddPrimaryObjective("Get " .. target_points .. " points or destroy all enemy forces."),
				alive = true
			}
		end
	end
	in_play = true
end

function GetFlagHolder(flag)
	local owner = nil
	for j,actor in pairs(Map.ActorsInCircle(flag.CenterPosition, WDist.New(distance_to_flag))) do
		if not actor.Owner.IsNonCombatant and actor ~= flag then
			if owner == nil then
				owner = actor.Owner
			elseif actor.Owner ~= owner then
				owner = nil
				break
			end
		end
	end
	return owner
end

function EachInterval()
	local buffer = "Flags: "
	local first = true
	for i,flag in pairs(flags) do
		local holder = GetFlagHolder(flag)
		local name
		if holder ~= nil then
			flag.Owner = holder
			name = holder.Name
			players[holder.InternalName].points = players[holder.InternalName].points + points_per_interval
		else
			name = 'Neutral'
			flag.Owner = neutral
		end
		if first then
			first = false
		else
			buffer = buffer .. ' | '
		end
		buffer = buffer .. name
	end
	local winner = nil
	local teams_still_in = 0
	buffer = buffer .. "\n\nFirst to " .. target_points
	for i,team in pairs(teams) do
		local points = 0
		local name = ''
		local first = true
		local alive = false
		for j,player_name in pairs(team) do
			if first then
				first = false
			else
				name = name .. "/"
			end
			local player = players[player_name]
			name = name .. player.object.Name
			points = points + player.points
			if player.object.HasNoRequiredUnits() then
				player.alive = false
			elseif player.alive == true then
				alive = true
			end
		end
		if points >= target_points then
			winner = i
		end
		if alive then
			teams_still_in = teams_still_in + 1
		end
		buffer = buffer .. " | " .. name .. ": " .. points
	end
	UserInterface.SetMissionText(buffer)
	if teams_still_in <= 1 then
		for i,player in pairs(players) do
			if player.alive then
				player.object.MarkCompletedObjective(player.objective)
			end
		end
	end
	if winner ~= nil then
		for i,team in pairs(teams) do
			for j,player_name in pairs(team) do
				local player = players[player_name]
				if i == winner then
					player.object.MarkCompletedObjective(player.objective)
				else
					player.object.MarkFailedObjective(player.objective)
				end
			end
		end
		in_play = false
	end
end

Tick = function()
	if in_play and DateTime.GameTime % check_interval_ticks == 0 then
		EachInterval()
	end
end