Survivors = {"anjew", "Blackened", "KSKNico", "FiveAces", "Sigil", "Mo", "Eugenator", "TiTo", "SlickSloth", "DukeBones", "spetsnaz", "TTTPPP", "MRC", "Pinkthoth", "Ekanim", "KernelPanic", "Kaution", "Oafa", "Nilhall"}
Ended = false

DisplayTankNames = function()
    Media.FloatingText("goat", MammothTank.CenterPosition, 30, MammothTank.Owner.Color)
    Media.FloatingText("Mr Cloudy", HeavyTank.CenterPosition, 30, MammothTank.Owner.Color)
    Media.FloatingText("Upps", MediumTank.CenterPosition, 30, MammothTank.Owner.Color)
    Media.FloatingText("Goremented", LightTank.CenterPosition, 30, MammothTank.Owner.Color)

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        DisplayTankNames()
    end)
end

DisplayNames = function()
    for i = 1, #Survivors do
        local player = Player.GetPlayer("Multi"..(i-1))
        local technicians = player.GetActorsByType("tecn")
        if #technicians > 0 then
            local technician = technicians[1]
            local survivor = Survivors[i]
            technician.GrantCondition(survivor)
            
            Trigger.OnPlayerLost(player, function(p)
                if not Ended then
                    Media.DisplayMessage(survivor.." is dead")
                end
            end)
        end
    end
    DisplayTankNames()
end

CheckForWinner = function()
    local remaining = {}
    for i = 1, #Survivors do
        local player = Player.GetPlayer("Multi"..(i-1))
        local technicians = player.GetActorsByType("tecn")
        if #technicians > 0 then
            remaining[#remaining + 1] = Survivors[i]
        end
    end
    if #remaining < 2 then
        Ended = true
        if #remaining == 1 then
            Media.DisplayMessage(remaining[1].." wins!")
        else
            Media.DisplayMessage("No one survived - rematch required!")
        end
    else
        Trigger.AfterDelay(DateTime.Seconds(1), function()
            CheckForWinner()
        end)
    end
end

DisplayTimerMessages = function()
    for i = 1, 5 do
        Trigger.AfterDelay(DateTime.Seconds(10-i), function()
            Media.DisplayMessage(""..(i))
        end)
    end
    Trigger.AfterDelay(DateTime.Seconds(10), function()
        Media.DisplayMessage("FIGHT!")
    end)
end

WorldLoaded = function()
    Survivors = Utils.Shuffle(Survivors)

    DisplayNames()

    DisplayTimerMessages()

    Trigger.AfterDelay(DateTime.Seconds(10), function()
        local actors = Map.ActorsInWorld
        for i = 1, #actors do
            local actor = actors[i]
            if actor.Type == "brik" then
                actor.Destroy()
            end
        end
        local creeps = Player.GetPlayer("Creeps")
        LightTank.Owner = creeps
        MediumTank.Owner = creeps
        HeavyTank.Owner = creeps
        MammothTank.Owner = creeps
    end)

    CheckForWinner()
end