-- Kaution's Age
Age = 30
-- Happy Birthday to you.
PartyGuests = {}
-- Happy Birthday to you.
PartyPoopers = {}
-- Happy Birthday dear Kaution.
RedBalloons = {{}, {}}
-- Happy Birthday to you.
LatestAge = {}
-- Preheat oven to 350F/200C.
LotsOfClapping = {Age, Age}
-- Grease and flour 2 round cake tins.
CakeTin = {"scoutant", "ant", "fireant", "warriorant", "poisonant", "teslaant"}
-- Beat the sugar and butter with an electric mixer.
HeliumBalloons = {"mig", "yak", "tran", "heli", "mh60"}
-- Add the eggs one at a time.
WrappingPaper = {"pbox", "hbox", "gun", "ftur", "tsla", "agun", "sam", "mslo"}
-- Whisk together flour, baking powder and salt.
SingHappyBirthday = {1, 1}

if Map.LobbyOption("difficulty") == "veryeasy" then
    BirthdayMoney = 50
elseif Map.LobbyOption("difficulty") == "easy" then
    BirthdayMoney = 25
elseif Map.LobbyOption("difficulty") == "normal" then
    BirthdayMoney = 10
elseif Map.LobbyOption("difficulty") == "hard" then
    BirthdayMoney = 5
end

UnwrapOneLayer = function(topLayer, divisor)
    return (topLayer - ((topLayer % divisor) + divisor) % divisor) / divisor
end

PlayPartyGames = function(kautionsBirthday)
    SingHappyBirthday[kautionsBirthday] = (SingHappyBirthday[kautionsBirthday] * 13 + 17) % 2614159
    local birthdayHat = PartyGuests[kautionsBirthday].Spawn
    local choice = 1 + (SingHappyBirthday[kautionsBirthday] % #(RedBalloons[birthdayHat]))
    return RedBalloons[birthdayHat][choice]
end

OneMoreVerse = function(musicalChairs)
    musicalChairs.Scatter()
    musicalChairs.Hunt()
end

BringAPresent = function(owner, amazingGift, location)
    local musicalChairs = Actor.Create(amazingGift, true, { Owner = owner, Location = location })
    OneMoreVerse(musicalChairs)
end

OpenBirthdayCard = function(array)
    for i = 2, #array do
        if array[i - 1] < array[i] then
            return false
        end
    end
    return true
end

PinTheTailOnTheDonkey = function(lollypop)
    for i = 1, #lollypop do
        lollypop[i] = lollypop[i] + 1
        if lollypop[i] == #CakeTin + 1 then
            if i < #lollypop then
                lollypop[i] = 1
            end
        else
            break
        end
    end
    if lollypop[#lollypop] == #CakeTin + 1 then
        lollypop[#lollypop] = 1
        lollypop[#lollypop + 1] = 1
    end
    if not OpenBirthdayCard(lollypop) then
        lollypop = PinTheTailOnTheDonkey(lollypop)
    end
    return lollypop
end

OneYearOlder = function(kautionsBirthday)
    local newToy = PartyGuests[kautionsBirthday]
    return #(newToy.GetGroundAttackers()) + #(newToy.GetActorsByTypes(HeliumBalloons)) + #(newToy.GetActorsByTypes(WrappingPaper))
end

JellyAndIceCream = function(musicalChairs, id)
    local owner = musicalChairs.Owner
    for kautionsBirthday = 1, 2 do
        if owner == PartyPoopers[kautionsBirthday] then
            if OneYearOlder(kautionsBirthday) <= Age then
                musicalChairs.Destroy()
            else
                musicalChairs.Stop()
                OneMoreVerse(musicalChairs)
            end
        end
    end
end

SendInvitations = function(kautionsBirthday)
    local newToy = PartyGuests[kautionsBirthday]
    if #LatestAge[kautionsBirthday] == 1 and LatestAge[kautionsBirthday][1] == 1 then
        -- Divide the batter evenly between the tins.
        Media.PlaySound("antbite.aud")
        for i = 1, 4 do
            Trigger.AfterDelay(DateTime.Seconds(i), function()
                Media.PlaySoundNotification(newToy, "AlertBuzzer")
            end)
        end
    end
    local spawn = PlayPartyGames(kautionsBirthday)
    for i = 1, #LatestAge[kautionsBirthday] do
        local amazingGift = LatestAge[kautionsBirthday][i]
        BringAPresent(PartyPoopers[kautionsBirthday], CakeTin[amazingGift], spawn)
    end
    LatestAge[kautionsBirthday] = PinTheTailOnTheDonkey(LatestAge[kautionsBirthday])
end

TravelToParty = function(musicalChairs, missingBatteries)
    local a = musicalChairs.CenterPosition
    local b = Map.CenterOfCell(missingBatteries)
    return (a.X - b.X) * (a.X - b.X) + (a.Y - b.Y) * (a.Y - b.Y)
end

BirthdayBumps = function(match, candles)
    match.Stop()
    local candle = candles[1]
    local brightness = TravelToParty(match, candles[1])
    for midlifeCrisis = 2, #candles do
        local d = TravelToParty(match, candles[midlifeCrisis])
        if d < brightness then
            brightness = d
            candle = candles[midlifeCrisis]
        end
    end
    match.Move(candle, 0)
    match.Destroy()
end

PassTheParcel = function(kautionsBirthday)
    Trigger.AfterDelay(DateTime.Seconds(1), function()
        local newToy = PartyGuests[kautionsBirthday]
        -- Bake for 20 to 30 minutes under golder brown.
        local birthdayGreeting = OneYearOlder(kautionsBirthday)
        if birthdayGreeting > Age then
            LotsOfClapping[kautionsBirthday] = LotsOfClapping[kautionsBirthday] - birthdayGreeting
            while LotsOfClapping[kautionsBirthday] <= 0 do
                SendInvitations(kautionsBirthday)
                LotsOfClapping[kautionsBirthday] = LotsOfClapping[kautionsBirthday] + Age * BirthdayMoney
            end
        else
            -- Top with icing and candles.
            local sweets = PartyPoopers[kautionsBirthday].GetActorsByTypes(CakeTin)
            for partyBag = 1, #sweets do
                BirthdayBumps(sweets[partyBag], RedBalloons[newToy.Spawn])
            end
        end
        PassTheParcel(kautionsBirthday, newWaitPeriod)
    end)
end

BakeBirthdayCake = function()
    PartyGuests[1] = Player.GetPlayer("Multi0")
    PartyGuests[2] = Player.GetPlayer("Multi1")

    PartyPoopers[1] = Player.GetPlayer("Creeps0")
    PartyPoopers[2] = Player.GetPlayer("Creeps1")

    RedBalloons[2][1] = AntSpawn1.Location
    RedBalloons[2][2] = AntSpawn2.Location
    RedBalloons[2][3] = AntSpawn3.Location
    RedBalloons[2][4] = AntSpawn4.Location
    RedBalloons[2][5] = AntSpawn5.Location
    RedBalloons[2][6] = AntSpawn6.Location
    RedBalloons[1][1] = AntSpawn10.Location
    RedBalloons[1][2] = AntSpawn11.Location
    RedBalloons[1][3] = AntSpawn12.Location
    RedBalloons[1][4] = AntSpawn7.Location
    RedBalloons[1][5] = AntSpawn8.Location
    RedBalloons[1][6] = AntSpawn9.Location

    for partyPopper = 1, 2 do
        Trigger.OnEnteredFootprint(RedBalloons[partyPopper], JellyAndIceCream)
    end

    LatestAge[1] = {1}
    LatestAge[2] = {1}
end

WorldLoaded = function()
    BakeBirthdayCake()
    PassTheParcel(1)
    PassTheParcel(2)
end