Season = Map.LobbyOption("season")
Red = HSLColor.Red
RedLight = 1
BlueLight = 1
GreenLight = 1
AlertStarts = false
AlreadyAlert = false
RedCounter = 0
Warningalert = function()
	Lighting.Blue = BlueLight
	Lighting.Green = GreenLight
	if not AlertStarts then
		GettingRed = true
		Media.PlaySoundNotification( allplayers, "AlertBuzzer")
	end
	if BlueLight >= 0.35 and GettingRed then
		AlertStarts = true
		BlueLight = BlueLight - 0.05
		GreenLight = GreenLight - 0.05
		RedCounter = RedCounter + 1
		Trigger.AfterDelay(1, function()
			Warningalert()
		end)
	elseif RedCounter >= 1 then
		BlueLight = BlueLight + 0.05
		GreenLight = GreenLight + 0.05
		GettingRed = false
		RedCounter = RedCounter - 1
		Trigger.AfterDelay(1, function()
			Warningalert()
		end)
	end
end



--																 Weatherfunctions

InitialiseWeather = function()
	if Season == "spring" then
		Month = 3
		Light = 0.91
		RedLight = 0.95
		GreenLight = 1.07
		BlueLight = 1.07
	elseif Season == "summer" then
		Month = 6
		Light = 0.93
		RedLight = 1.09
		GreenLight = 0.94
		BlueLight = 0.97
	elseif Season == "fall" or Season == "defmode" then
		Month = 9
		Light = 0.89
		RedLight = 1.05
		GreenLight = 0.93
		BlueLight = 1.04
	elseif Season == "winter"then
		StartingWinter()
		Month = 12
		Light = 0.88
		RedLight = 1.03
		GreenLight = 1.07
		BlueLight = 1.08
	end
	ColorChangeSpeed = 28
	MonthConditions()
	ColorChanger()
	if Month > 7 then
		turnOff()
	else
		turnOn()
	end
end
Season = Map.LobbyOption("season")
RateOfIncrease = 0.001

AllTrees = {"t03", "t10", "t11", "t12", "t13", "t14", "t15", "t17", "tc02", "tc05"}
AllNeedleTrees = {"t01", "t02", "t05", "t06", "t07", "t08", "t16", "tc01", "tc03", "tc04"}
AllBuildings = {"v01", "v02", "v03", "v04", "v05", "v06", "v07", "v08", "v09", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18"}
AllTNumbers = {"01", "02", "03", "04", "05", "06", "07", "08", "10", "11", "12", "13", "14", "15", "16", "17", "18"}
AllTCNumbers = {"01", "02", "03", "04", "05"}
AllVNumbers = {"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18"}
AllWinterStufft = {"t01winter", "t02winter", "t03winter", "t05winter", "t06winter", "t07winter", "t08winter", "t10winter", "t11winter", "t12winter", "t13winter", "t14winter", "t15winter", "t16winter", "t17winter"}
AllWinterStufftc = {"tc01winter", "tc02winter", "tc03winter", "tc04winter", "tc05winter"}
AllWinterStuffv = {"v01winter", "v02winter", "v03winter", "v04winter", "v05winter", "v06winter", "v07winter", "v08winter", "v09winter", "v10winter", "v11winter", "v12winter", "v13winter", "v14winter", "v15winter", "v16winter", "v17winter", "v18winter"}

AprilTrees = function()
	for i=1,#AllTrees do
		if i ~= nil then
			local Trees = Neutral.GetActorsByType(AllTrees[i])
			for p,tree in pairs(Trees) do
				Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 210)), function()
					if not tree.IsDead and tree.IsInWorld and tree.HasProperty("GrantCondition") and tree.AcceptsCondition("spring2") then
						tree.GrantCondition("spring2", 0)
					end
				end)
			end
		end
	end
end

MaiTrees = function()
	for i=1,#AllTrees do
		if i ~= nil then
			local Trees = Neutral.GetActorsByType(AllTrees[i])
			for p,tree in pairs(Trees) do
				Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 380)), function()
					if not tree.IsDead and tree.IsInWorld and tree.HasProperty("GrantCondition") and tree.AcceptsCondition("summer") then
						tree.GrantCondition("summer", 0)
					end
				end)
			end
		end
	end
end

SeptemberTrees = function()
	for i=1,#AllTrees do
		if i ~= nil then
			local Trees = Neutral.GetActorsByType(AllTrees[i])
			for p,tree in pairs(Trees) do
				Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 290)), function()
					if not tree.IsDead and tree.IsInWorld and tree.HasProperty("GrantCondition") and tree.AcceptsCondition("fall") then
						tree.GrantCondition("fall", 0)
					end
				end)
			end
		end
	end
end

OktoberTrees = function()
	for i=1,#AllTrees do
		if i ~= nil then
			local Trees = Neutral.GetActorsByType(AllTrees[i])
			for p,tree in pairs(Trees) do
				Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 320)), function()
					if not tree.IsDead and tree.IsInWorld and tree.HasProperty("GrantCondition") and tree.AcceptsCondition("fall2") then
						tree.GrantCondition("fall2", 0)
					end
				end)
			end
		end
	end
end

NovemberTrees = function()
	for i=1,#AllTrees do
		if i ~= nil then
			local Trees = Neutral.GetActorsByType(AllTrees[i])
			for p,tree in pairs(Trees) do
				Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 30)), function()
					if not tree.IsDead and tree.IsInWorld then
						Newtree = Actor.Create(tree.Type .. "winter" , true, { Location = tree.Location, Owner = Neutral })
						tree.Destroy()
					end
				end)
			end
		end
	end
end

StartingWinter = function()
	for i=1,#AllTrees do
		if i ~= nil then
			local Trees = Neutral.GetActorsByType(AllTrees[i])
			for p,tree in pairs(Trees) do
				Newtree = Actor.Create(tree.Type .. "winter" , true, { Location = tree.Location, Owner = Neutral })
				tree.Destroy()
			end
		end
	end
	for i=1,#AllNeedleTrees do
		if i ~= nil then
			local Trees = Neutral.GetActorsByType(AllNeedleTrees[i])
			for p,tree in pairs(Trees) do
				Newtree = Actor.Create(tree.Type .. "winter" , true, { Location = tree.Location, Owner = Neutral })
				tree.Destroy()
			end
		end
	end
	for i=1,#AllBuildings do
		if i ~= nil then
			local Trees = Neutral.GetActorsByType(AllBuildings[i])
			for p,tree in pairs(Trees) do
				Newtree = Actor.Create(tree.Type .. "winter" , true, { Location = tree.Location, Owner = Neutral })
				tree.Destroy()
			end
		end
	end
end

NeedleTrees = function()
	for i=1,#AllNeedleTrees do
		if i ~= nil then
			local Trees = Neutral.GetActorsByType(AllNeedleTrees[i])
			for p,tree in pairs(Trees) do
				Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 30)), function()
					if not tree.IsDead and tree.IsInWorld then
						Newtree = Actor.Create(tree.Type .. "winter" , true, { Location = tree.Location, Owner = Neutral })
						tree.Destroy()
					end
				end)
			end
		end
	end
	for i=1,#AllBuildings do
		if i ~= nil then
			local Trees = Neutral.GetActorsByType(AllBuildings[i])
			for p,tree in pairs(Trees) do
				Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 30)), function()
					if not tree.IsDead and tree.IsInWorld then
						Newtree = Actor.Create(tree.Type .. "winter" , true, { Location = tree.Location, Owner = Neutral })
						tree.Destroy()
					end
				end)
			end
		end
	end
end

ChangeSpringTrees = function()
	for u=1,#AllWinterStufft do
		if u ~= nil then
			local Trees = Neutral.GetActorsByType(AllWinterStufft[u])
			for p,tree in pairs(Trees) do
				for i=1,#AllTNumbers do
					if tree.Type == "t0" .. i .. "winter" then
						Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 25)), function()
							if not tree.IsDead and tree.IsInWorld then
								Newtree = Actor.Create("t0" .. i .. "" , true, { Location = tree.Location, Owner = Neutral })
								if Newtree.HasProperty("GrantCondition") and Newtree.AcceptsCondition("spring") then
									Newtree.GrantCondition("spring", 0)
								end
								tree.Destroy()
							end
						end)
					elseif tree.Type == "t" .. i .. "winter" then
						Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 25)), function()
							if not tree.IsDead and tree.IsInWorld then
								Newtree = Actor.Create("t" .. i .. "" , true, { Location = tree.Location, Owner = Neutral })
								if Newtree.HasProperty("GrantCondition") and Newtree.AcceptsCondition("spring") then
									Newtree.GrantCondition("spring", 0)
								end
								tree.Destroy()
							end
						end)
					end
				end
			end
		end
	end
	for u=1,#AllWinterStufftc do
		if u ~= nil then
			local Trees = Neutral.GetActorsByType(AllWinterStufftc[u])
			for p,tree in pairs(Trees) do
				for i=1,#AllTCNumbers do
					if tree.Type == "tc0" .. i .. "winter" then
						Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 25)), function()
							if not tree.IsDead and tree.IsInWorld then
								Newtree = Actor.Create("tc0" .. i .. "" , true, { Location = tree.Location, Owner = Neutral })
								if Newtree.HasProperty("GrantCondition") and Newtree.AcceptsCondition("spring") then
									Newtree.GrantCondition("spring", 0)
								end
								tree.Destroy()
							end
						end)
					end
				end
			end
		end
	end
	for u=1,#AllWinterStuffv do
		if u ~= nil then
			local Trees = Neutral.GetActorsByType(AllWinterStuffv[u])
			for p,tree in pairs(Trees) do
				for i=1,#AllVNumbers do
					if tree.Type == "v" .. i .. "winter" then
						Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 25)), function()
							if not tree.IsDead and tree.IsInWorld then
								Newtree = Actor.Create("v" .. i .. "" , true, { Location = tree.Location, Owner = Neutral })
								tree.Destroy()
							end
						end)
					elseif tree.Type == "v0" .. i .. "winter" then
						Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 25)), function()
							if not tree.IsDead and tree.IsInWorld then
								Newtree = Actor.Create("v0" .. i .. "" , true, { Location = tree.Location, Owner = Neutral })
								tree.Destroy()
							end
						end)
					end
				end
			end
		end
	end
end


StartingSpringTrees = function()
	for i=1,#AllTrees do
		if i ~= nil then
			local Trees = Neutral.GetActorsByType(AllTrees[i])
			for p,tree in pairs(Trees) do
				if not tree.IsDead and tree.IsInWorld and tree.HasProperty("GrantCondition") and tree.AcceptsCondition("spring") then
					tree.GrantCondition("spring", 0)
				end
			end
		end
	end
end

MonthConditions = function()
	if Month == 1 then
		BrightnessChangeSpeed = 7
		ColorChangeSpeed = 16
		BrightestLight = 0.92
		DarkestLight = 0.55
		DayDuration = 5000
		NightDuration = 6000
		DesiredRed = 1
		DesiredGreen = 1
		DesiredBlue = 1
		MonthName = "Januar"
		ThunderRiskfactor = { 1, 2, 3 }
		TimerColor = HSLColor.Cyan
	elseif Month == 2 then
		Firstyear = true
		BrightnessChangeSpeed = 8
		ColorChangeSpeed = 18
		BrightestLight = 0.94
		DarkestLight = 0.58
		DayDuration = 5400
		NightDuration = 5500
		DesiredRed = 1.15
		DesiredGreen = 0.91
		DesiredBlue = 1.18
		MonthName = "Februar"
		ThunderRiskfactor = { 1, 2, 3 }
		TimerColor = HSLColor.Blue
--												Spring
	elseif Month == 3 then
		if not Firstyear then
			Firstyear = true
			StartingSpringTrees()
		else
			ChangeSpringTrees()
		end
		BrightnessChangeSpeed = 9
		ColorChangeSpeed = 20
		BrightestLight = 0.96
		DarkestLight = 0.60
		DayDuration = 5800
		NightDuration = 5000
		DesiredRed = 0.97
		DesiredGreen = 1.10
		DesiredBlue = 1.05
		MonthName = "Maerz"
		ThunderRiskfactor = { 1, 2, 3 }
		TimerColor = HSLColor.LawnGreen
	elseif Month == 4 then
		BrightnessChangeSpeed = 10
		ColorChangeSpeed = 22
		BrightestLight = 0.98
		DarkestLight = 0.62
		DayDuration = 6300
		NightDuration = 4900
		DesiredRed = 0.97
		DesiredGreen = 1.10
		DesiredBlue = 1.05
		MonthName = "April"
		AprilTrees()
		ThunderRiskfactor = { 1, 2, 3, 4, 5, 6, 11, 12, 13 }
		TimerColor = HSLColor.Green
	elseif Month == 5 then
		BrightnessChangeSpeed = 11
		ColorChangeSpeed = 25
		BrightestLight = 1.0
		DarkestLight = 0.65
		DayDuration = 6800
		NightDuration = 4300
		DesiredRed = 0.97
		DesiredGreen = 1.10
		DesiredBlue = 1.05
		MonthName = "Mai"
		MaiTrees()
		ThunderRiskfactor = { 1, 2, 3, 4, 5, 6, 7, 8, 11, 12, 13 }
		TimerColor = HSLColor.LimeGreen
--												Summer
	elseif Month == 6 then
		BrightnessChangeSpeed = 12
		ColorChangeSpeed = 28
		BrightestLight = 1.03
		DarkestLight = 0.68
		DayDuration = 7300
		NightDuration = 3700
		DesiredRed = 1.15
		DesiredGreen = 1.15
		DesiredBlue = 0.95
		MonthName = "Juni"
		ThunderRiskfactor = { 1, 2, 3, 4, 5, 6, 7, 12, 13 }
		TimerColor = HSLColor.LightYellow
	elseif Month == 7 then
		BrightnessChangeSpeed = 12
		ColorChangeSpeed = 26
		BrightestLight = 1.03
		DarkestLight = 0.68
		DayDuration = 7300
		NightDuration = 3700
		DesiredRed = 1.17
		DesiredGreen = 1.17
		DesiredBlue = 0.94
		MonthName = "Juli"
		ThunderRiskfactor = { 1, 2, 3, 4, 5, 6, 7, 12, 13 }
		TimerColor = HSLColor.Gold
	elseif Month == 8 then
		BrightnessChangeSpeed = 11
		ColorChangeSpeed = 24
		BrightestLight = 1.0
		DarkestLight = 0.65
		DayDuration = 6800
		NightDuration = 4300
		DesiredRed = 1.13
		DesiredGreen = 1.1
		DesiredBlue = 0.93
		MonthName = "August"
		ThunderRiskfactor = { 1, 2, 3, 4, 5, 6, 7, 8, 11, 12, 13 }
		TimerColor = HSLColor.DarkRed
--												Fall
	elseif Month == 9 then
		BrightnessChangeSpeed = 10
		ColorChangeSpeed = 22
		BrightestLight = 0.98
		DarkestLight = 0.62
		DayDuration = 6300
		NightDuration = 4900
		DesiredRed = 1.08
		DesiredGreen = 1.03
		DesiredBlue = 0.94
		MonthName = "September"
		SeptemberTrees()
		ThunderRiskfactor = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 }
		TimerColor = HSLColor.DarkOrange
	elseif Month == 10 then
		BrightnessChangeSpeed = 9
		ColorChangeSpeed = 20
		BrightestLight = 0.96
		DarkestLight = 0.60
		DayDuration = 5800
		NightDuration = 5000
		DesiredRed = 1.13
		DesiredGreen = 1
		DesiredBlue = 0.97
		MonthName = "Oktober"
		OktoberTrees()
		ThunderRiskfactor = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13 }
		TimerColor = HSLColor.DarkGray
	elseif Month == 11 then
		BrightnessChangeSpeed = 8
		ColorChangeSpeed = 18
		BrightestLight = 0.94
		DarkestLight = 0.58
		DayDuration = 5400
		NightDuration = 5500
		DesiredRed = 1.14
		DesiredGreen = 0.97
		DesiredBlue = 1.04
		MonthName = "November"
		NovemberTrees()
		ThunderRiskfactor = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 }
		TimerColor = HSLColor.DarkGray
--								Winter
	elseif Month == 12 then
		BrightnessChangeSpeed = 7
		ColorChangeSpeed = 15
		BrightestLight = 0.92
		DarkestLight = 0.55
		DayDuration = 5000
		NightDuration = 6000
		DesiredRed = 1.15
		DesiredGreen = 0.93
		DesiredBlue = 1.12
		MonthName = "Dezember"
		ThunderRiskfactor = { 1, 2, 3 }
		TimerColor = HSLColor.White
	end
	Trigger.AfterDelay(5, function()
		Month = Month + 1
		if Month == 13 then
			Month = 1
			Year = Year + 1  -- Happy new year :D
		end
	end)
end

ColorChanger = function()
	if RedLight < DesiredRed then
		RedLight = RedLight + 0.001
	elseif RedLight > DesiredRed then
		RedLight = RedLight - 0.001
	end
	if GreenLight < DesiredGreen then
		GreenLight = GreenLight + 0.001
	elseif GreenLight > DesiredGreen then
		GreenLight = GreenLight - 0.001
	end
	if BlueLight < DesiredBlue then
		BlueLight = BlueLight + 0.001
	elseif BlueLight > DesiredBlue then
		BlueLight = BlueLight - 0.001
	end
	Lighting.Red = RedLight
	Lighting.Green = GreenLight
	Lighting.Blue = BlueLight
	Trigger.AfterDelay(ColorChangeSpeed, function()
		ColorChanger()
	end)
end

turnOn = function()
	Lighting.Ambient = Light
	if Light < 0.794 and Light > 0.793 then
		POWER.Destroy()
		Trigger.AfterDelay(100, function()
			Media.PlayMusic()
		end)
	end
	if Light < BrightestLight then
		Light = Light + RateOfIncrease
		Trigger.AfterDelay(BrightnessChangeSpeed, function()
			turnOn()
		end)

	else
		NoturnOn = true
		Trigger.AfterDelay(DayDuration, function()
			turnOff()
		end)
	end
end

turnOff = function()
	if Light < 0.734 and Light > 0.733 then
		DesiredRed = 0.93
		DesiredGreen = 1.07
		DesiredBlue = 1.13
	end
	if Light < 0.734 and Light > 0.733 then
		GettingDark = true
		POWER = Actor.Create("dummypower", true, { Location = CPos.New(0,0), Owner = Neutral })
		Trigger.AfterDelay(350, function()
			Media.StopMusic()
		end)
	end
	if Light < 0.691 and Light > 0.690 then
		ThunderManager()
	end
	if Light > DarkestLight then
		Light = Light - RateOfIncrease
		Trigger.AfterDelay(BrightnessChangeSpeed, function()
			turnOff()
		end)
	else
		Trigger.AfterDelay(NightDuration, function()
			if Month == 12 then
				NeedleTrees()
			end
			NoturnOn = false
			Thunderstorm = false
			MonthConditions()
			turnOn()
		end)
	end
	Lighting.Ambient = Light
end

ThunderManager = function()
	ThunderstormRisk = Utils.Random(ThunderRiskfactor)
	if ThunderstormRisk == 11 then
		SmoothThunderstorm = true
		Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(45, 65)), function()
			SmoothThunderstorm = false
		end)
	elseif ThunderstormRisk == 12 then
		SmoothThunderstorm = true
		Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(15, 30)), function()
			SmoothThunderstorm = false
			NormalThunderstorm = true
			Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(30, 60)), function()
				NormalThunderstorm = false
				SmoothThunderstorm = true
				Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(15, 30)), function()
					SmoothThunderstorm = false
				end)
			end)
		end)
	elseif ThunderstormRisk == 13 then
		SmoothThunderstorm = true
		Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(15, 30)), function()
			SmoothThunderstorm = false
			NormalThunderstorm = true
			Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(20, 30)), function()
				NormalThunderstorm = false
				HardThunderstorm = true
				Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(30, 60)), function()
					HardThunderstorm = false
					NormalThunderstorm = true
					Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(15, 30)), function()
						NormalThunderstorm = false
						SmoothThunderstorm = true
						Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(15, 30)), function()
							SmoothThunderstorm = false
						end)
					end)
				end)
			end)
		end)

	end
end

SetupPlayers = function()
	Neutral = Player.GetPlayer("Neutral")
	Creeps = Player.GetPlayer("Creeps")
	Multi0 = Player.GetPlayer("Multi0")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Multi6 = Player.GetPlayer("Multi6")
	Multi7 = Player.GetPlayer("Multi7")
	Multi8 = Player.GetPlayer("Multi8")
	Multi9 = Player.GetPlayer("Multi9")
	Humans = { Multi0, Multi1, Multi2, Multi3, Multi4, Multi5, Multi6, Multi7, Multi8, Multi9 }
end

WorldLoaded = function()
	SetupPlayers()
	if Season == "noweather" then
	else
		InitialiseWeather()
	end
end

Tick = function()
	if Season == "defmode" then
		if SmoothThunderstorm then
			WeatherInfo = "SmoothThunderstorm"
		elseif NormalThunderstorm then
			WeatherInfo = "NormalThunderstorm"
		elseif HardThunderstorm then
			WeatherInfo = "HardThunderstorm"
		else
			WeatherInfo = "NoStorm"
		end
			UserInterface.SetMissionText("" .. MonthName .. " " .. (Year) .. "\nRed:" .. RedLight .. "     Green:" .. GreenLight .. "     Blue:" .. BlueLight .. "\nDesiredRed:" .. DesiredRed .. "     DesiredGreen:" .. DesiredGreen .. "     DesiredBlue:" .. DesiredBlue .. "\nLight:" .. Light .. "\n\n" .. WeatherInfo .. "", TimerColor)

	end
	if SmoothThunderstorm then
		if (Utils.RandomInteger(1, 300) == 10) then
			local delay = Utils.RandomInteger(1, 10)
			Lighting.Flash("LightningStrike", delay)
			Trigger.AfterDelay(delay, function()
				Media.PlaySound("thunder" .. Utils.RandomInteger(1,10) .. ".aud")
			end)
		end
		if (Utils.RandomInteger(1, 250) == 10) then
			Media.PlaySound("thunder-ambient.aud")
		end
	elseif NormalThunderstorm then
		if (Utils.RandomInteger(1, 250) == 10) then
			local delay = Utils.RandomInteger(1, 10)
			Lighting.Flash("LightningStrike", delay)
			Trigger.AfterDelay(delay, function()
				Media.PlaySound("thunder" .. Utils.RandomInteger(1,10) .. ".aud")
			end)
		end
		if (Utils.RandomInteger(1, 225) == 10) then
			Media.PlaySound("thunder-ambient.aud")
		end
	elseif HardThunderstorm then
		if (Utils.RandomInteger(1, 200) == 10) then
			local delay = Utils.RandomInteger(1, 10)
			Lighting.Flash("LightningStrike", delay)
			Trigger.AfterDelay(delay, function()
				Media.PlaySound("thunder" .. Utils.RandomInteger(1,10) .. ".aud")
			end)
		end
		if (Utils.RandomInteger(1, 200) == 10) then
			Media.PlaySound("thunder-ambient.aud")
		end
	end
end
