-- The players.
Players = {}
-- The start waypoints for each player.
Entries = {}
-- The flag for each player (this keeps them alive).
Flags = {}
-- The team lives.
Lives = {}
-- Have reinforcements been provided for each team?
Reinforcements = {}

TeamId = function(playerId)
    return 1 + ((playerId - 1 - ((playerId - 1) % 4)) / 4)
end

BuildPlayerUnit = function(playerId, unit)
    local actor = Actor.Create(unit, true, { Owner = Players[playerId], Location = Entries[playerId].Location })
    actor.Scatter()
end

EndGame = function(teamId)
    Trigger.AfterDelay(DateTime.Seconds(1), function()
        local entryId = 1 + (DateTime.GameTime % 4) + (teamId - 1) * 4
        ParaProxy.TargetParatroopers(Entries[entryId].CenterPosition)
        EndGame(teamId)
    end)
end

SendUnits = function()
    Trigger.AfterDelay(DateTime.Seconds(1), function()
        -- Replace destroyed V2s if lives remaining.
        for playerId = 1, 8 do
            local teamId = TeamId(playerId)
            -- Expect actors for flag and ???
            if #(Players[playerId].GetActors()) <= 2 then
                if Lives[teamId] > 0 then
                    BuildPlayerUnit(playerId, "v2rl")
                    Lives[teamId] = Lives[teamId] - 1
                    Media.DisplayMessage("Team " .. teamId .. " has " .. Lives[teamId] .. " lives left")
                else
                    -- All lives gone so no more V2s.
                    local v2Count = 0
                    for pId = (teamId - 1) * 4 + 1, (teamId - 1) * 4 + 4 do
                        v2Count = v2Count + #(Players[pId].GetActorsByType("v2rl"))
                    end
                    if v2Count > 0 then
                        -- Player gets mechanic to support V2s.
                        Media.DisplayMessage("Giving mech to " .. playerId)
                        BuildPlayerUnit(playerId, "mech")
                        Media.DisplayMessage("Given mech to " .. playerId)
                        if v2Count == 1 and not Reinforcements[teamId]
                        then
                            Reinforcements[teamId] = true
                            for playerToNotify = 1, 8 do
                                Media.PlaySpeechNotification(Players[playerToNotify], "ReinforcementsArrived")
                            end
                            EndGame(teamId)
                        end
                    else
                        -- Team has lost - change flags to Neutral.
                        for pId = (teamId - 1) * 4 + 1, (teamId - 1) * 4 + 4 do
                            Flags[pId].Owner = Player.GetPlayer("Neutral")
                        end
                    end
                end
            end
        end
        SendUnits()
    end)
end

InitPlayers = function()
    Players[1] = Player.GetPlayer("Multi0")
    Players[2] = Player.GetPlayer("Multi1")
    Players[3] = Player.GetPlayer("Multi2")
    Players[4] = Player.GetPlayer("Multi3")
    Players[5] = Player.GetPlayer("Multi4")
    Players[6] = Player.GetPlayer("Multi5")
    Players[7] = Player.GetPlayer("Multi6")
    Players[8] = Player.GetPlayer("Multi7")

    Entries[1] = Spawn1
    Entries[2] = Spawn2
    Entries[3] = Spawn3
    Entries[4] = Spawn4
    Entries[5] = Spawn5
    Entries[6] = Spawn6
    Entries[7] = Spawn7
    Entries[8] = Spawn8

    Flags[1] = Flag1
    Flags[2] = Flag2
    Flags[3] = Flag3
    Flags[4] = Flag4
    Flags[5] = Flag5
    Flags[6] = Flag6
    Flags[7] = Flag7
    Flags[8] = Flag8

    Lives[1] = 4
    Lives[2] = 4
    Reinforcements[1] = false
    Reinforcements[2] = false

    for playerId = 1, 8 do
        local player = Players[playerId]
        BuildPlayerUnit(playerId, "v2rl")
        if player.IsLocalPlayer then
            Camera.Position = Entries[playerId].CenterPosition
        end
    end
end

WorldLoaded = function()
    InitPlayers()
    ParaProxy = Actor.Create("powerproxy.paratroopers", false, { Owner = Player.GetPlayer("Creeps") })
    SendUnits()
end
