

ProxyType = "powerproxy.paratroopers"
ProducedUnitTypes =
{
	{ factory = AlliedBarracks1, types = { "e1", "e3" } },
	{ factory = AlliedBarracks2, types = { "e1", "e3" } },
	{ factory = SovietBarracks1, types = { "dog", "e1", "e2", "e3", "e4", "shok" } },
	{ factory = SovietBarracks2, types = { "dog", "e1", "e2", "e3", "e4", "shok" } },
	{ factory = SovietBarracks3, types = { "dog", "e1", "e2", "e3", "e4", "shok" } },
	{ factory = AlliedWarFactory1, types = { "jeep", "2tnk", "arty", "ctnk" } },
	{ factory = SovietWarFactory1, types = { "ftrk", "3tnk", "v2rl", "ttnk"} }
}

SovietLandUnitTypes =  { "ftrk", "apc_loaded", "3tnk"}
AlliedChronoUnitType = "2tnk"
AlliedShipUnitTypes = { "1tnk", "2tnk" , "e1", "e1", "e1", "e1", "e3", "e3" }
AlliedShipUnitTypes2 = { "1tnk", "2tnk" , "e1", "e1", "e1", "e1", "e3", "e3" }

--TimerChronoshift = 55
--TimerShip = 38
--TimerParadrop = 40
--
--TimerSovietsLand = 54
--TimerSovietsBeach = 15
--TimerMigs = 60

TimerFactor = 2
TimerFactorSoviet = 1.1

TimerChronoshift = 60 * TimerFactor -- 5 MT 
TimerShip = 60 * TimerFactor -- 2 x 1,5 MT

TimerSovietsLand = 30 * TimerFactor * TimerFactorSoviet -- 7 x 1 HT -- each entry is used 1/2 times 
OrderSovietsLand = 0

TimerParadrop = 30 * TimerFactor

TimerMigs = 30

T1LooseCounter = 0
T2LooseCounter = 0

ParadropSovietWaypoints = { ParadropSoviet1, ParadropSoviet2, ParadropSoviet3, ParadropSoviet4, ParadropSoviet5, ParadropSoviet6, ParadropSoviet7, ParadropSoviet8 }
ParadropAlliesWaypoints = { ParadropAllies1, ParadropAllies2, ParadropAllies3, ParadropAllies4, ParadropAllies5, ParadropAllies6, ParadropAllies7, ParadropAllies8 }
Entries = { Entry1, Entry2, Entry3, Entry4, Entry5, Entry6, Entry7 }


Mig1Waypoints = { Mig11, Mig12, Mig13, Mig14 }
Mig2Waypoints = { Mig21, Mig22, Mig23, Mig24 }

BindActorTriggers = function(a)
	if a.HasProperty("Hunt") then
		if a.Owner == allies or a.Owner == soviets then
			Trigger.OnIdle(a, function(a)
				if a.IsInWorld then
					a.Hunt()
				end
			end)
		else
			Trigger.OnIdle(a, function(a)
				if a.IsInWorld then
					a.AttackMove(AlliedTechnologyCenter.Location)
				end
			end)
		end
	end

	if a.HasProperty("HasPassengers") and a.Type ~= "badr" then
		Trigger.OnDamaged(a, function()
			if a.HasPassengers then
				a.Stop()
				a.UnloadPassengers()
			end
		end)
	end
end

SendSovietUnits = function()
	OrderSovietsLand = (OrderSovietsLand + 1) % 2
	for i, entry in pairs(Entries) do
		if (i % 2) == OrderSovietsLand then
			entryL = { Entries[i].Location, Entries[i].Location }
			if i == 1 then entryL = { Entries[i].Location, AlliedBaseCenter.Location } end
			local units = Reinforcements.Reinforce(soviets, SovietLandUnitTypes, entryL, TimerSovietsLand)
			Utils.Do(units, function(unit)
				BindActorTriggers(unit)
			end)
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(TimerSovietsLand), SendSovietUnits)	
	
end

SendMigs = function(waypoints)
	local migEntryPath = { waypoints[1].Location, waypoints[2].Location }
	local migs = Reinforcements.Reinforce(soviets, { "mig" }, migEntryPath, 4)
	Utils.Do(migs, function(mig)
		mig.Move(waypoints[3].Location)
		mig.Move(waypoints[4].Location)
		mig.Destroy()
	end)

	Trigger.AfterDelay(DateTime.Seconds(TimerMigs), function() SendMigs(waypoints) end)
end

ShipAlliedUnits = function()
	local units = Reinforcements.ReinforceWithTransport(allies, "lst",
		AlliedShipUnitTypes, { LstEntry.Location, LstUnload.Location }, { LstEntry.Location })[2]

	Utils.Do(units, function(unit)
		BindActorTriggers(unit)
	end)

	Trigger.AfterDelay(DateTime.Seconds(TimerShip), ShipAlliedUnits)
end

ShipAlliedUnits2 = function()
	local units = Reinforcements.ReinforceWithTransport(allies, "lst",
		AlliedShipUnitTypes2, { LstEntry.Location, LstUnload2.Location }, { LstEntry.Location })[2]

	Utils.Do(units, function(unit)
		BindActorTriggers(unit)
	end)

	Trigger.AfterDelay(DateTime.Seconds(TimerShip), ShipAlliedUnits2)
end

ParadropSovietUnits = function()
	local lz = Utils.Random(ParadropSovietWaypoints)
	local units = powerproxySoviets.ActivateParatroopers(lz.CenterPosition)

	Utils.Do(units, function(a)
		BindActorTriggers(a)
	end)

	Trigger.AfterDelay(DateTime.Seconds(TimerParadrop), ParadropSovietUnits)
end

ParadropAlliesUnits = function()
	local lz = Utils.Random(ParadropAlliesWaypoints)
	local units = powerproxyAllies.ActivateParatroopers(lz.CenterPosition)

	Utils.Do(units, function(a)
		BindActorTriggers(a)
	end)

	Trigger.AfterDelay(DateTime.Seconds(TimerParadrop), ParadropAlliesUnits)
end

ProduceUnits = function(t)
	local factory = t.factory
	if not factory.IsDead then
		local unitType = t.types[Utils.RandomInteger(1, #t.types + 1)]
		factory.Wait(Actor.BuildTime(unitType))
		factory.Produce(unitType)
		factory.CallFunc(function() ProduceUnits(t) end)
	end
end

ProduceInfantry = function()
	local delay = Utils.RandomInteger(DateTime.Seconds(3), DateTime.Seconds(9))
	local toBuild = { Utils.Random(UnitType) }
	ussr.Build(toBuild, function(unit)
		IdlingUnits[#IdlingUnits + 1] = unit[1]
		Trigger.AfterDelay(delay, ProduceInfantry)
		if #IdlingUnits >= (AttackGroupSize * 2.5) then
			SendAttack()
		end
	end)
end

SetupAlliedUnits = function()
	Utils.Do(Map.NamedActors, function(a)
		if a.Owner == allies and a.HasProperty("AcceptsCondition") and a.AcceptsCondition("Trigger.AfterDelay(DateTime.Seconds(10),") then
			a.GrantCondition("unkillable")
			a.Stance = "Defend"
		end
	end)
end

SetupFactories = function()
	Utils.Do(ProducedUnitTypes, function(production)
		Trigger.OnProduction(production.factory, function(_, a) BindActorTriggers(a) end)
	end)
end

ChronoshiftAlliedUnits = function()
	local cells = Utils.ExpandFootprint({ ChronoshiftLocation.Location }, false)
	local units = { }
	for i = 1, #cells do
		local unit = Actor.Create(AlliedChronoUnitType, true, { Owner = allies, Facing = 0 })
		BindActorTriggers(unit)
		units[unit] = cells[i]
	end
	Chronosphere.Chronoshift(units)
	Trigger.AfterDelay(DateTime.Seconds(TimerChronoshift), ChronoshiftAlliedUnits)
end

WorldLoaded = function()
	--SetupPlayers()
	allies = Player.GetPlayer("Allies")
	soviets = Player.GetPlayer("Soviets")
	powerproxySoviets = Actor.Create(ProxyType, false, { Owner = soviets })
	powerproxyAllies = Actor.Create(ProxyType, false, { Owner = allies })

	SetupAlliedUnits()
	SetupFactories()
	Utils.Do(ProducedUnitTypes, ProduceUnits)

	ParadropAlliesUnits()
	ParadropSovietUnits()
	
	ShipAlliedUnits()
	Trigger.AfterDelay(DateTime.Seconds(TimerShip/4), ShipAlliedUnits2)
	Trigger.AfterDelay(DateTime.Seconds(TimerChronoshift/2), ChronoshiftAlliedUnits)
	
	SendSovietUnits()

	SendMigs(Mig1Waypoints)
	SendMigs(Mig2Waypoints)


end
