-- This special constant represents the initial trickle of riflemen that the players get.
DefaultUnit = "DefaultUnit"
-- A list of all the potential units as well as an entry for DefaultUnit.
Reinforcements = {"mcv", "stnk", "ctnk", "e7",
                  "arty", "ttnk", "apc", "dog",
                  "mech", "mrj", "e3", "e4",
                  "e6", "mnly", "1tnk", "e1",
                  "spy", "3tnk", "jeep", "e2",
                  "v2rl", "mgg", "harv", "shok",
                  "thf", "qtnk", "ftrk", "medi",
                  "dtrk", "truk", "4tnk", "2tnk",
                  DefaultUnit}
-- A list of costs for these units (because I couldn't work out how to load the real costs).
Costs = {2000, 1000, 1350, 1200,
         850, 1350, 850, 200,
         500, 1000, 300, 300,
         500, 800, 700, 100,
         500, 1150, 500, 120,
         900, 1000, 1100, 350,
         500, 2000, 600, 200,
         2500, 500, 2000, 850}
-- The two players.
Players = {}
-- The two creeps.
Creeps = {}
-- A map from unit id to amount of money invested in that unit for each player.
PlayerInvestment = {{}, {}}
-- A map from unit id to amount of money invested in that unit for each creep player.
CreepInvestment = {{}, {}}
-- The start waypoints for each player.
Entries = {}
-- The advanced power plants that each player starts with.
Apwrs = {}

BuildPlayerUnit = function(playerId, unit)
    if not Apwrs[playerId].IsDead then
        local actor = Actor.Create(unit, true, { Owner = Players[playerId], Location = Entries[playerId].Location })
        actor.Scatter()
    end
end

BuildCreepUnit = function(creepId, unitId)
    local creep = Creeps[creepId]
    local unit = Reinforcements[unitId]

    local x = ((unitId-1) % 4) * 12 + 8
    if creepId == 2 then
        x = 154 - x
    end
    -- Nb. Integer division (//) isn't supported in this version of Lua.
    local y = ((unitId-1 - ((unitId-1) % 4)) / 4) * 12 + 8

    local location = CPos.New(x, y)
    local actor = Actor.Create(unit, true, { Owner = creep, Location = location })
    for i = 1,3 do
        actor.Scatter()
    end
    -- Creep spies are slightly harder to kill if they're disguised.
    if unit == "spy" then
        actor.DisguiseAsType("e1", Players[creepId])
    end
end

SendUnits = function()
    Trigger.AfterDelay(DateTime.Seconds(1), function()
        -- Player reinforcements.
        for playerId = 1, 2 do
            for unitId = 1, #Reinforcements do
                local player = Players[playerId]
                unit = Reinforcements[unitId]
                if unit == DefaultUnit then
                    PlayerInvestment[playerId][unitId] = PlayerInvestment[playerId][unitId] + 25
                    if PlayerInvestment[playerId][unitId] > 100 then
                        BuildPlayerUnit(playerId, "e1")
                        PlayerInvestment[playerId][unitId] = PlayerInvestment[playerId][unitId] - 100
                    end
                else
                    if Creeps[playerId].GetActorsByType(unit)[1] == nil then
                        PlayerInvestment[playerId][unitId] = PlayerInvestment[playerId][unitId] + 25
                        if PlayerInvestment[playerId][unitId] >= Costs[unitId] then
                            PlayerInvestment[playerId][unitId] = PlayerInvestment[playerId][unitId] - Costs[unitId]
                            BuildPlayerUnit(playerId, unit)
                        end
                    end
                end
            end
        end
        -- Creep reinforcements.
        for creepId = 1, 2 do
            for unitId = 1, #Reinforcements do
                local unit = Reinforcements[unitId]
                -- The creeps don't get the same default reinforcement as the players.
                if unit ~= DefaultUnit and Creeps[creepId].GetActorsByType(unit)[1] ~= nil then
                    CreepInvestment[creepId][unitId] = CreepInvestment[creepId][unitId] + 5
                    if CreepInvestment[creepId][unitId] >= Costs[unitId] then
                        CreepInvestment[creepId][unitId] = CreepInvestment[creepId][unitId] - Costs[unitId]
                        BuildCreepUnit(creepId, unitId)
                    end
                end
            end
        end
        SendUnits()
    end)
end

InitPlayers = function()
    Players[1] = Player.GetPlayer("Multi0")
    Players[2] = Player.GetPlayer("Multi1")
    Entries[1] = Entry0
    Entries[2] = Entry1
    Apwrs[1] = Apwr0
    Apwrs[2] = Apwr1
    for playerId = 1, 2 do
        local player = Players[playerId]
        if player.IsLocalPlayer then
            local startBuilding = player.GetActorsByType("apwr")[1]
            Camera.Position = Entries[playerId].CenterPosition
        end
        -- Create five rifles to start.
        for i = 1, 5 do
            BuildPlayerUnit(playerId, "e1")
        end
        for unitId = 1, #Reinforcements do
            PlayerInvestment[playerId][unitId] = 0
        end
    end

    Creeps[1] = Player.GetPlayer("Creeps0")
    Creeps[2] = Player.GetPlayer("Creeps1")

    for creepId = 1, 2 do
        for unitId = 1, #Reinforcements do
            local unit = Reinforcements[unitId]
            if unit ~= DefaultUnit then
                -- Create five creeps of each type to start.
                for i = 1, 5 do
                    BuildCreepUnit(creepId, unitId)
                end
                CreepInvestment[creepId][unitId] = 0
            end
        end
    end
end

WorldLoaded = function()
    InitPlayers()
    SendUnits()
end
