Light  = { "e1", "e1", "e1", "e1", "e2", "e2", "e2"}
Medium = { "1tnk", "1tnk", "1tnk", "jeep", "jeep", "e3", "e3"}

LightTime  = DateTime.Seconds (90)
MediumTime = DateTime.Minutes (3)

ReinforceActor = function (player, actor)
  local unit_handicap = Map.LobbyOption("UnitHandicap")
  local start_path = CPos.New (actor.Location.X , actor.Location.Y + 8)
  local dest_path = CPos.New (actor.Location.X, actor.Location.Y + 4)
  local path = {start_path, dest_path}
  Media.PlaySpeechNotification (player, "ReinforcementsArrived")
  if unit_handicap == "light" then
    Reinforcements.Reinforce (player, Light, path, 30)
  elseif unit_handicap == "medium" then
    Reinforcements.Reinforce (player, Medium, path, 30)
  end
end

ApplyReinforcements = function (player)
  local mcvs   = player.GetActorsByType ("mcv")
  local facts  = player.GetActorsByType ("fact")
  if facts then
-- Reinforce first instance of the factory
    for _,fact in pairs (facts) do
      ReinforceActor (player, fact)
      break
    end
  elseif mcvs then
-- Reinforce first instance of the mcv
    for _,mcv in pairs (mcvs) do
      ReinforceActor (player, mcv)
      break
    end
  end
end

ApplyCashHandicap = function (player)
  local cashOption = Map.LobbyOption("CashHandicap")
  if cashOption then
    local cashPercentage = tonumber (cashOption)
    player.Cash = player.Cash + (cashPercentage * player.Cash)
  end
end

ApplyHandicap = function (player)
  ApplyCashHandicap (player)
  local reinforce = function () 
    ApplyReinforcements (player)
  end
-- Check for unit handicap
  local unit_handicap = Map.LobbyOption("UnitHandicap")
  if unit_handicap == "light" then
    Trigger.AfterDelay (LightTime, reinforce)
  elseif unit_handicap == "medium" then
    Trigger.AfterDelay (MediumTime, reinforce)
  end
end


WorldLoaded = function ()
  if Map.LobbyOption("TeamHandicap") ~= "0" then
    Media.DisplayMessage ("The host has selected Team "..Map.LobbyOption("TeamHandicap").." Handicap", "Mission", HSLColor.Cyan)
  end

  local players = Player.GetPlayers (nil)
  local team = tonumber (Map.LobbyOption("TeamHandicap"))
  for _,player in pairs (players) do
    if player.Team == team then
      ApplyHandicap (player)
    end
  end
end

Tick = function ()
end