local MUtil = require("mutil")
local List = MUtil.List
local Set = MUtil.Set
local Dict = MUtil.Dict
local Tuple = MUtil.Tuple

print("BEGIN TUPLE")
local t = Tuple.New(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
print(t.ToString())
print(t.Map(function(v) return v + 1 end).ToString())
print(t.Max())
print(t.Min())
print(t.ForAll(function(v) return v > 0 end))
print(t.Exists(function(v) return v < 0 end))
print(t.Product())
print(t.Sum())
print(t.Unpack())
print("END TUPLE")

print("BEGIN SET")
local s = Set.New(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
local s2 = Set.New(11, 12, 13, 14, 15, 16, 17, 18, 19, 20)
print(s.ToString())
print(s.Map(function(v) return v + 1 end).ToString())
print(s.Max())
print(s.Min())
print(s.ForAll(function(v) return v > 0 end))
print(s.Exists(function(v) return v < 0 end))
print(s.Product())
print(s.Sum())
print(s.Filter(function(v) return v % 2 == 0 end).ToString())
print(s.Product() == s.Filter(function(v) return v % 2 == 1 end).Product())
print(s.Unpack())
print(s.Incl(11).Incl(12).Incl(13).Size())
s.ForEach(function(v) print(v) end)
print("END SET")

print("BEGIN LIST")
local l = List.New(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
print(l.ToString())
print(l.Map(function(v) return v + 1 end).ToString())
print(l.Max())
print(l.Min())
print(l.ForAll(function(v) return v > 0 end))
print(l.Exists(function(v) return v < 0 end))
print(l.Product())
print(l.Sum())
print(l.Filter(function(v) return v % 2 == 0 end).ToString())
print(l.Product() == l.Filter(function(v) return v % 2 == 1 end).Product())
print("END LIST")

print("BEGIN DICT")
local d = Dict.New(Tuple.New(1, 2), Tuple.New(2, 3), Tuple.New(3, 5), Tuple.New(4, 7))
print(d.ToString())
print(d.Filter(function(k, v) return k % 2 == 0 end).ToString())
print(d.KeySet().Max())
print(d.Fold(-MUtil.Infinity, function(w, t) local _, v = t.Unpack() return MUtil.Max(w, v) end))
print("END DICT")

print("BEGIN CONVERSION")
local l = List.New(1, 2, 3)
print(l.ToString())
print(l.Unpack())
print(Set.New(l.Unpack()).ToString())
print("END CONVERSION")
