--dynamic lists
SpawningFormations = {}

--timings
minDelay = DateTime.Seconds(1)

ecoboost = DateTime.Minutes(2)
mcvDelay = DateTime.Minutes(5)
army1Delay = DateTime.Seconds(90)  --1m30
army2Delay = DateTime.Minutes(4)
army3Delay = DateTime.Minutes(6)
army4Delay = DateTime.Minutes(9)
armyFinalDelay = DateTime.Minutes(12)
armyFinalReDelay = DateTime.Minutes(3)

--data
units =
{
	_ = "Nothing", --in subcell
	R = "light_inf",
	T = "trooper",
	CONYD = "mcv",
	CARRY = "carryall",
	TRIKE = "trike",
	QUADD = "quad",
	COTNK = "combat_tank",
	SIEGE = "siege_tank",
	SUPER = "faction_special_unit",
}

--define formations as if they were moving onto the map from the south 
McvFormation = 
{
	"RTRTR SPACE RTRTR",
	"",
	"SPACE CONYD SPACE",
	"",
	"R_R_R SPACE R_R_R",
}
CarryallFormation=
{
	"SPACE CARRY SPACE",
	"CARRY SPACE CARRY",
}
Army1 =
{
	"QUADD QUADD",
	"QUADD QUADD",
}
Army2 = 
{
	"_R_R_ TRIKE TRIKE _R_R_",
	"_R_R_ COTNK COTNK _R_R_",
	"_R_R_ COTNK COTNK _R_R_",
	"_R_R_ COTNK COTNK _R_R_",
}
Army3 =
{
	"TRIKE TRIKE TRIKE TRIKE TRIKE",
	"COTNK COTNK COTNK COTNK COTNK",
	"SPACE SIEGE SIEGE SIEGE SPACE",
	"T_T_T T_T_T T_T_T T_T_T T_T_T",
}
ArmyFinal =
{
	"SPACE SPACE QUADD QUADD SPACE SPACE",
	"SPACE QUADD COTNK COTNK QUADD SPACE",
	"RRRRR COTNK COTNK COTNK COTNK RRRRR",
	"RRRRR SIEGE SUPER SUPER SIEGE RRRRR",
	"TTTTT SIEGE SUPER SUPER SIEGE TTTTT",
}


--[[ Available Waypoits:
ReIn_EastRock
ReIn_WestRock
ReIn_ExpoBase
ReIn_MainBase
ReIn_SpawnExpo
ReIn_SpawnBack
ReIn_SpawnEast
ReIn_SpawnWest
ReIn_WorldEast
ReIn_WorldBack
ReIn_WorldWest
ReIn_WorldExpo
]]

WorldLoaded = function()
	
	checkFormations = false
	Trigger.AfterDelay( minDelay, function() checkFormations=true end )
	
	beginner = Player.GetPlayer("Multi1")
	
	--economy boost with carryalls
	Trigger.AfterDelay( ecoboost, reinforceWithCarryalls )
	
	--expansion mcv
	randomness = Utils.RandomInteger(-DateTime.Seconds(20), DateTime.Seconds(20))
	Trigger.AfterDelay( mcvDelay + randomness, reinforceWithMcv )

	--reinforcement armies
	Trigger.AfterDelay( army1Delay, reinforceWithArmy1 )
	Trigger.AfterDelay( army2Delay, reinforceWithArmy2 )
	Trigger.AfterDelay( army3Delay, reinforceWithArmy3 )
	Trigger.AfterDelay( army4Delay, reinforceWithArmy3 )
	Trigger.AfterDelay( armyFinalDelay, reinforceWithArmyFinal )
end

Tick = function()
	--handle spawning of formations
	if		checkFormations==true
	then
		checkFormations=false
		Trigger.AfterDelay( minDelay, function() checkFormations=true end )
		spawnFormationActors()
	end
end

function reinforceWithCarryalls()

	queueFormation{
		formation	= CarryallFormation,
		spawnLoc	= ReIn_SpawnBack.Location,
		inWorldLoc	= ReIn_WorldBack.Location,
		targetLoc	= ReIn_MainBase.Location,
		mapEdge		= "north",
		airborne	= true,
	}

end

function reinforceWithArmy1()
	queueFormation{
		formation	= Army1,
		spawnLoc	= ReIn_SpawnBack.Location,
		inWorldLoc	= ReIn_WorldBack.Location,
		targetLoc	= ReIn_MainBase.Location,
		mapEdge		="north",
	}
end

function reinforceWithArmy2()
	queueFormation{
		formation	= Army2,
		spawnLoc	= ReIn_SpawnBack.Location,
		inWorldLoc	= ReIn_WorldBack.Location,
		targetLoc	= ReIn_MainBase.Location,
		mapEdge		="north",
	}
end

function reinforceWithArmy3()
	queueFormation{
		formation	= Army3,
		spawnLoc	= ReIn_SpawnBack.Location,
		inWorldLoc	= ReIn_WorldBack.Location,
		targetLoc	= ReIn_MainBase.Location,
		mapEdge		="north",
	}
end

function reinforceWithArmyFinal()
	queueFormation{
		formation	= ArmyFinal,
		spawnLoc	= ReIn_SpawnBack.Location,
		inWorldLoc	= ReIn_WorldBack.Location,
		targetLoc	= ReIn_MainBase.Location,
		mapEdge		="north",
	}
	Trigger.AfterDelay( armyFinalReDelay, reinforceWithArmyFinal )
end

function reinforceWithMcv()

	if Utils.Random{ false, true }
	then
		queueFormation{
			formation	= McvFormation,
			spawnLoc	= ReIn_SpawnEast.Location,
			inWorldLoc	= ReIn_WorldEast.Location,
			targetLoc	= ReIn_EastRock.Location,
			mapEdge		="east",
		}
	else
		queueFormation{
			formation	= McvFormation,
			spawnLoc	= ReIn_SpawnWest.Location,
			inWorldLoc	= ReIn_WorldWest.Location,
			targetLoc	= ReIn_WestRock.Location,
			mapEdge		="west",
		}
	end
end

function spawnFormationActors()
	
	for fKey,rFormation in pairs(SpawningFormations)
	do
		local airborne = rFormation.airborne
		local ucount = 0
		
		for uKey, unit in pairs(rFormation.units)
		do
			unit.spawnDelay = unit.spawnDelay - minDelay
			
			if (unit.spawnDelay < 0)
			then
				local act = Actor.Create( unit.unitType, true,
					{ 
						Owner = beginner,
						Location = CPos.New( unit.spawnLoc.X, unit.spawnLoc.Y ),
						SubCell = unit.SubCell,
						Facing = unit.Facing
					}
				)
				
				if (airborne == true)
				then
					act.Move( CPos.New( unit.inWorldLoc.X, unit.inWorldLoc.Y ) )
				else
					act.MoveIntoWorld( CPos.New( unit.inWorldLoc.X, unit.inWorldLoc.Y ) )
				end
				act.Move( CPos.New( unit.moveLoc.X, unit.moveLoc.Y ) )
				rFormation.units[uKey] = nil --remove unit
			else --found pending unit which didn't spawn this iteration
				ucount = ucount + 1 
				
			end
		end
		
		if (ucount == 0 )
		then
			Beacon.New( beginner, Map.CenterOfCell( rFormation.BeaconLoc ), DateTime.Seconds(10))
			Media.PlaySpeechNotification( beginner, "Reinforce" )
			table.remove( SpawningFormations, fKey ) --remove formation, all of it's units spawned
		end 
	end
end

function getFactionizedUnitType( unitToken )

	local u
	
	if containsKey( units, unitToken ) --regular 1-cell-unit
	then
		local detokenizedUnit = units[unitToken]
		if detokenizedUnit == "combat_tank"
		then
			--combat_tank --> combat_tank_a / combat_tank_h / combat_tank_o
			detokenizedUnit=detokenizedUnit.."_"..getChars(beginner.Faction)[1]
		elseif detokenizedUnit == "trike" and beginner.Faction == "ordos"
		then 
			detokenizedUnit = "raider"
		elseif detokenizedUnit == "faction_special_unit"
		then
			if		beginner.Faction == "ordos" then detokenizedUnit = "stealth_raider"
			elseif	beginner.Faction == "atreides" then detokenizedUnit = "sonic_tank"
			elseif	beginner.Faction == "harkonnen" then detokenizedUnit = "devastator"
			end
		end
		u = { detokenizedUnit }
		
	else -- one or more infantry in the cell
		u = {}
		for _, token in pairs( getChars( unitToken ))
		do
			table.insert( u, units[token] )
		end
	end
	
	return u
	
end

function queueFormation( arg )

	--spawn location of units, usually outside of map
	if not arg.spawnLoc then error( "spawnLoc must not be empty." ) end
	--location where the units first be come part of the game world and move normally
	if not arg.inWorldLoc then error("inWorldLoc must not be empty.") end
	--location the units should move to
	if not arg.targetLoc then error("targetLoc must not be empty.") end
	--unit formation to use for spawning
	if not arg.formation then error("formation must not be empty.") end
	--map edge which the units should come from ("east/west/north or south")
	if not arg.mapEdge then error("mapEdge must not be empty.") end
	--delay which is applied between two formation lines (longitudinal)
	if not arg.perLineDelay then arg.perLineDelay = DateTime.Seconds(1) end
	--cell spacing between unit (stacks) which is applied at the target location
	if not arg.spread then arg.spread = 1 end
	--does the formation contain only airborne units or only ground units?
	if not arg.airborne then arg.airborne = false end
	
	if count(arg) > 8 then error("queueFormation arg has more entries than expected, did you mistype an argument?") end
	
	
	local offsetCoord, fixedCoord, face, longitudinalDirection, transversalDirection
	
	if		(arg.mapEdge == "east")
	then
		offsetCoord = "Y"
		fixedCoord = "X"
		face = Facing.West
		longitudinalDirection = 1
		transversalDirection = 1
	elseif	(arg.mapEdge == "west")
	then
		offsetCoord = "Y"
		fixedCoord = "X"
		face = Facing.East
		longitudinalDirection = -1
		transversalDirection = -1
	elseif	(arg.mapEdge == "north")
	then
		offsetCoord = "X"
		fixedCoord = "Y"
		face = Facing.South
		transversalDirection = 1
		longitudinalDirection = -1
	elseif	(arg.mapEdge == "south")
	then
		offsetCoord = "X"
		fixedCoord = "Y"
		face = Facing.North
		transversalDirection = -1
		longitudinalDirection = 1
	end
	
	local fixedCoordValue = arg.spawnLoc[fixedCoord]
	local fixedInWorldValue = arg.inWorldLoc[fixedCoord]

	local FormationData = {}
	FormationData.airborne = arg.airborne
	FormationData.BeaconLoc = arg.targetLoc
	FormationData.units = {}
	
	--set to maximum longitudinal offset for this line (plus one which is subtracted before first use)
	local OffsetLo = math.floor( count( arg.formation ) / 2 ) + 1 * arg.spread
	--delay set to zero
	local spawnDelay = 0
	
	for _,frontline in pairs( arg.formation )
	do
		OffsetLo = OffsetLo - arg.spread
		frontline = split( frontline , " " )
		
		--set to maximum transversal offset for this line
		local OffsetTr = math.floor(count( frontline ) / 2 ) + 1 * arg.spread
		
		for _, unitToken in pairs( frontline )
		do
			--while taget longitudinal coordinates decrease, the initial spawn delay increases
			OffsetTr = OffsetTr - arg.spread
			
			
			--if empty space palceholder then do nothing
			if not (unitToken=="SPACE") --empty cell
			then
				local unittypes = getFactionizedUnitType( unitToken )
				
				for subcell, unittype in pairs( unittypes )
				do
					if not (unittype=="Nothing") --empty subcell
					then
						local unit = {}
						unit.SubCell = subcell
						unit.Facing = face
						unit.unitType = unittype
						
						unit.spawnLoc = {
											[offsetCoord] = arg.spawnLoc[offsetCoord] - transversalDirection * OffsetTr,
											[fixedCoord] = fixedCoordValue
										}
						unit.inWorldLoc = {
											[offsetCoord] = arg.inWorldLoc[offsetCoord] - transversalDirection * OffsetTr,
											[fixedCoord] = fixedInWorldValue
										}
						unit.moveLoc = {
											[offsetCoord] = arg.targetLoc[offsetCoord] - transversalDirection * OffsetTr,
											[fixedCoord] = arg.targetLoc[fixedCoord] - longitudinalDirection * OffsetLo
										}
						unit.spawnDelay = spawnDelay
						
						table.insert( FormationData.units, unit )
					end
				end
			end
		end
		spawnDelay = spawnDelay + arg.perLineDelay
	end
	table.insert( SpawningFormations, FormationData )
end

function count ( tbl )
	local sum = 0
	for _,x in pairs( tbl )
	do
		sum = sum + 1
	end
	return sum
end

--thanks to adrian mole from stackoverflow for saving me a few minutes
function split (inputstr, sep)
	if sep == nil then
			sep = "%s"
	end
	local t={}
	for str in string.gmatch(inputstr, "([^"..sep.."]+)") do
			table.insert(t, str)
	end
	return t
end

--thanks to RBerteig from stackoverflow for saving me a few minutes 
function getChars( str )
	local chars = {}
	for i = 1, #str do
		local c = str:sub(i,i)
		table.insert( chars, c )
	end
	return chars
end

function containsKey(tbl, sKey)
	for key, _ in pairs(tbl) do
		if key == sKey then return key end
	end
	return false
end
