Badgers={}

WorldLoaded = function()
	--Make anything that is produced check if it needs to add itself to the badger list
	Trigger.OnAnyProduction(function(producer, produced, productionType) TabulateBadgers(produced) end)
end

Echo = function(SomeText)
	UserInterface.SetMissionText(SomeText)
end

TabulateBadgers = function(BadgerID)
	--check if it is ubadg (my custom unit) and if so add id to the list
	if BadgerID.Type == "ubadg" then
		table.insert(Badgers,BadgerID)
	end
end

--This function checks if the weapon is being fired and if so commences the paradrop
BadgerAttackParadrop = function(BadgerID)
	if BadgerID.AmmoCount("primary")<1 then --this should happen whenever the weapon is force fired
		BadgerID.Paradrop(BadgerID.Location) --quick and dirty method. If I've understood the UOE code that works out the actual position of the force fir command and does the drop around there.
		BadgerID.Reload("primary",1) --immediately reload so it is ready to be used again
	end
end

Tick = function()
	--for every badger in the list call the function to check if it should paradrop
	for _,b in pairs(Badgers) do
		if b.IsDead==false then --lua throws an error about lack of AmmoCount on dead badgers if I let the function run for them
			BadgerAttackParadrop(b)
		end
	end
end