HarvestAmmout=12000
MissionText={"Commander, our advance in this funeral plain is facing growing Ordos resistance. Also, the allegiance of the local Mercenaries is unsure yet.","Air reinforcements pour in to strengthen our enemies, but we can also call in reinforcements, once the outpost upgrade is complete.","Either DESTROY all opposing forces or HARVEST ".. tostring(HarvestAmmout) .." solaris worth of spice to complete this mission. --Good luck!",
"Commander, the Atreides are invading our territory! Our intelligence sources indicate the Atreides may also have bribed the Mercenaries in this area. Beware.","DESTROY all attackers threatening this espionage outpost of ours or at least HARVEST a gain of "..tostring(HarvestAmmout).." solaris for our house.","Utilize the Air reinforcements available after an outpost upgrade. --Transmission End",
"Captain, I have received the Atreides answer to our modest price for military aid against the Ordos - Those stuck-ups declined!","I want you to either HARVEST those "..tostring(HarvestAmmout).." solaris from this damned place anyway or to CAST OUT BOTH of those houses from here!","You have my permission to use Air reinforcements after an outpost upgrade. Now go and make money!!"}
Warning={	"Atreides  have over 9000 resources!!\n" ,
			"The Ordos have over 9000 resources!!\n" ,
			"The Mercs have over 9000 resources!!\n" }
			
ResourceVictory=false
Annihillated = { ordos=true,atreides=true,mercenaries=true}	
	
function initializeMission()
	--players
	atreides = Player.GetPlayer("Atreides")
	ordos    = Player.GetPlayer("Ordos")
	mercenaries = Player.GetPlayer("Mercenaries")
	if atreides 
	then 
		Annihillated.atreides=false
		--set starting cash (rules:	PlayerResources: DefaultCashLocked: True currently bugged -> prevents players from joining)
		atreides.Cash =0
	end
	if ordos 
	then 
		Annihillated.ordos=false 
		ordos.Cash=0
	end
	if mercenaries 
	then 
		Annihillated.mercenaries=false 
		mercenaries.Cash=0
	end
	
	--smugglers setup
	smugglers = Player.GetPlayer("Smugglers")
	Trigger.AfterDelay(DateTime.Seconds(0.1),function()
		for _,act in pairs(smugglers.GetActors())
		do 
			if act.Type=="carryall.reinforce" then act.Kill() end
		end
	end)

	--mission text
	if mercenaries 
	then
		--Objectives and Mission
		ObjectiveM = mercenaries.AddPrimaryObjective("Harvest " .. tostring(HarvestAmmout) .. " Solaris worth of Spice or destroy all opposition.")
		Trigger.OnPlayerWon(mercenaries, 
			function(p)
				if Annihillated.ordos and Annihillated.atreides 
				then
					Media.DisplayMessage("The Mercenaries have annihilated all opposition!","Mission Success",HSLColor.Gold) 
				else
					Media.DisplayMessage("The Mercenaries have hoarded 12.000 solaris of spice!","Mission Success",HSLColor.Gold)
				end
			end)
		Trigger.OnPlayerLost(mercenaries, function(p) if not ResourceVictory then annihillate(p) end end)
		if mercenaries.IsLocalPlayer
		then 
			Media.DisplayMessage(MissionText[7],"Boss",HSLColor.Gold)
			Trigger.AfterDelay(DateTime.Seconds(7),function() 
				Media.DisplayMessage(MissionText[8],"Boss",HSLColor.Gold)
				end)
			Trigger.AfterDelay(DateTime.Seconds(14),function() 
				Media.DisplayMessage(MissionText[9],"Boss",HSLColor.Gold)
				end)
		end
	end
	if ordos
	then
		--Objectives and Mission
		ObjectiveO = ordos.AddPrimaryObjective("Harvest " .. tostring(HarvestAmmout) .. " Solaris worth of Spice or destroy all opposition.")
		Trigger.OnPlayerWon(ordos, 
			function(p)
				if Annihillated.mercenaries and Annihillated.atreides 
				then
					Media.DisplayMessage("The Ordos have annihilated all opposition!","Mission Success",HSLColor.LawnGreen) 
				else
					Media.DisplayMessage("The Ordos have hoarded 12.000 solaris of spice!","Mission Success",HSLColor.LawnGreen)
				end
			end)
		Trigger.OnPlayerLost(ordos, function(p) if not ResourceVictory then annihillate(p) end end)
		if ordos.IsLocalPlayer 
		then
			Media.DisplayMessage(MissionText[4],"Mentat",HSLColor.LawnGreen)
			Trigger.AfterDelay(DateTime.Seconds(7),function() 
				Media.DisplayMessage(MissionText[5],"Mentat",HSLColor.LawnGreen)
				end)
			Trigger.AfterDelay(DateTime.Seconds(14),function() 
				Media.DisplayMessage(MissionText[6],"Mentat",HSLColor.LawnGreen)
				end)
		end
	end
	if atreides
	then
		--Objectives and Mission
		ObjectiveA = atreides.AddPrimaryObjective("Harvest " .. tostring(HarvestAmmout) .. " Solaris worth of Spice or destroy all opposition.")
		Trigger.OnPlayerWon(atreides, 
			function(p)
				if Annihillated.ordos and Annihillated.mercenaries 
				then
					Media.DisplayMessage("The Atreides have annihilated all opposition!","Mission Success",HSLColor.Blue) 
				else
					Media.DisplayMessage("The Atreides have hoarded 12.000 solaris of spice!","Mission Success",HSLColor.Blue)
				end
			end)
		Trigger.OnPlayerLost(atreides, function(p) if not ResourceVictory then annihillate(p) end end)
		if atreides.IsLocalPlayer 
		then 
			Media.DisplayMessage(MissionText[1],"Mentat",HSLColor.Blue)
			Trigger.AfterDelay(DateTime.Seconds(7),function() 
				Media.DisplayMessage(MissionText[2],"Mentat",HSLColor.Blue)
				end)
			Trigger.AfterDelay(DateTime.Seconds(14),function() 
				Media.DisplayMessage(MissionText[3],"Mentat",HSLColor.Blue)
				end)
		end
	end	
end

function missionTick()
	--resource victory check
	if atreides and atreides.Cash+atreides.Resources >= HarvestAmmout and not atreides.HasNoRequiredUnits()
	then 
		ResourceVictory=true
		atreides.MarkCompletedObjective(ObjectiveA)
		if ordos then ordos.MarkFailedObjective(ObjectiveO) end
		if mercenaries then mercenaries.MarkFailedObjective(ObjectiveM) end
	end
	if mercenaries and mercenaries.Cash+mercenaries.Resources >= HarvestAmmout and not mercenaries.HasNoRequiredUnits()
	then 
		ResourceVictory=true
		if atreides then atreides.MarkFailedObjective(ObjectiveA) end
		if ordos then ordos.MarkFailedObjective(ObjectiveO) end 
		mercenaries.MarkCompletedObjective(ObjectiveM)
	end
	if ordos and ordos.Cash+ordos.Resources >= HarvestAmmout and not ordos.HasNoRequiredUnits()
	then 
		ResourceVictory=true
		if atreides then atreides.MarkFailedObjective(ObjectiveA) end 
		ordos.MarkCompletedObjective(ObjectiveO)
		if mercenaries then mercenaries.MarkFailedObjective(ObjectiveM) end
	end

	--custom short game defeat check
	if atreides and atreides.HasNoRequiredUnits() then atreides.MarkFailedObjective(ObjectiveA) end
	if mercenaries and mercenaries.HasNoRequiredUnits() then mercenaries.MarkFailedObjective(ObjectiveM) end
	if ordos and ordos.HasNoRequiredUnits() then ordos.MarkFailedObjective(ObjectiveO) end
	
	--spice-meter and victory warnings:
	local warning = ""
	local resourcetext = ""
	local pcolor = HSLColor.Gray
	if not Annihillated.atreides and not atreides.IsLocalPlayer and atreides.Cash+atreides.Resources>9000 then warning = warning..Warning[1] end
	if not Annihillated.ordos and not ordos.IsLocalPlayer and ordos.Cash+ordos.Resources>9000 then warning = warning..Warning[2] end
	if not Annihillated.mercenaries and not mercenaries.IsLocalPlayer and mercenaries.Cash+mercenaries.Resources>9000 then warning = warning..Warning[3] end
	
	if not Annihillated.atreides and atreides.IsLocalPlayer 
	then
		resourcetext = "     Stored resources: " ..tostring(atreides.Cash+atreides.Resources) .. " / " .. HarvestAmmout.."     \n"
		pcolor = atreides.Color
	elseif not Annihillated.ordos and ordos.IsLocalPlayer
	then
		resourcetext = "     Stored resources: " ..tostring(ordos.Cash+ordos.Resources).. " / " .. HarvestAmmout.."     \n"
		pcolor = ordos.Color
	elseif not Annihillated.mercenaries and mercenaries.IsLocalPlayer
	then
		resourcetext = "     Stored resources: " .. tostring(mercenaries.Cash+mercenaries.Resources) .. " / " .. HarvestAmmout.."     \n"
		pcolor = mercenaries.Color
	end
	UserInterface.SetMissionText(resourcetext..warning, pcolor)
end

function annihillate(player)
	if player == atreides then Annihillated.atreides=true
	elseif player == mercenaries then Annihillated.mercenaries=true
	elseif player == ordos then Annihillated.ordos=true end

	for _,act in pairs(player.GetActors())
	do 
		if act.HasProperty("Kill") then act.Kill() end
	end
	
	--annihilation victory check
	if Annihillated.atreides and Annihillated.ordos then mercenaries.MarkCompletedObjective(ObjectiveM) end
	if Annihillated.atreides and Annihillated.mercenaries then ordos.MarkCompletedObjective(ObjectiveO) end
	if Annihillated.mercenaries and Annihillated.ordos then atreides.MarkCompletedObjective(ObjectiveA) end
end
