ToHarvest = 3000
HarkonnenReinforcements = {
	{"light_inf","light_inf","light_inf","light_inf"},
	{"quad","trooper", "trooper", "trooper"},
	{"combat_tank_h"},
	{"engineer"}
	}
TheAtreidesWillFall=0
Percentage={0,0,0}
SupportLocations={}
T_charge={DateTime.Seconds(40),DateTime.Seconds(90),DateTime.Seconds(175)}

WorldLoaded = function()
	--time
	T_reset = {DateTime.GameTime,DateTime.GameTime,DateTime.GameTime,DateTime.GameTime}

	--players:
	harkonnen = Player.GetPlayer("Multi1")
	atreides = Player.GetPlayer("Multi0")
	--set starting cash (rules:	PlayerResources: DefaultCashLocked: True currently bugged -> prevents players from joining)
	harkonnen.Cash=0
	atreides.Cash =0
	
	--buildings:
	refinery = Actor29
	barracks = Actor26
	silos = {Actor24, Actor25, Actor27}
	damageBuildings()
	
	--units
	harvester = Actor6
	dropHarkonnen(ReinforceLeft.Location,4)
	
	--obectives:
	if atreides.IsLocalPlayer
	then
		Media.DisplayMessage("Harvest SPICE in this area.\nYou have ONE HARVESTER to complete your mission, DO NOT LOSE it!\nAlso keep an eye on your SILOS, harkonnen forces are in the area.\n--Good luck! ","Your Mission",HSLColor.Blue)
	elseif harkonnen.IsLocalPlayer 
	then
		Media.DisplayMessage("Keep the atreides scum from harvesting enough spice.\nDESTROY their HARVESTER, REFIENRY or SILOS to stop them!\nThe Duke will send you reinforcements, but you should NOT make him regret his aid!","Your Mission",HSLColor.Red)
	else
			Media.DisplayMessage("Harvest SPICE in this area.\nWe send you one HARVESTER to complete your mission, DO NOT LOSE it!\nAlso keep an eye on your SILOS, harkonnen forces are in the area.\n--Good luck!\n\n.","    Atreides Mission",HSLColor.Blue)
			Media.DisplayMessage("Keep the atreides scum from harvesting enough spice.\nDESTROY their HARVESTER, REFIENRY or SILOS to stop them!\nThe Duke will send you reinforcements, but you should NOT make him regret his aid!","Harkonnen Mission.",HSLColor.Red)
	
	end

	GatherSpice = atreides.AddPrimaryObjective("Harvest " .. tostring(ToHarvest) .. " Solaris worth of Spice.")
	StopHarvestOperations = harkonnen.AddPrimaryObjective("Stop the Atreides from storing enough Spice.")
	Trigger.OnObjectiveCompleted(atreides, 
		function(p, id)
			Media.DisplayMessage("The Atreides have gathered "..tostring(ToHarvest).." solaris of spice!", "Mission Success",HSLColor.Blue) 
			Media.DisplayMessage("The Harkonnen's efforts were futile!", "Mission Failure",HSLColor.Red) 
		end
	)
	Trigger.OnObjectiveCompleted(harkonnen, 
		function(p, id)
			Media.DisplayMessage("The Harkonnen have disrupted harvest operations!", "Mission Success", HSLColor.Red)
			if TheAtreidesWillFall==1 then Media.DisplayMessage("The Atreides harvester is wrecked!", "Mission Failure", HSLColor.Blue)
			elseif TheAtreidesWillFall==2 then Media.DisplayMessage("The Atreides silos have been ransacked. There isn't enough spice storage anymore!", "Mission Failure", HSLColor.Blue)
			elseif TheAtreidesWillFall==3 then Media.DisplayMessage("The Atreides spice refining site has been sabotaged!", "Mission Failure", HSLColor.Blue)
			end
		end
	)
	--harkonnen victory (harvester killed):
	Trigger.OnAllRemovedFromWorld({harvester}, 
		function()
			TheAtreidesWillFall=1
			harkonnen.MarkCompletedObjective(StopHarvestOperations)
		end
	)
	--harkonnen victory (refinery killed):
	Trigger.OnKilledOrCaptured(refinery, 
		function()
			TheAtreidesWillFall=3
			harkonnen.MarkCompletedObjective(StopHarvestOperations)
		end
	)
	--prevents resource loss by silo destroyed
	for iter,silo in pairs(silos) 
		do 	
		Trigger.OnKilledOrCaptured(silo,
			function()
				Trigger.AfterDelay(DateTime.Seconds(0.1),
					function() 
						atreides.Resources = atreides.Resources*(1+2000/atreides.ResourceCapacity)
					end
				)
			end
		)
	end
	
end

Tick = function()
	--spice-meter:
	if atreides.IsLocalPlayer or harkonnen.IsLocalPlayer
	then
		UserInterface.SetMissionText("Stored resources: " .. atreides.Resources .. "/" .. ToHarvest, atreides.Color)
	end
	
	--spectator candy
	local T_current=DateTime.GameTime
	Percentage[1] = math.min((T_current-T_reset[1] )/ T_charge[1],1)
	Percentage[2] = math.min((T_current-T_reset[2] )/ T_charge[2],1)
	Percentage[3] = math.min((T_current-T_reset[3] )/ T_charge[3],1)
	if not atreides.IsLocalPlayer and not harkonnen.IsLocalPlayer
	then
		UserInterface.SetMissionText(
		string.format('Atreides Resources  %4i/%4i                       Harkonnen Reinforcements:  Light %3i%%  |  Medium %3i%%  |  Heavy %3i%%',atreides.Resources,ToHarvest,Percentage[1]*100,Percentage[2]*100,Percentage[3]*100), HSLColor.Red)
	end
	
	--atreides victory?
	if atreides.Resources >= ToHarvest
		then atreides.MarkCompletedObjective(GatherSpice)
	end
	
	--needed for harkonnen airdrop powers
	for iter, act in pairs(harkonnen.GetActors()) 
	do 
		if act.Type=="waypoint_dummy_1" and noDuplicate(act,SupportLocations) 
		then 
			dropHarkonnen(act.Location,1)
			table.insert(SupportLocations, act)
		elseif act.Type=="waypoint_dummy_2" and noDuplicate(act,SupportLocations) 
		then 
			dropHarkonnen(act.Location,2)
			table.insert(SupportLocations, act)
		elseif act.Type=="waypoint_dummy_3" and noDuplicate(act,SupportLocations)
		then 
			dropHarkonnen(act.Location,3)
			table.insert(SupportLocations, act)
		end
	end
	
	--silo storage insufficient check:
	if atreides.ResourceCapacity < ToHarvest and atreides.ResourceCapacity ~= 0
		then 
			TheAtreidesWillFall=2
			harkonnen.MarkCompletedObjective(StopHarvestOperations)
	end	
end

function noDuplicate(actor, actorlist)
  for _, value in pairs(actorlist) do
    if value == actor then
      return false
    end
  end
  return true
end

function dropHarkonnen(location,squad)
	--Carryall reinforcements
	local transport = "carryall.controllable"
	if squad == 4 then transport="carryall" end
	local path = {EntryPoint.Location,location}
	local units = Reinforcements.ReinforceWithTransport(harkonnen, transport, HarkonnenReinforcements[squad], path, {path[2], path[1]})
	--reset spectator candy timer
	T_reset[squad] = DateTime.GameTime
	--if the player took control and the carryall is empty, return it to base and remove it
	local carryall = units[1]
	Trigger.OnPassengerExited(carryall,
		function(carry, pass) 
			if not carry.HasPassengers 
			then 
				carry.Move(path[1]) 
				carry.Destroy() 
			end
		end
	)
end

damageBuildings = function()
	refinery.Health = 1.*refinery.MaxHealth 
	barracks.Health = 0.7*barracks.MaxHealth 
	for iter,silo in pairs(silos) 
		do silo.Health = 1.*silo.MaxHealth 
	end
end