
SovietEntryPoints = { Entry1, Entry2, Entry3, Entry4, Entry5, Entry6, Entry7, Entry8 }
PatrolWaypoints = { Entry2, Entry4, Entry6, Entry8 }
ParadropWaypoints = { Paradrop1, Paradrop2, Paradrop3, Paradrop4 }
SpawnPoints = { Spawn1, Spawn2, Spawn3, Spawn4 }
Snipers = { Sniper1, Sniper2, Sniper3, Sniper4, Sniper5, Sniper6, Sniper7, Sniper8, Sniper9, Sniper10, Sniper11, Sniper12 }

Walls =
{
	{ WallTopRight1, WallTopRight2, WallTopRight3, WallTopRight4, WallTopRight5, WallTopRight6, WallTopRight7, WallTopRight8, WallTopRight9 },
	{ WallTopLeft1, WallTopLeft2, WallTopLeft3, WallTopLeft4, WallTopLeft5, WallTopLeft6, WallTopLeft7, WallTopLeft8, WallTopLeft9 },
	{ WallBottomLeft1, WallBottomLeft2, WallBottomLeft3, WallBottomLeft4, WallBottomLeft5, WallBottomLeft6, WallBottomLeft7, WallBottomLeft8, WallBottomLeft9 },
	{ WallBottomRight1, WallBottomRight2, WallBottomRight3, WallBottomRight4, WallBottomRight5, WallBottomRight6, WallBottomRight7, WallBottomRight8, WallBottomRight9 }
}

Dog = { "megadog" }
Fake = { "fdtrk" }
Civilians = { "c1", "c1", "c3", "c7", "c1", "c7", "c5", "c4", "c1", "c7", "c5", "c4", "c1" }
Yaks = { "yak", "yak" }
Dinos = { "dino", "dino.small", "dino.small" }

Difficulty = Map.LobbyOption("difficulty")
if Difficulty == "veryeasy" then
	ParaChance = 20
	Patrol = { "e1", "e2", "e1" }
	Infantry = { "e4", "e1", "e1", "e2", "e2" }
	Vehicles = { "apc" }
	Tank = { "3tnk" }
	LongRange = { "arty" }
	Boss = { "v2rl" }
	Swarm = { "mini3tnk", "mini3tnk", "mini3tnk" }
	FlameZombies = { "flamezombie", "flamezombie", "flamezombie" }
	DogTanks = { "4tnk.dog" }
	Air = { "flyingdog", "flyingdog" }
elseif Difficulty == "easy" then
	ParaChance = 25
	Patrol = { "e1", "e2", "e1" }
	Infantry = { "e4", "e1", "e1", "e2", "e1", "e2", "e1" }
	Vehicles = { "ftrk", "arty" }
	Tank = { "3tnk" }
	LongRange = { "v2rl" }
	Boss = { "4tnk" }
	Swarm = { "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk" }
	FlameZombies = { "flamezombie", "flamezombie", "flamezombie", "flamezombie" }
	DogTanks = { "4tnk.dog" }
	Air = { "flyingdog", "flyingdog", "flyingdog", "flyingdog" }
elseif Difficulty == "normal" then
	ParaChance = 30
	Patrol = { "e1", "e2", "e1", "e1" }
	Infantry = { "e4", "e1", "e1", "e2", "e1", "e2", "e1" }
	Vehicles = { "ftrk", "ftrk", "arty" }
	Tank = { "3tnk" }
	LongRange = { "v2rl" }
	Boss = { "4tnk" }
	Swarm = { "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk" }
	FlameZombies = { "flamezombie", "flamezombie", "flamezombie", "flamezombie", "flamezombie" }
	DogTanks = { "4tnk.dog" }
	Air = { "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog" }
	Yaks = { "yak", "yak", "yak" }
	Dinos = { "dino", "dino.small", "dino.small", "dino.small" }
elseif Difficulty == "hard" then
	ParaChance = 35
	Patrol = { "e1", "e2", "e1", "e1", "e4" }
	Infantry = { "e4", "e1", "e1", "e2", "e1", "e2", "e1" }
	Vehicles = { "arty", "ftrk", "ftrk" }
	Tank = { "3tnk" }
	LongRange = { "v2rl" }
	Boss = { "4tnk" }
	Swarm = { "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk" }
	FlameZombies = { "flamezombie", "flamezombie", "flamezombie", "flamezombie", "flamezombie", "flamezombie" }
	DogTanks = { "4tnk.dog", "4tnk.dog" }
	Air = { "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog" }
	Yaks = { "yak", "yak", "yak" }
	Dinos = { "dino", "dino", "dino.small", "dino.small", "dino.small", "dino.small" }
else
	ParaChance = 40
	Patrol = { "e1", "e2", "e1", "e1", "e4", "e4" }
	Infantry = { "e4", "e1", "e1", "e2", "e1", "e2", "e1", "e1" }
	Vehicles = { "arty", "arty", "ftrk", }
	Tank = { "ftrk", "3tnk" }
	LongRange = { "v2rl" }
	Boss = { "4tnk" }
	Swarm = { "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk" }
	FlameZombies = { "flamezombie", "flamezombie", "flamezombie", "flamezombie", "flamezombie", "flamezombie", "flamezombie" }
	DogTanks = { "4tnk.dog", "4tnk.dog", "4tnk.dog" }
	Air = { "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog" }
	Yaks = { "yak", "yak", "yak", "yak" }
	Dinos = { "dino", "dino", "dino", "dino.small", "dino.small", "dino.small", "dino.small" }
end

Wave = 0
Waves =
{
	{ delay = 500, units = { Infantry } }, -- , specialUnits = { FlameZombies, Civilians, Fake, DogTanks, Dinos, Swarm, Air, Yaks, Dog, Dinos }
	{ delay = 500, units = { Patrol, Patrol } },
	{ delay = 700, units = { Infantry, Infantry, Vehicles }, },
	{ delay = 1300, units = { Infantry, Infantry, Infantry, Infantry } },
	{ delay = 1400, units = { Infantry, Infantry, Patrol, Vehicles } },
	{ delay = 1400, units = { Infantry, Infantry, Patrol, Infantry, Tank, Vehicles } },
	{ delay = 1400, units = { Infantry, Infantry, Dog, Tank, Vehicles, Infantry } },
	{ delay = 1400, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, LongRange } }, -- lazy copy
	{ delay = 1400, units = { Infantry, Infantry, Patrol, Infantry, Tank, Tank, Swarm }, specialUnits = { Civilians }, supply = true },
	{ delay = 1400, units = { Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry } },
	{ delay = 1400, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, LongRange } },
	{ delay = 1400, units = { Infantry, Infantry, Vehicles, Tank, Tank, LongRange, Dog } },
	{ delay = 1300, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, Infantry, LongRange, Tank, LongRange, Dog }, specialUnits = { FlameZombies } },
	{ delay = 1400, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, Infantry, Infantry, LongRange, LongRange, Tank, Tank, Vehicles } },
	{ delay = 1400, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Boss, Dog, Swarm }, supply = true }
}

SpecialWaves = { Utils.Random({ FlameZombies, Yaks }), Utils.Random({ Civilians, Air }) }

-- Now do some adjustments to the waves
if not (Difficulty == "veryeasy" or Difficulty == "easy") then
	Waves[6] = { delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Tank, Vehicles }, specialUnits = { Fake } }
	SpecialWaves = { Utils.Random({ DogTanks, FlameZombies, Yaks }), Utils.Random({ Civilians, Air, Dinos }) }
end

if Difficulty == "tough" or Difficulty == "endless" then
	Waves[8] = { delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry }, ironUnits = { LongRange } }
	Waves[9] = { delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, Infantry, Infantry, LongRange, LongRange, Vehicles, Tank }, ironUnits = { Tank } }
	Waves[11] = { delay = 1500, units = { Vehicles, Infantry, Patrol, Patrol, Patrol, Infantry, LongRange, Tank, Boss, Dog, Dog, Infantry, Infantry, Patrol } }
	SpecialWaves = { DogTanks, FlameZombies, Civilians, Air, Yaks, Dinos }
end

SendUnits = function(entryCell, unitTypes, targetCell, extraData)
	Reinforcements.Reinforce(soviets, unitTypes, { entryCell }, 40, function(a)
		if not a.HasProperty("AttackMove") then
			Trigger.OnIdle(a, function(a)
				a.Move(targetCell)
			end)
			return
		end

		a.AttackMove(targetCell)

		-- Air units are special...
		if a.Type == "flyingdog" then
				Trigger.OnIdle(a, function(a)
					FindTargetFor(a)
				end)
			return
		end

		Trigger.OnIdle(a, function(a)
			a.Hunt()
		end)

		if extraData == "IronCurtain" then
			a.GrantCondition("invulnerability", DateTime.Seconds(25))
		end
	end)
end

-- TODO: Add this to the Lua API
VectorHorizontalLength = function(vec)
	return math.sqrt(vec.X * vec.X + vec.Y * vec.Y)
end

SendWave = function()
	Wave = Wave + 1
	local wave = Waves[Wave]

	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(SovietEntryPoints).Location
			local target = Utils.Random(SpawnPoints).Location

			SendUnits(entry, units, target)
		end)

		if wave.ironUnits then
			Utils.Do(wave.ironUnits, function(units)
				local entry = Utils.Random(SovietEntryPoints).Location
				local target = Utils.Random(SpawnPoints).Location

				SendUnits(entry, units, target, "IronCurtain")
			end)
		end

		if wave.specialUnits then
			local specialists = wave.specialUnits
			wave.specialUnits = nil
			Utils.Do(specialists, function(units)
				local entry = Utils.Random(SovietEntryPoints).Location
				local target = Utils.Random(SpawnPoints).Location

				if units[1] == "yak" then
					Utils.Do(Yaks, function(yakType)
						local start = Map.CenterOfCell(entry) + WVec.New(0, 0, Actor.CruiseAltitude("yak"))
						local vector = Map.CenterOfCell(target) - start
						local hLen = VectorHorizontalLength(target - entry)
						local yak = Actor.Create("yak", true, { CenterPosition = start, Owner = soviets, Facing = vector.Facing })

						yak.Move(target - CVec.New((target - entry).X * 5 / hLen, (target - entry).Y * 5 / hLen))
						yak.CallFunc(yak.Kill)
					end)
				else
					SendUnits(entry, units, target)
				end

				SelectNewWaveForSpecialists(units)
			end)
		end

		Utils.Do(players, function(player)
			Media.PlaySpeechNotification(player, "EnemyUnitsApproaching")
		end)

		if wave.supply then
			local d = wave.delay - DateTime.Seconds(30)
			if d < DateTime.Seconds(30) then
				d = DateTime.Seconds(30)
			end

			Trigger.AfterDelay(d, SupplyWave)
		end

		if (Wave < #Waves) then
			if Utils.RandomInteger(1, 100) < ParaChance then
				local aircraft = ParaProxy.ActivateParatroopers(Utils.Random(ParadropWaypoints).CenterPosition)
				Utils.Do(aircraft, function(a)
					Trigger.OnPassengerExited(a, function(t, passenger)
						Trigger.OnIdle(passenger, function(p)
							if p.IsInWorld then
								p.Hunt()
							end
						end)
					end)
				end)

				local delay = Utils.RandomInteger(DateTime.Seconds(20), DateTime.Seconds(45))
				Trigger.AfterDelay(delay, SendWave)
			else
				SendWave()
			end

			SurvivedWavesCount = SurvivedWavesCount + 1
			if Difficulty == "endless" then
				UserInterface.SetMissionText("Waves: " .. SurvivedWavesCount, TimerColor)
			else
				UserInterface.SetMissionText("Waves: " .. SurvivedWavesCount .. "/" .. #Waves, TimerColor)
			end
		else
			if Difficulty == "endless" then
				Wave = 0
				IncreaseDifficulty()
				Trigger.AfterDelay(DateTime.Minutes(1), SendWave) -- 3

				SurvivedWavesCount = SurvivedWavesCount + 1
				UserInterface.SetMissionText("Waves: " .. SurvivedWavesCount, TimerColor)
				return
			end

			Trigger.AfterDelay(DateTime.Minutes(1), SovietsRetreating)
			Media.DisplayMessage("You almost survived the onslaught! No more waves incoming.")
			FinishWaveCounter()
		end
	end)
end

SovietsRetreating = function()
	Utils.Do(Snipers, function(a)
		if not a.IsDead and a.Owner == soviets then
			a.Destroy()
		end
	end)
end

IncreaseDifficulty = function()
	local additions = { Infantry, Patrol, Vehicles, Tank, LongRange, Dog, Boss, Swarm }
	Utils.Do(Waves, function(wave)
		wave.units[#(wave.units) + 1] = Utils.Random(additions)
	end)
end

AllSupplies = { "powerproxy.parabombs", "powerproxy.heal", "Cash", "powerproxy.ironcurtain", "powerproxy.minidrop", "powerproxy.tanyadrop", "powerproxy.mechdrop" }
AllSupplyNames = { "Parabombs!", "a single-use Instant Healing power!", "$500!", "a single-use Iron Curtain power!", "a Heavy Tank drop!", "a Tanya drop!", "a 'mechanical' drop!" }
Supplies = { "powerproxy.parabombs", "powerproxy.heal", "Cash", "powerproxy.ironcurtain" }
SupplyNames = { "Parabombs!", "a single-use Instant Healing power!", "$500!", "a single-use Iron Curtain power!" }

SupplyWave = function()
	Utils.Do(players, function(player)
		if player.IsBot then
			player.Cash = player.Cash + 500

			local barrack = player.GetActorsByType("tent")
			if #barrack > 0 then
				Media.FloatingText("+$500", barrack[1].CenterPosition, 30, player.Color)
			end

			Media.DisplayMessage(player.Name .. " got $500!", "Supply-Wave")

			return
		end

		local supply = Utils.RandomInteger(0, #Supplies) + 1
		if Supplies[supply] == "Cash" then
			player.Cash = player.Cash + 500

			local barrack = player.GetActorsByType("tent")
			if #barrack > 0 then
				Media.FloatingText("+$500", barrack[1].CenterPosition, 30, player.Color)
			end
		else
			Actor.Create(Supplies[supply], true, { Owner = player })
		end

		Media.DisplayMessage(player.Name .. " got " .. SupplyNames[supply], "Supply-Wave")
	end)

	-- Add two new possible supplies
	local i = Utils.RandomInteger(0, #AllSupplies) + 1
	Supplies[#Supplies + 1] = AllSupplies[i]
	SupplyNames[#SupplyNames + 1] = AllSupplyNames[i]

	i = Utils.RandomInteger(0, #AllSupplies) + 1
	Supplies[#Supplies + 1] = AllSupplies[i]
	SupplyNames[#SupplyNames + 1] = AllSupplyNames[i]

	-- TODO: better supplies over time, remove weak ones
end

SelectNewWaveForSpecialists = function(specialists, skip, upper)
	if not skip or skip >= #Waves then
		skip = 0
	end

	if not upper or upper <= skip then
		upper = #Waves
	end

	local i = Utils.RandomInteger(skip, upper) + 1
	if Waves[i].specialUnits then
		Waves[i].specialUnits[#(Waves[i].specialUnits) + 1] = specialists
	else
		Waves[i].specialUnits = { specialists }
	end
end

FindTargetFor = function(airunit)
	local enemies = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(self) return self.Type ~= "brik" and self.HasProperty("Health") and Utils.Any(players, function(player) return self.Owner == player end) end)
	if #enemies > 0 then
		local enemy = Utils.Random(enemies)
		airunit.AttackMove(enemy.Location)
		airunit.Attack(enemy)
	else
		-- Avoide lags when all units are killed
		Trigger.ClearAll(airunit)
	end
end

Tick = function()
	-- Perf: access to local variables is faster... in theory
	local Utils = Utils

	if Utils.RandomInteger(1, 200) == 10 then
		local delay = Utils.RandomInteger(1, 10)
		Lighting.Flash("LightningStrike", delay)

		Trigger.AfterDelay(delay, function()
			Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
		end)
	end

	if Utils.RandomInteger(1, 200) == 10 then
		Media.PlaySound("thunder-ambient.aud")
	end
end

SetupWallOwners = function()
	Utils.Do(players, function(player)
		Utils.Do(Walls[player.Spawn], function(wall)
			wall.Owner = player
		end)
	end)
end

TimerColor = HSLColor.Red
SurvivedWavesCount = 0
FinishWaveCounter = function()
	for i = 0, 5, 1 do
		local c = TimerColor
		if i % 2 == 0 then
			c = HSLColor.White
		end

		Trigger.AfterDelay(DateTime.Seconds(i), function() UserInterface.SetMissionText("Final wave approaching!", c) end)
	end
	Trigger.AfterDelay(DateTime.Seconds(6), function() UserInterface.SetMissionText("") end)
end

WorldLoaded = function()
	soviets = Player.GetPlayer("Soviets")
	players = { }
	for i = 0, 4, 1 do
		local player = Player.GetPlayer("Multi" ..i)
		players[i] = player

		if players[i] and players[i].IsBot then
			ActivateAI(players[i], i)
		end
	end

	Media.DisplayMessage("Defend Fort Lonestar at all costs!")
	Media.DisplayMessage("This version is VERY balanced!", "WARNING")

	SetupWallOwners()

	Utils.Do(SpecialWaves, function(special)
		SelectNewWaveForSpecialists(special, 5)
	end)

	if Difficulty == "endless" then
		UserInterface.SetMissionText("Waves: 0", TimerColor)
	else
		UserInterface.SetMissionText("Waves: 0/" .. #Waves, TimerColor)
	end

	ParaProxy = Actor.Create("powerproxy.paratroopers", false, { Owner = soviets })
	SendWave()
end
