
punishmentLevels = {
  {
    description = "Player <PLAYER> took too many derricks.\nHis punishment will start gently as a friendly reminder to be less greedy in the future.",
    units = {"zombie"}, repeats = 3},
  {
    description = "The punishment will continue until <PLAYER> has been stripped of his excess derricks.",
    units = {"zombie", "zombie", "zombie"}, repeats = 3
  },
  {
    description = "Ouh, <PLAYER> likes it rough!",
    units = {"zombie", "zombie", "zombie", "ant", "ant", "ant"}, repeats = 5
  },
  {
    description = "Does <PLAYER> even understand I can just punish him in an infinite for-loop?",
    units = {"ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant"}, repeats = 1
  },
  {
    description = "while true do sendAnts()\nant, ant, ant...",
    units = {"ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant", "ant" }, repeats = 2 },
  {
    description = "Final stage of <PLAYER>'s punishment: A bare bottom spanking.",
    units = { "dog.bomb" }, repeats = 10
  },
  {
    description = "A good spanking should always end in tears.",
    units = { "dog.nuke" }, repeats = 0
  }
}

descriptionsFurtherOffenders = {
  "And another one.\n<PLAYER> just joined the club of greedy players.",
  "A third one. Really? <PLAYER> also desires punishment.",
  "A fourth one? Is that even possible? Well. <PLAYER> asked for it, so he shall have it.",
  "Now I am really confused. But <PLAYER> seems to be greedy as well. How many assholes can there be?"
}
freeForAllTime = 7

activePunishments = {}
highestPunishmentLevel = 0

freeForAllTimeReached = 0
spawnPoints = {}
greedyPlayers = {}
numGreedyPlayers = 0 -- wow. there is no length method for tables in lua. so this hack is needed.

-- Add all spawns to the list spawnPoints. It seems the order is the same as indicated by player.Spawn.
-- Sadly I did not find a section in the documentation about this. Is there really no easier way to get the
-- spawn of a player? It seems, the spawn actor is not added to the player itself.
Utils.Do(Map.NamedActors, function(a)
  if a.Type == "mpspawn" then
    table.insert(spawnPoints,a);
  end
end)


countNumberOfHumanPlayers = function()
  local count = 0
  Utils.Do(Player.GetPlayers(nil), function(p)
      if not p.IsNonCombatant and not p.IsBot then
        count = count + 1
      end
  end)
  return count
end

countTotalNumberOfDerricks = function()
  local count = 0
  Utils.Do(Map.NamedActors, function(a)
      if a.Type == "oilb" then
        count = count + 1
      end
  end)
  return count
end

countMaxNumberOfDerricksPerPlayer = function(numDerricks, numPlayers)
  offset = 4  -- the 4 derricks at the center of this particular map...
  return math.floor(0.5 + (numDerricks - offset) / numPlayers)
end

hasTakenTooManyDerricksFromTeam = function(player, numDerricks, maxNum)
  print(" checking greediness: " ..player.InternalName .. ", " .. tostring(numDerricks) .. " >? " .. tostring(maxNum))
  if numDerricks > maxNum then
    return true
  else
    return false
  end
end

numberOfHumanPlayers = countNumberOfHumanPlayers()
totalNumberOfDerricks = countTotalNumberOfDerricks()
maxNumberOfDerricksPerPlayer = countMaxNumberOfDerricksPerPlayer(totalNumberOfDerricks, numberOfHumanPlayers)
print("There are " .. tostring(totalNumberOfDerricks - 4) .. " oil derricks for " .. tostring(numberOfHumanPlayers) .. " human players")
Media.DisplayMessage("Don't take more than " .. tostring(maxNumberOfDerricksPerPlayer) .. " oil derricks in the first "
        .. tostring(freeForAllTime) .. " minutes.\nGreedy players will be punished.")

findClosestWaypoint = function(cPos)
  result = nil
  closestDist = 9999999

  Utils.Do(Map.NamedActors, function(a)
    if a.Type == "waypoint" then
      d = (a.Location.X - cPos.X)^2 + (a.Location.Y - cPos.Y)^2
      if d < closestDist then
        closestDist = d
        result = a.Location
      end
    end
  end)
  return result
end

getSideOfMap = function(actor)
  -- return 0 for left side, 1 for undetermined (~center) and 2 for right side.
  local thresholdLeft = 50
  local thresholdRight = 75

  if actor.Location.X < thresholdLeft then
    return 0
  end

  if actor.Location.X > thresholdRight then
    return 2
  end

  return 1
end

getNumberOfOilDerricksBelongingToSameTeam = function(player)
  local count = 0
  local sideOfPlayer = getSideOfMap(spawnPoints[player.Spawn])

  Utils.Do(player.GetActorsByType("oilb"), function(oilb)
      if sideOfPlayer == getSideOfMap(oilb) then
        count = count + 1
      end
  end)
  return count
end

retrieveAndUpdateGreediness = function(player)
  local numDerricks = getNumberOfOilDerricksBelongingToSameTeam(player)

  print("Player: " .. player.InternalName .. " got " .. numDerricks .. " oilb")
  local hasTooManyDerricks = hasTakenTooManyDerricksFromTeam(player, numDerricks, maxNumberOfDerricksPerPlayer)

  if freeForAllTimeReached == 0 and hasTooManyDerricks and not greedyPlayers[player.InternalName] then
    numGreedyPlayers = numGreedyPlayers + 1
    greedyPlayers[player.InternalName] = true
  end

  if hasTooManyDerricks and greedyPlayers[player.InternalName] then
    print("Player " .. player.Name .. " is greedy! ")
    return true
  end
  return false
end

mainLoop = function()
  print("Main loop. GameTime: " .. tostring(DateTime.GameTime))

  if DateTime.GameTime > DateTime.Minutes(freeForAllTime) then
    if freeForAllTimeReached == 0 then
        local s = tostring(freeForAllTime) .. " Minutes are over."
        if numGreedyPlayers > 0 then
          s = s .. "\nEverybody who was NOT greedy before, may take what ever derricks are left now."
        else
          s = s .. "\nFeel free to take any remaining oil derricks now."
        end
        Media.DisplayMessage(s)
        freeForAllTimeReached = 1
    end
  end

  ignores={["Neutral"]=1, ["Creeps"]=1, ["Everyone"]=1}
  Utils.Do(Player.GetPlayers(nil), function(player)
    if ignores[player.InternalName] or player.IsBot then return end
    local currentPunishment = getCurrentPunishment(player)
    print("currentPunishment " .. tostring(currentPunishment.level) .. ", " .. tostring(currentPunishment.active))
    if not currentPunishment.active then
      print("starting fresh punishment cycle")
      -- checking for greediness is done in the punishment routine
      punish(player)
    end
  end)
  print(" ")
  Trigger.AfterDelay(DateTime.Seconds(10), mainLoop)
end

replacePlayerName = function(templateString, player)
  return string.gsub(tostring(templateString), "<PLAYER>", tostring(player.Name))
end

getCurrentPunishment = function(player)
  if not activePunishments[player.InternalName] then
    activePunishments[player.InternalName] = {level=1, currentRep=1, active=false, target=punishmentLevels[1]}
  end
  return activePunishments[player.InternalName]
end

punish = function(player)
  print("punish")

  local currentPunishment = getCurrentPunishment(player)
  local targetPunishment = punishmentLevels[currentPunishment.level]
  print("active punishment for " .. player.InternalName .. " level: " .. tostring(currentPunishment.level) .. ", rep: " .. tostring(currentPunishment.currentRep))
  print("highestPunishmentLevel: " .. tostring(highestPunishmentLevel))

  local isCurrentlyGreedy = retrieveAndUpdateGreediness(player)
  if not isCurrentlyGreedy then
    print("player is currently not greedy. exiting.")
    currentPunishment.active = False
    return
  end

  if currentPunishment.level > highestPunishmentLevel then
    highestPunishmentLevel = currentPunishment.level
    local s = replacePlayerName(targetPunishment.description, player)
    -- Careful: This crashes if return value of replacePlayerName is not stored in temporary variable
    Media.DisplayMessage(s)
  end

  if currentPunishment.level == 1 and currentPunishment.currentRep == 1 and highestPunishmentLevel >= 1 then
    print("further offender " .. tostring(numGreedyPlayers - 1))
    local description = descriptionsFurtherOffenders[numGreedyPlayers - 1]
    if not description then
      print("ERROR. no description for further offender found")
    else
      -- because the other DisplayMessage fails without a temporary variable, I introduce one here as well.
      local s = replacePlayerName(description, player)
      Media.DisplayMessage(s)
    end
  end

  local sideOfPlayer = getSideOfMap(spawnPoints[player.Spawn])
  local numAttacks = 0
  local maxNumberOfAttacks = 1

  local oilbs = Utils.Shuffle(player.GetActorsByType("oilb"))

  Utils.Do(oilbs, function(oilb)
    if numAttacks >= maxNumberOfAttacks then return end
    -- only target derricks on the same side
    if sideOfPlayer ~= getSideOfMap(oilb) then return end
    closestWaypoint = findClosestWaypoint(oilb.Location)
    local p = player
    sendAIUnits({ closestWaypoint, oilb.Location }, targetPunishment.units, 10, p)
    numAttacks = numAttacks + 1
  end)

  if currentPunishment.currentRep < targetPunishment.repeats or targetPunishment.repeats == 0
  then
    currentPunishment.currentRep = currentPunishment.currentRep + 1
  else
    currentPunishment.level = currentPunishment.level + 1
    currentPunishment.currentRep = 1
  end
  currentPunishment.active = true
end

sendAIUnits = function(entryPath, unitTypes, interval, p)
  print("sending AI units!")
  local units = Reinforcements.Reinforce(Player.GetPlayer("Creeps"), unitTypes, entryPath, interval)
  Trigger.OnAllKilled(units, function()
    print("all punishers are dead. will send new ones in 2 seconds.")
    Trigger.AfterDelay(DateTime.Seconds(2), function() punish(p) end)
  end)
end

WorldLoaded = function()
  Trigger.AfterDelay(10, mainLoop)
end
