SetupPlayers = function()
	Multi0 = Player.GetPlayer("Multi0")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Humans = { Multi0, Multi1, Multi2, Multi3 }
end

GetandsetFlagsRepeater = function()
	Trigger.AfterDelay(DateTime.Seconds(3), function()
		FuseFlag1Cell()
		FuseFlag2Cells()
		if Mode == "materia" then
			FuseFlag7Cells()
		end
		GetandsetFlagsRepeater()
	end)
end

FuseFlag1Cell = function()
	Utils.Do(Humans, function(player)
		local flagactors = player.GetActorsByType("ctflag")
		for p,flag in pairs(flagactors) do
			if not flag.HasTag("isfused1") then
				flag.AddTag("isfused1")
				Trigger.OnEnteredProximityTrigger(flag.CenterPosition, WDist.FromCells(1), function(a, id)
					local mine = flag.Owner
					local yours = a.Owner
					if a.HasTag("flagholdingunit") and mine == yours then	
						a.Stop()
						a.Kill()
					elseif mine ~= yours and a.Type == "ctflag" and mine.IsAlliedWith(yours) == true then
						NewPositionFlag = Actor.Create("ctflag", true, { Location = a.Location + CVec.New(Utils.RandomInteger(-1, 2), 1), Owner = yours })
						a.Destroy()
					elseif mine ~= yours and a.Type ~= "mcv" and a.Type ~= "truk" and a.Type ~= "ctfmcv" and a.Type ~= "dpctflag" and a.HasProperty("GrantCondition") and a.AcceptsCondition("flagholder") and not a.HasTag("flagholdingunit") then
						if Mode == "materia" and mine.IsAlliedWith(yours) == true then
							return
						else
							Trigger.RemoveProximityTrigger(id)
							if mine.IsLocalPlayer then
								SetCamera(mine)
							end
							Beacon.New(mine, a.CenterPosition, 100, true)
							a.AddTag("flagholdingunit")
							a.GrantCondition("flagholder", 0)
							a.GrantCondition("hold" .. mine.InternalName .. "flag", 0)
							if DateTime.GameTime < DateTime.Minutes(5) then
								a.GrantCondition("snailspeed", 0)
							elseif DateTime.GameTime < DateTime.Minutes(7) then
								a.GrantCondition("turtlespeed", 0)
							else
								a.GrantCondition("frogspeed", 0)
							end
							flag.Destroy()
							Trigger.OnKilled(a, function()
								Flag = Actor.Create("ctflag", true, { Location = a.Location, Owner = mine })
							end)
						end
					end
				end)
			end
		end
	end)
end

FuseFlag2Cells = function()
	Utils.Do(Humans, function(player)
		local flagactors = player.GetActorsByType("ctflag")
		for p,flag in pairs(flagactors) do
			if not flag.HasTag("isfused2") then
				flag.AddTag("isfused2")
				Trigger.OnEnteredProximityTrigger(flag.CenterPosition, WDist.FromCells(2), function(a, id)
					local mine = flag.Owner
					local yours = a.Owner
					if flag.IsDead then
						Trigger.RemoveProximityTrigger(id)
						return
					end
					if Mode == "materia" then
						if a.Type == "sbag" or a.Type == "fenc" then
							yours.Cash = yours.Cash + 10
							Media.FloatingText("10 $", a.CenterPosition, 40, yours.Color)
							a.Destroy()
						end
					end
					if a.Type == "ctflag" and mine.IsAlliedWith(yours) ~= true then
						Media.DisplayMessage("" .. mine.Name .. " captured " .. yours.Name .. "s flag!", "Materia", HSLColor.Red)
						DeadplayersFlag = Actor.Create("dpctflag", true, { Location = a.Location + CVec.New(Utils.RandomInteger(-1, 2), Utils.RandomInteger(0, 2)), Owner = yours })
						Media.FloatingText("+ " .. (mine.Experience/2) .. " Exp Bonus", flag.CenterPosition, 85, mine.Color)
						mine.Experience = mine.Experience + mine.Experience/2
						a.Destroy()
						Trigger.AfterDelay(DateTime.Seconds(1), function()
							allactors = yours.GetActors()
							for i,v in pairs(allactors) do
								if v.HasProperty("Health") and v.Type ~= "dpctflag" then
									v.Stop()
									v.Kill()
								end
							end
						end)
					end
				end)
			end
		end
	end)
end

FuseFlag7Cells = function()
	Utils.Do(Humans, function(player)
		local flagactors = player.GetActorsByType("ctflag")
		for p,flag in pairs(flagactors) do
			if not flag.HasTag("isfused3") then
				flag.AddTag("isfused3")
				Trigger.OnEnteredProximityTrigger(flag.CenterPosition, WDist.FromCells(7), function(a, id)
					if flag.IsDead then
						Trigger.RemoveProximityTrigger(id)
						return
					elseif a.Type == "brik" then
						local yours = a.Owner
						yours.Cash = yours.Cash + 15
						Media.FloatingText("15 $", a.CenterPosition, 40, yours.Color)
						a.Destroy()
					end
				end)
			end
		end
	end)
end

StartingUnitsCheck = function()
	Utils.Do(Humans, function(player)
		MCV = player.GetActorsByType("mcv")
		for p,mobcon in pairs(MCV) do
			CTFMCV = Actor.Create("ctfmcv", true, { Location = mobcon.Location, Owner = mobcon.Owner, Facing = 125  })
			CTFMCV.GrantCondition("flagholder", 0)
			CTFMCV.GrantCondition("frogspeed", 0)
			CTFMCV.GrantCondition("hold" .. CTFMCV.Owner.InternalName .. "flag", 0)
			if CTFMCV.Owner.IsBot then
				CTFMCV.Deploy()
			end
			mobcon.Destroy()
		end
	end)
end

SetCamera = function(Multi)
	local PlayerFlag = Multi.GetActorsByType("ctflag")[1]
	if PlayerFlag ~= nil then
		Camera.Position = PlayerFlag.CenterPosition
	end
end

PlayerNotifications = function()
	Trigger.AfterDelay(DateTime.Seconds(3), function()
		Media.DisplayMessage("Capture the enemys flag with any vehicle and bring it to your own flag to defeat him!", "Materia", HSLColor.Red)
		Trigger.AfterDelay(DateTime.Seconds(6), function()
			Media.DisplayMessage("The speed of vehicles wich carry the flag will be reduced!\n\nIf it is destroyed it will throw the flag to the ground!", "Materia", HSLColor.Red)
			Trigger.AfterDelay(DateTime.Seconds(6), function()
				Media.DisplayMessage("Iron curtain and chronosphere doesnt work for the flagholding unit!", "Materia", HSLColor.Red)
				Trigger.AfterDelay(DateTime.Seconds(6), function()
					if Mode == "materia" then
						Media.DisplayMessage("Mode 1 was set in Lobby, that means no concrete walls can be build in the rangecircle around the flag and teammates cant take your flag.", "Materia", HSLColor.Red)
					else
						Media.DisplayMessage("Mode 2 was set in Lobby, that means there are no buildrestrictions for walls and teammates can carry your flag.", "Materia", HSLColor.Red)
					end
				end)
			end)
		end)
	end)
end

Mode = Map.LobbyOption("ctf")

WorldLoaded = function()
	if Mode ~= "noctf" then
		SetupPlayers()
		GetandsetFlagsRepeater()
		StartingUnitsCheck()
		PlayerNotifications()
	end
end
