ChooseHPA1 =
{
	{ type = "hpad", pos = CPos.New(85, 62), cost = 500 }
}

BuildHPA1 = function()
	if not CheckExistenceForFAC1() then
		Trigger.AfterDelay(DateTime.Seconds(1), BuildHPA1)
		return
	end

	for i,v in ipairs(ChooseHPA1) do
		if not v.exists then
			PlaceHPA1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildHPA1)
end

PlaceHPA1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			Trigger.AfterDelay(DateTime.Seconds(1), BuildHPA1)
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildHPA1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildHPA1)
	end)
end

CheckHealthForHPA1 = function()
	Trigger.OnDamaged(HPA1, function()
		if HPA1.Owner == Player1 and HPA1.Health < HPA1.MaxHealth * 3/4 then
			HPA1.StartBuildingRepairs()
		end
		if HPA1.Owner == Player1 and HPA1.Health < HPA1.MaxHealth * 1/4 then
			HPA1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(HPA1, BuildHPA1)
end