SetupPlayers = function()
	Multi0 = Player.GetPlayer("Multi0")
	Multi1 = Player.GetPlayer("Multi1")
	Humans = { Multi0, Multi1 }
end

GetandsetFlagsRepeater = function()
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		FuseFlag()
		GetandsetFlagsRepeater()
	end)
end

FuseFlag = function()
	Utils.Do(Humans, function(player)
		local flagactors = player.GetActorsByType("ctflag")
		for p,flag in pairs(flagactors) do
			if not flag.HasTag("isfused") then
				Trigger.OnEnteredProximityTrigger(flag.CenterPosition, WDist.FromCells(1), function(a, id)
					flag.AddTag("isfused")
					local mine = flag.Owner
					local yours = a.Owner
					if a.HasTag("flagholdingunit") and mine == yours then
						a.Stop()
						a.Kill()
					elseif a.Type == "ctflag" and mine.IsAlliedWith(yours) ~= true then
						Media.DisplayMessage("" .. mine.Name .. " captured " .. yours.Name .. "s flag!", "Materia", HSLColor.Red)
						DeadplayersFlag = Actor.Create("dpctflag", true, { Location = a.Location + CVec.New(Utils.RandomInteger(-1, 2), Utils.RandomInteger(0, 2)), Owner = yours })
						a.Destroy()
						allactors = yours.GetActors()
						for i,v in pairs(allactors) do
							if v.HasProperty("Health") then
								v.Stop()
								v.Kill()
							end
						end
					elseif mine ~= yours and  mine.IsAlliedWith(yours) ~= true and a.Type ~= "mcv" and a.Type ~= "ctfmcv" and a.HasProperty("GrantCondition") and a.AcceptsCondition("flagholder") and not a.HasTag("flagholdingunit") then
						Trigger.RemoveProximityTrigger(id)
						a.AddTag("flagholdingunit")
						a.GrantCondition("flagholder", 0)
						flag.Destroy()
						Trigger.OnKilled(a, function()
							Flag = Actor.Create("ctflag", true, { Location = a.Location, Owner = mine })
						end)
					end
				end)
			end
		end
	end)
end

StartingUnitsCheck = function()
	Utils.Do(Humans, function(player)
		MCV = player.GetActorsByType("mcv")
		for p,mobcon in pairs(MCV) do
			CTFMCV = Actor.Create("ctfmcv", true, { Location = mobcon.Location, Owner = mobcon.Owner, Facing = 125  })
			CTFMCV.GrantCondition("flagholder", 0)
			if CTFMCV.Owner.IsBot then
				CTFMCV.Deploy()
			end
			mobcon.Destroy()
		end
	end)
end

WorldLoaded = function()
	SetupPlayers()
	GetandsetFlagsRepeater()
	StartingUnitsCheck()
	Trigger.AfterDelay(DateTime.Seconds(3), function()
		Media.DisplayMessage("Capture the enemys flag with any vehicle and bring it to your own flag to defeat him!", "Materia", HSLColor.Red)
		Trigger.AfterDelay(DateTime.Seconds(5), function()
			Media.DisplayMessage("The speed of vehicles wich carry the flag will be reduced!\n\nIf it is destroyed it will throw the flag to the ground!", "Materia", HSLColor.Red)
			Trigger.AfterDelay(DateTime.Seconds(5), function()
				Media.DisplayMessage("Iron curtain and chronosphere doesnt work for the flagholding unit!", "Materia", HSLColor.Red)
			end)
		end)
	end)
end
