ChooseIRO1 =
{
	{ type = "iron", pos = CPos.New(61, 63), cost = 1500 }
}

BuildIRO1 = function()
	if not CheckExistenceForFAC1() then
		Trigger.AfterDelay(DateTime.Seconds(1), BuildIRO1)
		return
	end

	for i,v in ipairs(ChooseIRO1) do
		if not v.exists then
			PlaceIRO1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildIRO1)
end

PlaceIRO1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			Trigger.AfterDelay(DateTime.Seconds(1), BuildIRO1)
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildIRO1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildIRO1)
	end)
end

CheckHealthForIRO1 = function()
	Trigger.OnDamaged(IRO1, function()
		if IRO1.Owner == Player1 and IRO1.Health < IRO1.MaxHealth * 3/4 then
			IRO1.StartBuildingRepairs()
		end
		if IRO1.Owner == Player1 and IRO1.Health < IRO1.MaxHealth * 1/4 then
			IRO1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(IRO1, BuildIRO1)
end