FIXExists = true
WEAPExists = true

NormalUnitTypes =
{
	{ "dog", "dog", "dog", "dog", "dog" },
	{ "e1", "e1", "e1", "e1", "e1" },
	{ "e2", "e2", "e2", "e2", "e2" },
	{ "e3", "e3", "e3", "e3", "e3" },
	{ "e4", "e4", "e4", "e4", "e4" },
	{ "jeep", "jeep", "jeep", "jeep", "jeep" },
	{ "1tnk", "1tnk", "1tnk", "1tnk", "1tnk" },
	{ "2tnk", "2tnk", "2tnk", "2tnk", "2tnk" },
	{ "3tnk", "3tnk", "3tnk", "3tnk", "3tnk" },
	{ "4tnk", "4tnk", "4tnk", "4tnk", "4tnk" },
	{ "apc", "apc", "apc", "apc", "apc" },
	{ "arty", "arty", "arty", "arty", "arty" },
	{ "v2rl", "v2rl", "v2rl", "v2rl", "v2rl" },
	{ "pt", "pt", "pt", "pt", "pt" },
	{ "pt", "pt", "pt", "pt", "pt" },
	{ "dd", "dd", "dd", "dd", "dd" },
	{ "ca", "ca", "ca", "ca", "ca" }
	
}

HardUnitTypes =
{
	{ "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3" },
	{ "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk", "4tnk" }
}

HelicopterType = 1

InfantryRallypoints = { InfantryRallypoint1, InfantryRallypoint2 }
VehicleRallypoints = { VehicleRallypoint1, VehicleRallypoint2, VehicleRallypoint3 }

CheckExistenceForFAC1 = function()
	ConYard = Map.ActorsInBox(MCVTopLeft.CenterPosition, MCVBottomRight.CenterPosition, function(actor)
		return actor.Type == "fact" and actor.Owner == Player1
	end)

	return #ConYard >= 1
end

CheckHealth = function()
	if Map.LobbyOption("difficulty") == "hard" or Map.LobbyOption("difficulty") == "normal" then
		CheckHealthForFAC1()
		CheckHealthForPOW1()
		CheckHealthForAP01()
		CheckHealthForAP02()
		CheckHealthForAP03()
		CheckHealthForAP04()
		CheckHealthForAP05()
		CheckHealthForAP06()
		CheckHealthForAP07()
		CheckHealthForAP08()
		CheckHealthForAP09()
		CheckHealthForAP10()
		CheckHealthForAP11()
		CheckHealthForAP12()
		CheckHealthForAP13()
		CheckHealthForAP14()
		CheckHealthForAP15()
		CheckHealthForAP16()
		CheckHealthForTEN1()
		CheckHealthForBAR1()
		CheckHealthForKEN1()
		CheckHealthForWEA1()
		CheckHealthForHPA1()
		CheckHealthForAFL1()
		CheckHealthForSYR1()
		CheckHealthForSPE1()
		CheckHealthForPBO1()
		CheckHealthForPBO2()
		CheckHealthForHBO1()
		CheckHealthForHBO2()
		CheckHealthForGUN1()
		CheckHealthForGUN2()
		CheckHealthForFTU1()
		CheckHealthForFTU2()
		CheckHealthForTSL1()
		CheckHealthForTSL2()
		CheckHealthForAG01()
		CheckHealthForAG02()
		CheckHealthForAG03()
		CheckHealthForAG04()
		CheckHealthForAG05()
		CheckHealthForAG06()
		CheckHealthForAG07()
		CheckHealthForAG08()
		CheckHealthForAG09()
		CheckHealthForAG10()
		CheckHealthForAG11()
		CheckHealthForSA01()
		CheckHealthForSA02()
		CheckHealthForSA03()
		CheckHealthForSA04()
		CheckHealthForSA05()
		CheckHealthForSA06()
		CheckHealthForSA07()
		CheckHealthForSA08()
		CheckHealthForSA09()
		CheckHealthForSA10()
		CheckHealthForSA11()
		CheckHealthForGA01()
		CheckHealthForGA02()
		CheckHealthForGA03()
		CheckHealthForGA04()
		CheckHealthForGA05()
		CheckHealthForGA06()
		CheckHealthForGA07()
		CheckHealthForGA08()
		CheckHealthForGA09()
		CheckHealthForGA10()
		CheckHealthForGA11()
		CheckHealthForPRO1()
		CheckHealthForPRO2()
		CheckHealthForPRO3()
		CheckHealthForPRO4()
		CheckHealthForSIL1()
		CheckHealthForSIL2()
		CheckHealthForSIL3()
		CheckHealthForSIL4()
		CheckHealthForFIX1()
		CheckHealthForDOM1()
		CheckHealthForATE1()
		CheckHealthForSTE1()
		CheckHealthForPDO1()
		CheckHealthForIRO1()
		CheckHealthForMSL1()
	end
end

CheckHealthForFAC1 = function()
	Trigger.OnDamaged(FAC1, function()
		if FAC1.Owner == Player1 and FAC1.Health < FAC1.MaxHealth * 3/4 then
			FAC1.StartBuildingRepairs()
		end
		if FAC1.Owner == Player1 and FAC1.Health < FAC1.MaxHealth * 1/4 then
			FAC1.Sell()
		end
	end)
end

Debug = function()
	if FIXExists then
		Media.DisplayMessage("1", "Battlefield Control")
	end
	if not FIXExists then
		Media.DisplayMessage("0", "Battlefield Control")
	end
end

ConsiderLastUnitProduction = function()
	if AdditionalUnitProductionDisabled then
		return
	end

	if not CheckExistenceForFAC1() and not FIXExists and not WEAPExists then
		TENP.Destroy()
		BARP.Destroy()
		KENP.Destroy()
		WEAP.Destroy()
		HPAP.Destroy()
		AFLP.Destroy()
		SYRP.Destroy()
		SPEP.Destroy()
		AGP1.Destroy()
		AGP2.Destroy()
		AGP3.Destroy()
		AGP4.Destroy()
		AGP5.Destroy()
		FTUP.Destroy()
		PROP.Destroy()
		FIXP.Destroy()
		DOMP.Destroy()
		ATEP.Destroy()
		STEP.Destroy()
		AdditionalUnitProductionDisabled = true
	end
end

ProduceHelicopter = function()
	if HelicopterType == 1 then
		local Helicopter = Player1.GetActorsByType("hind")

		if #Helicopter == 0 then
			Player1.Build( { "hind" } , function(units)
				Utils.Do(units, function(unit)
					if not unit.IsDead then
						if unit.AmmoCount() > 0 then
							unit.Hunt()
						else
							unit.ReturnToBase()
						end
					end
				end)
			end)
		end

		Utils.Do(Helicopter, function(unit)
			unit.Hunt()
			Trigger.OnRemovedFromWorld(unit, function() HelicopterType = 2 end)
		end)
	end
	if HelicopterType == 2 then
		local Helicopter = Player1.GetActorsByType("heli")

		if #Helicopter == 0 then
			Player1.Build( { "heli" } , function(units)
				Utils.Do(units, function(unit)
					if not unit.IsDead then
						if unit.AmmoCount() > 0 then
							unit.Hunt()
						else
							unit.ReturnToBase()
						end
					end 
				end)
			end)
		end

		Utils.Do(Helicopter, function(unit)
			unit.Hunt()
			Trigger.OnRemovedFromWorld(unit, function() HelicopterType = 1 end)
		end)
	end
end

ProduceArmy = function()
	if Map.LobbyOption("difficulty") == "normal" or Map.LobbyOption("difficulty") == "easy" then
		local toBuild = Utils.Random(NormalUnitTypes)
		Player1.Build( toBuild, function(units)
			CreateTeam(units)
		end)
	end
	if Map.LobbyOption("difficulty") == "hard" then
		local toBuild = Utils.Random(HardUnitTypes)
		Player1.Build( toBuild, function(units)
			CreateTeam(units)
		end)
	end
end

CreateTeam = function(units)
	Utils.Do(units, function(unit)
		SendAttack(unit)
	end)
end

SendAttack = function(unit)
	if not unit.IsDead then
		Trigger.OnIdle(unit, unit.Hunt) 
	end 
end

ControlInfantryRallypoints = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local TentFound = Player1.GetActorsByType("tent")

		Utils.Do(TentFound, function(unit)
			unit.RallyPoint = Utils.Random(InfantryRallypoints).Location
		end)
	end)
end

ControlVehicleRallypoints = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local WeapFound = Player1.GetActorsByType("weap")

		Utils.Do(WeapFound, function(unit)
			unit.RallyPoint = Utils.Random(VehicleRallypoints).Location
		end)
	end)
end

ShowMissionDetails = function()
	Media.DisplayMessage("There is an additional side ready for challenge.", "Battlefield Control")
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("Besides other possible opponents also Blue Group must be defeated in order to accomplish this mission.", "Battlefield Control")
	end)
end

CheckExistenceForInitialUnits = function()
	GuardExists = true
	Guard1Exists = true
	Guard2Exists = true
	Guard3Exists = true
	Guard4Exists = true

	Trigger.OnKilled(Guard, function() GuardExists = false end)
	Trigger.OnKilled(Guard1, function() Guard1Exists = false end)
	Trigger.OnKilled(Guard2, function() Guard2Exists = false end)
	Trigger.OnKilled(Guard3, function() Guard3Exists = false end)
	Trigger.OnKilled(Guard4, function() Guard4Exists = false end)
end

SendDefence = function()
	local defenders = Player1.GetGroundAttackers()
	if #defenders > 0 then
		Utils.Do(defenders, function(unit)
			unit.Hunt()

			if GuardExists then
				Guard.Stop()
			end
			if Guard1Exists then
				Guard1.Stop()
			end
			if Guard2Exists then
				Guard2.Stop()
			end
			if Guard3Exists then
				Guard3.Stop()
			end
			if Guard4Exists then
				Guard4.Stop()
			end
		end)
	end
end

ConsiderProtectionForHarvesters = function()
	Trigger.AfterDelay(DateTime.Seconds(60), function()
		DisableProtectionForHarvesters = false
		CheckHealthForHarvesters()
	end)
end

CheckHealthForHarvesters = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local Harvester = Player1.GetActorsByType("harv")

		Utils.Do(Harvester, function(unit)
			Trigger.OnDamaged(unit, function()
				if not DisableProtectionForHarvesters then
					SendDefence()
					DisableProtectionForHarvesters = true
				end
			end)
		end)
	end)
end

ConsiderHarvesterProduction = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local Harvester = Player1.GetActorsByType("harv")

		if #Harvester < 2 then
			HarvesterNeeded = true
			Player1.Build({ "harv" }, function(harv)
				harv[1].FindResources()

				CheckHealthForHarvesters()
				ConsiderProtectionForHarvesters()
			end)
		end
		if #Harvester > 1 then
			HarvesterNeeded = false
		end
	end)
end

WorldLoaded = function()
	Player1 = Player.GetPlayer("Blue Group")
	Player1.Cash = 0
	
	Player2 = Player.GetPlayer("Multi0")
	Player3 = Player.GetPlayer("Multi1")
	Player4 = Player.GetPlayer("Multi2")
	Player5 = Player.GetPlayer("Multi3")
	Player6 = Player.GetPlayer("Multi4")
	Player7 = Player.GetPlayer("Multi5")
	Player8 = Player.GetPlayer("Multi6")
	Player9 = Player.GetPlayer("Multi7")

	ShowMissionDetails()
	CheckHealth()
	CheckExistenceForInitialUnits()
	CheckHealthForHarvesters()
	ConsiderProtectionForHarvesters()
end

Tick = function()
	if DateTime.GameTime % 100 == 0 then
		ControlInfantryRallypoints()
		ControlVehicleRallypoints()

		--Debug()
		ConsiderLastUnitProduction()
		ProduceHelicopter()
		ProduceArmy()
		ConsiderHarvesterProduction()
	end
end