ChooseFTU1 =
{
	{ type = "ftur", pos = CPos.New(152, 83), cost = 600 }
}

BuildFTU1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseFTU1) do
		if not v.exists then
			PlaceFTU1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildFTU1)
end

PlaceFTU1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildFTU1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildFTU1)
	end)
end

CheckHealthForFTU1 = function()
	Trigger.OnDamaged(FTU1, function()
		if FTU1.Owner == Player1 and FTU1.Health < FTU1.MaxHealth * 3/4 then
			FTU1.StartBuildingRepairs()
		end
		if FTU1.Owner == Player1 and FTU1.Health < FTU1.MaxHealth * 1/4 then
			FTU1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(FTU1, BuildFTU1)
end

ChooseFTU2 =
{
	{ type = "ftur", pos = CPos.New(40, 89), cost = 600 }
}

BuildFTU2 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseFTU2) do
		if not v.exists then
			PlaceFTU2(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildFTU2)
end

PlaceFTU2 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildFTU2)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildFTU2)
	end)
end

CheckHealthForFTU2 = function()
	Trigger.OnDamaged(FTU2, function()
		if FTU2.Owner == Player1 and FTU2.Health < FTU2.MaxHealth * 3/4 then
			FTU2.StartBuildingRepairs()
		end
		if FTU2.Owner == Player1 and FTU2.Health < FTU2.MaxHealth * 1/4 then
			FTU2.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(FTU2, BuildFTU2)
end