ChooseGUN1 =
{
	{ type = "gun", pos = CPos.New(40, 87), cost = 800 }
}

BuildGUN1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseGUN1) do
		if not v.exists then
			PlaceGUN1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildGUN1)
end

PlaceGUN1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildGUN1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildGUN1)
	end)
end

CheckHealthForGUN1 = function()
	Trigger.OnDamaged(GUN1, function()
		if GUN1.Owner == Player1 and GUN1.Health < GUN1.MaxHealth * 3/4 then
			GUN1.StartBuildingRepairs()
		end
		if GUN1.Owner == Player1 and GUN1.Health < GUN1.MaxHealth * 1/4 then
			GUN1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(GUN1, BuildGUN1)
end

ChooseGUN2 =
{
	{ type = "gun", pos = CPos.New(153, 91), cost = 800 }
}

BuildGUN2 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseGUN2) do
		if not v.exists then
			PlaceGUN2(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildGUN2)
end

PlaceGUN2 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildGUN2)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildGUN2)
	end)
end

CheckHealthForGUN2 = function()
	Trigger.OnDamaged(GUN2, function()
		if GUN2.Owner == Player1 and GUN2.Health < GUN2.MaxHealth * 3/4 then
			GUN2.StartBuildingRepairs()
		end
		if GUN2.Owner == Player1 and GUN2.Health < GUN2.MaxHealth * 1/4 then
			GUN2.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(GUN2, BuildGUN2)
end