ChooseTSL1 =
{
	{ type = "tsla", pos = CPos.New(147, 83), cost = 1200 }
}

BuildTSL1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseTSL1) do
		if not v.exists then
			PlaceTSL1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildTSL1)
end

PlaceTSL1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildTSL1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildTSL1)
	end)
end

CheckHealthForTSL1 = function()
	Trigger.OnDamaged(TSL1, function()
		if TSL1.Owner == Player1 and TSL1.Health < TSL1.MaxHealth * 3/4 then
			TSL1.StartBuildingRepairs()
		end
		if TSL1.Owner == Player1 and TSL1.Health < TSL1.MaxHealth * 1/4 then
			TSL1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(TSL1, BuildTSL1)
end

ChooseTSL2 =
{
	{ type = "tsla", pos = CPos.New(43, 86), cost = 1200 }
}

BuildTSL2 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseTSL2) do
		if not v.exists then
			PlaceTSL2(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildTSL2)
end

PlaceTSL2 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildTSL2)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildTSL2)
	end)
end

CheckHealthForTSL2 = function()
	Trigger.OnDamaged(TSL2, function()
		if TSL2.Owner == Player1 and TSL2.Health < TSL2.MaxHealth * 3/4 then
			TSL2.StartBuildingRepairs()
		end
		if TSL2.Owner == Player1 and TSL2.Health < TSL2.MaxHealth * 1/4 then
			TSL2.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(TSL2, BuildTSL2)
end