ChooseSYR1 =
{
	{ type = "syrd", pos = CPos.New(35, 71), cost = 1000 }
}

BuildSYR1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseSYR1) do
		if not v.exists then
			PlaceSYR1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildSYR1)
end

PlaceSYR1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildSYR1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildSYR1)
	end)
end

CheckHealthForSYR1 = function()
	Trigger.OnDamaged(SYR1, function()
		if SYR1.Owner == Player1 and SYR1.Health < SYR1.MaxHealth * 3/4 then
			SYR1.StartBuildingRepairs()
		end
		if SYR1.Owner == Player1 and SYR1.Health < SYR1.MaxHealth * 1/4 then
			SYR1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(SYR1, BuildSYR1)
end