ChoosePOW1 =
{
	{ type = "powr", pos = CPos.New(105, 44), cost = 300 }
}

BuildPOW1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChoosePOW1) do
		if not v.exists then
			PlacePOW1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPOW1)
end

PlacePOW1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildPOW1)
	end)
end

CheckHealthForPOW1 = function()
	Trigger.OnDamaged(POW1, function()
		if POW1.Owner == Player1 and POW1.Health < POW1.MaxHealth * 3/4 then
			POW1.StartBuildingRepairs()
		end
		if POW1.Owner == Player1 and POW1.Health < POW1.MaxHealth * 1/4 then
			POW1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(POW1, BuildPOW1)
end